/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TrainedModelInferenceClassImportance;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelInferenceFeatureImportance
implements JsonpSerializable {
    private final String featureName;
    @Nullable
    private final Double importance;
    private final List<TrainedModelInferenceClassImportance> classes;
    public static final JsonpDeserializer<TrainedModelInferenceFeatureImportance> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelInferenceFeatureImportance::setupTrainedModelInferenceFeatureImportanceDeserializer);

    private TrainedModelInferenceFeatureImportance(Builder builder) {
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
        this.importance = builder.importance;
        this.classes = ApiTypeHelper.unmodifiable(builder.classes);
    }

    public static TrainedModelInferenceFeatureImportance of(Function<Builder, ObjectBuilder<TrainedModelInferenceFeatureImportance>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String featureName() {
        return this.featureName;
    }

    @Nullable
    public final Double importance() {
        return this.importance;
    }

    public final List<TrainedModelInferenceClassImportance> classes() {
        return this.classes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        if (this.importance != null) {
            generator.writeKey("importance");
            generator.write(this.importance);
        }
        if (ApiTypeHelper.isDefined(this.classes)) {
            generator.writeKey("classes");
            generator.writeStartArray();
            for (TrainedModelInferenceClassImportance item0 : this.classes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelInferenceFeatureImportanceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
        op.add(Builder::importance, JsonpDeserializer.doubleDeserializer(), "importance");
        op.add(Builder::classes, JsonpDeserializer.arrayDeserializer(TrainedModelInferenceClassImportance._DESERIALIZER), "classes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelInferenceFeatureImportance> {
        private String featureName;
        @Nullable
        private Double importance;
        @Nullable
        private List<TrainedModelInferenceClassImportance> classes;

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public final Builder importance(@Nullable Double value) {
            this.importance = value;
            return this;
        }

        public final Builder classes(List<TrainedModelInferenceClassImportance> list) {
            this.classes = Builder._listAddAll(this.classes, list);
            return this;
        }

        public final Builder classes(TrainedModelInferenceClassImportance value, TrainedModelInferenceClassImportance ... values) {
            this.classes = Builder._listAdd(this.classes, value, values);
            return this;
        }

        public final Builder classes(Function<TrainedModelInferenceClassImportance.Builder, ObjectBuilder<TrainedModelInferenceClassImportance>> fn) {
            return this.classes(fn.apply(new TrainedModelInferenceClassImportance.Builder()).build(), new TrainedModelInferenceClassImportance[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelInferenceFeatureImportance build() {
            this._checkSingleUse();
            return new TrainedModelInferenceFeatureImportance(this);
        }
    }
}

