/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AlibabaCloudServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    private final String host;
    @Nullable
    private final RateLimitSetting rateLimit;
    private final String serviceId;
    private final String workspace;
    public static final JsonpDeserializer<AlibabaCloudServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AlibabaCloudServiceSettings::setupAlibabaCloudServiceSettingsDeserializer);

    private AlibabaCloudServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.rateLimit = builder.rateLimit;
        this.serviceId = ApiTypeHelper.requireNonNull(builder.serviceId, this, "serviceId");
        this.workspace = ApiTypeHelper.requireNonNull(builder.workspace, this, "workspace");
    }

    public static AlibabaCloudServiceSettings of(Function<Builder, ObjectBuilder<AlibabaCloudServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String host() {
        return this.host;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String workspace() {
        return this.workspace;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        generator.writeKey("host");
        generator.write(this.host);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        generator.writeKey("service_id");
        generator.write(this.serviceId);
        generator.writeKey("workspace");
        generator.write(this.workspace);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAlibabaCloudServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::serviceId, JsonpDeserializer.stringDeserializer(), "service_id");
        op.add(Builder::workspace, JsonpDeserializer.stringDeserializer(), "workspace");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AlibabaCloudServiceSettings> {
        private String apiKey;
        private String host;
        @Nullable
        private RateLimitSetting rateLimit;
        private String serviceId;
        private String workspace;

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder serviceId(String value) {
            this.serviceId = value;
            return this;
        }

        public final Builder workspace(String value) {
            this.workspace = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AlibabaCloudServiceSettings build() {
            this._checkSingleUse();
            return new AlibabaCloudServiceSettings(this);
        }
    }
}

