/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.Node;
import org.apache.derby.impl.store.access.sort.NodeAllocator;
import org.apache.derby.shared.common.error.StandardException;

class SortBuffer {
    public static final int INSERT_OK = 0;
    public static final int INSERT_DUPLICATE = 1;
    public static final int INSERT_FULL = 2;
    private MergeSort sort;
    private NodeAllocator allocator = null;
    private Node head = null;
    private int height = 0;
    private DataValueDescriptor[] deletedKey;
    private boolean subtreeShrunk;
    private int nextAux;
    private int lastAux;

    void setNextAux(int aux) {
        this.nextAux = aux;
    }

    int getLastAux() {
        return this.lastAux;
    }

    SortBuffer(MergeSort sort) {
        this.sort = sort;
    }

    boolean init() {
        this.allocator = new NodeAllocator();
        boolean initOK = false;
        initOK = this.sort.sortBufferMin > 0 ? this.allocator.init(this.sort.sortBufferMin, this.sort.sortBufferMax) : this.allocator.init(this.sort.sortBufferMax);
        if (!initOK) {
            this.allocator = null;
            return false;
        }
        this.reset();
        return true;
    }

    void reset() {
        this.allocator.reset();
        this.head = this.allocator.newNode();
        this.height = 0;
    }

    void close() {
        if (this.allocator != null) {
            this.allocator.close();
        }
        this.allocator = null;
        this.height = 0;
        this.head = null;
    }

    void grow(int percent) {
        if (percent > 0) {
            this.allocator.grow(percent);
        }
    }

    int capacity() {
        if (this.allocator == null) {
            return 0;
        }
        return this.allocator.capacity() - 1;
    }

    int insert(DataValueDescriptor[] k) throws StandardException {
        int a;
        Node q;
        int c;
        Node s;
        if (this.head.rightLink == null) {
            if (this.sort.sortObserver != null && (k = this.sort.sortObserver.insertNonDuplicateKey(k)) == null) {
                return 1;
            }
            Node q2 = this.allocator.newNode();
            q2.key = k;
            q2.aux = this.nextAux;
            this.head.rightLink = q2;
            this.height = 1;
            return 0;
        }
        Node t = this.head;
        Node p = s = this.head.rightLink;
        while (true) {
            if ((c = this.sort.compare(k, p.key)) == 0) {
                if (this.sort.sortObserver != null && (k = this.sort.sortObserver.insertDuplicateKey(k, p.key)) == null) {
                    return 1;
                }
                q = this.allocator.newNode();
                if (q == null) {
                    return 2;
                }
                q.aux = this.nextAux;
                q.key = k;
                q.dupChain = p.dupChain;
                p.dupChain = q;
                return 0;
            }
            if (c < 0) {
                q = p.leftLink;
                if (q == null) {
                    q = this.allocator.newNode();
                    if (q == null) {
                        return 2;
                    }
                    q.aux = this.nextAux;
                    p.leftLink = q;
                    break;
                }
            } else {
                q = p.rightLink;
                if (q == null) {
                    q = this.allocator.newNode();
                    if (q == null) {
                        return 2;
                    }
                    q.aux = this.nextAux;
                    p.rightLink = q;
                    break;
                }
            }
            if (q.balance != 0) {
                t = p;
                s = q;
            }
            p = q;
        }
        if (this.sort.sortObserver != null && (k = this.sort.sortObserver.insertNonDuplicateKey(k)) == null) {
            return 1;
        }
        q.key = k;
        c = this.sort.compare(k, s.key);
        Node r = c < 0 ? (p = s.leftLink) : (p = s.rightLink);
        while (p != q) {
            if (this.sort.compare(k, p.key) < 0) {
                p.balance = -1;
                p = p.leftLink;
                continue;
            }
            p.balance = 1;
            p = p.rightLink;
        }
        int n = c > 0 ? 1 : (a = c == 0 ? 0 : -1);
        if (s.balance == 0) {
            s.balance = a;
            ++this.height;
            return 0;
        }
        if (s.balance == -a) {
            s.balance = 0;
            return 0;
        }
        if (r.balance == a) {
            p = r;
            s.setLink(a, r.link(-a));
            r.setLink(-a, s);
            s.balance = 0;
            r.balance = 0;
        } else {
            p = r.link(-a);
            r.setLink(-a, p.link(a));
            p.setLink(a, r);
            s.setLink(a, p.link(-a));
            p.setLink(-a, s);
            if (p.balance == a) {
                s.balance = -a;
                r.balance = 0;
            } else if (p.balance == 0) {
                s.balance = 0;
                r.balance = 0;
            } else {
                s.balance = 0;
                r.balance = a;
            }
            p.balance = 0;
        }
        if (s == t.rightLink) {
            t.rightLink = p;
        } else {
            t.leftLink = p;
        }
        return 0;
    }

    DataValueDescriptor[] removeFirst() {
        if (this.head.rightLink == null) {
            return null;
        }
        this.head.rightLink = this.deleteLeftmost(this.head.rightLink);
        if (this.subtreeShrunk) {
            --this.height;
        }
        return this.deletedKey;
    }

    private Node deleteLeftmost(Node thisNode) {
        if (thisNode.leftLink == null) {
            if (thisNode.dupChain != null) {
                Node dupNode = thisNode.dupChain;
                this.deletedKey = dupNode.key;
                this.lastAux = dupNode.aux;
                thisNode.dupChain = dupNode.dupChain;
                this.allocator.freeNode(dupNode);
                dupNode = null;
                this.subtreeShrunk = false;
                return thisNode;
            }
            this.deletedKey = thisNode.key;
            this.lastAux = thisNode.aux;
            this.subtreeShrunk = true;
            Node newRoot = thisNode.rightLink;
            this.allocator.freeNode(thisNode);
            return newRoot;
        }
        thisNode.leftLink = this.deleteLeftmost(thisNode.leftLink);
        if (!this.subtreeShrunk) {
            return thisNode;
        }
        if (thisNode.balance == 1) {
            return this.rotateRight(thisNode);
        }
        if (thisNode.balance == -1) {
            thisNode.balance = 0;
            this.subtreeShrunk = true;
        } else {
            thisNode.balance = 1;
            this.subtreeShrunk = false;
        }
        return thisNode;
    }

    private Node rotateRight(Node thisNode) {
        Node a = thisNode;
        Node b = thisNode.rightLink;
        if (b.balance >= 0) {
            a.rightLink = b.leftLink;
            b.leftLink = a;
            if (b.balance == 0) {
                a.balance = 1;
                b.balance = -1;
                this.subtreeShrunk = false;
            } else {
                a.balance = 0;
                b.balance = 0;
                this.subtreeShrunk = true;
            }
            return b;
        }
        Node x = b.leftLink;
        a.rightLink = x.leftLink;
        x.leftLink = a;
        b.leftLink = x.rightLink;
        x.rightLink = b;
        if (x.balance == 1) {
            a.balance = -1;
            b.balance = 0;
        } else if (x.balance == -1) {
            a.balance = 0;
            b.balance = 1;
        } else {
            a.balance = 0;
            b.balance = 0;
        }
        x.balance = 0;
        this.subtreeShrunk = true;
        return x;
    }

    public void check() {
        Object error = null;
        if (this.head.rightLink == null) {
            if (this.height != 0) {
                error = "empty tree with height " + this.height;
            }
        } else {
            error = this.depth(this.head.rightLink) != this.height ? "tree height " + this.height + " != depth " + this.depth(this.head.rightLink) : this.checkNode(this.head.rightLink);
        }
        if (error != null) {
            System.out.println("ERROR: " + (String)error);
            this.print();
            System.exit(1);
        }
    }

    private String checkNode(Node n) {
        if (n == null) {
            return null;
        }
        int ld = this.depth(n.leftLink);
        int rd = this.depth(n.rightLink);
        if (n.balance != rd - ld) {
            return "node " + String.valueOf(n) + ": left height " + ld + " right height " + rd;
        }
        String e = this.checkNode(n.rightLink);
        if (e == null) {
            e = this.checkNode(n.leftLink);
        }
        return e;
    }

    private int depth(Node n) {
        int ld = 0;
        int rd = 0;
        if (n == null) {
            return 0;
        }
        if (n.leftLink != null) {
            ld = this.depth(n.leftLink);
        }
        if (n.rightLink != null) {
            rd = this.depth(n.rightLink);
        }
        if (rd > ld) {
            return rd + 1;
        }
        return ld + 1;
    }

    public void print() {
        Node root = this.head.rightLink;
        System.out.println("tree height: " + this.height + " root: " + (root == null ? -1 : root.id));
        if (root != null) {
            this.printRecursive(root, 0);
        }
    }

    private void printRecursive(Node n, int depth) {
        if (n.rightLink != null) {
            this.printRecursive(n.rightLink, depth + 1);
        }
        for (int i = 0; i < depth; ++i) {
            System.out.print("       ");
        }
        System.out.println(n);
        if (n.leftLink != null) {
            this.printRecursive(n.leftLink, depth + 1);
        }
    }

    private void debug(String s) {
        System.out.println(" === [" + s + "] ===");
    }
}

