/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealGroupedAggregateStatistics
extends RealNoPutResultSetStatistics {
    public int rowsInput;
    public boolean hasDistinctAggregate;
    public boolean inSortedOrder;
    public ResultSetStatistics childResultSetStatistics;
    public Properties sortProperties;

    public RealGroupedAggregateStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int rowsInput, boolean hasDistinctAggregate, boolean inSortedOrder, Properties sortProperties, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.rowsInput = rowsInput;
        this.hasDistinctAggregate = hasDistinctAggregate;
        this.inSortedOrder = inSortedOrder;
        this.childResultSetStatistics = childResultSetStatistics;
        this.sortProperties = new Properties();
        Enumeration<Object> e = sortProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.sortProperties.put(key, sortProperties.get(key));
        }
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        String sortInfo = this.inSortedOrder ? "" : this.indent + MessageService.getTextMessage((String)"43X40.U", (Object[])new Object[0]) + ": \n" + PropertyUtil.sortProperties(this.sortProperties, this.subIndent);
        return this.indent + MessageService.getTextMessage((String)"43X41.U", (Object[])new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage((String)"43X03.U", (Object[])new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage((String)"43X21.U", (Object[])new Object[0]) + " = " + this.rowsInput + "\n" + this.indent + MessageService.getTextMessage((String)"43X42.U", (Object[])new Object[0]) + " = " + this.hasDistinctAggregate + "\n" + this.indent + MessageService.getTextMessage((String)"43X43.U", (Object[])new Object[0]) + " = " + this.inSortedOrder + "\n" + sortInfo + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage((String)"43X05.U", (Object[])new Object[0]) + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        return this.childResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.childResultSetStatistics);
        return children;
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage((String)"43X44.U", (Object[])new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.childResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "GROUPBY";
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, null, null, (UUID)parentID, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, this.rowsInput, this.rowsSeen, null, this.rowsFiltered, null, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }

    @Override
    public Object getSortPropsDescriptor(Object sortPropsID) {
        Properties props = this.sortProperties;
        XPLAINSortPropsDescriptor sortRSDescriptor = new XPLAINSortPropsDescriptor((UUID)sortPropsID, null, null, null, null, null, null, XPLAINUtil.getYesNoCharFromBoolean(this.inSortedOrder), XPLAINUtil.getYesNoCharFromBoolean(this.hasDistinctAggregate));
        return XPLAINUtil.extractSortProps(sortRSDescriptor, props);
    }
}

