/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.monitor;

import java.io.PrintWriter;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.services.monitor.FileMonitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.info.ProductVersionHolder;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public class Monitor {
    public static final String SERVICE_TYPE_DIRECTORY = "serviceDirectory";
    public static final Object syncMe = new Object();
    public static final String NEW_INSTANCE_FROM_ID_TRACE_DEBUG_FLAG = "MonitorNewInstanceFromId";
    public static final String DEBUG_TRUE = "derby.debug.true";
    public static final String DEBUG_FALSE = "derby.debug.false";
    private static ModuleFactory monitor;
    private static boolean active;

    public static void startMonitor(Properties bootProperties, PrintWriter logging) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        try {
            new FileMonitor(bootProperties, logging);
        }
        catch (AccessControlException e) {
            Monitor.clearMonitor();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMonitor(ModuleFactory theMonitor) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object = syncMe;
        synchronized (object) {
            if (active) {
                return false;
            }
            monitor = theMonitor;
            active = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMonitor() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object = syncMe;
        synchronized (object) {
            active = false;
        }
    }

    public static ModuleFactory getMonitor() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleFactory getMonitorLite() {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object object = syncMe;
        synchronized (object) {
            if (active && monitor != null) {
                return monitor;
            }
        }
        return new FileMonitor();
    }

    public static HeaderPrintWriter getStream() {
        return monitor.getSystemStreams().stream();
    }

    public static String getServiceName(Object serviceModule) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor.getServiceName(serviceModule);
    }

    public static Object startSystemModule(String factoryInterface) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object module = monitor.startModule(false, null, factoryInterface, null, null);
        SanityManager.ASSERT((module != null ? 1 : 0) != 0, (String)("module is null - " + factoryInterface));
        return module;
    }

    public static Object findSystemModule(String factoryInterface) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object module = Monitor.getMonitor().findModule(null, factoryInterface, null);
        if (module == null) {
            throw Monitor.missingImplementation(factoryInterface);
        }
        return module;
    }

    public static Object getSystemModule(String factoryInterface) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        ModuleFactory monitor = Monitor.getMonitor();
        if (monitor == null) {
            return null;
        }
        Object module = monitor.findModule(null, factoryInterface, null);
        return module;
    }

    public static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object module = monitor.startModule(create, serviceModule, factoryInterface, null, properties);
        SanityManager.ASSERT((module != null ? 1 : 0) != 0, (String)("module is null - " + factoryInterface));
        return module;
    }

    public static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, String identifier, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object module = monitor.startModule(create, serviceModule, factoryInterface, identifier, properties);
        SanityManager.ASSERT((module != null ? 1 : 0) != 0, (String)("module is null - " + factoryInterface));
        return module;
    }

    public static Object findServiceModule(Object serviceModule, String factoryInterface) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object module = Monitor.getMonitor().findModule(serviceModule, factoryInterface, null);
        if (module == null) {
            throw Monitor.missingImplementation(factoryInterface);
        }
        return module;
    }

    public static Object getServiceModule(Object serviceModule, String factoryInterface) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        Object module = Monitor.getMonitor().findModule(serviceModule, factoryInterface, null);
        return module;
    }

    public static Object findService(String factoryInterface, String serviceName) {
        SecurityUtil.checkDerbyInternalsPrivilege();
        return monitor.findService(factoryInterface, serviceName);
    }

    public static boolean startPersistentService(String serviceName, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        SanityManager.ASSERT((serviceName != null ? 1 : 0) != 0, (String)"serviceName is null");
        return monitor.startPersistentService(serviceName, properties);
    }

    public static Object startNonPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        SanityManager.ASSERT((factoryInterface != null ? 1 : 0) != 0, (String)"serviceName is null");
        SanityManager.ASSERT((serviceName != null ? 1 : 0) != 0, (String)"serviceName is null");
        return monitor.startNonPersistentService(factoryInterface, serviceName, properties);
    }

    public static Object createPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        SanityManager.ASSERT((factoryInterface != null ? 1 : 0) != 0, (String)"serviceName is null");
        SanityManager.ASSERT((serviceName != null ? 1 : 0) != 0, (String)"serviceName is null");
        return monitor.createPersistentService(factoryInterface, serviceName, properties);
    }

    public static void removePersistentService(String name) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        if (!name.startsWith("memory:")) {
            throw StandardException.newException((String)"XBM0I.D", (Object[])new Object[]{name});
        }
        monitor.removePersistentService(name);
    }

    public static InstanceGetter classFromIdentifier(int identifier) throws StandardException {
        return monitor.classFromIdentifier(identifier);
    }

    public static Object newInstanceFromIdentifier(int identifier) throws StandardException {
        return monitor.newInstanceFromIdentifier(identifier);
    }

    public static StandardException missingProductVersion(String productGenusName) {
        return StandardException.newException((String)"XBM05.D", (Object[])new Object[]{productGenusName});
    }

    public static StandardException missingImplementation(String implementation) {
        return StandardException.newException((String)"XBM02.D", (Object[])new Object[]{implementation});
    }

    public static StandardException exceptionStartingModule(Throwable t) {
        return StandardException.newException((String)"XBM01.D", (Throwable)t, (Object[])new Object[0]);
    }

    public static void logMessage(String messageText) {
        Monitor.getStream().println(messageText);
    }

    public static void logTextMessage(String messageID, Object ... args) {
        Monitor.getStream().println(MessageService.getTextMessage((String)messageID, (Object[])args));
    }

    public static Locale getLocaleFromString(String localeDescription) throws StandardException {
        return monitor.getLocaleFromString(localeDescription);
    }

    public static boolean isFullUpgrade(Properties startParams, String oldVersionInfo) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        boolean fullUpgrade = Boolean.valueOf(startParams.getProperty("upgrade"));
        ProductVersionHolder engineVersion = Monitor.getMonitor().getEngineVersion();
        if ((engineVersion.isBeta() || engineVersion.isAlpha()) && !PropertyUtil.getSystemBoolean("derby.database.allowPreReleaseUpgrade")) {
            throw StandardException.newException((String)"XCW00.D", (Object[])new Object[]{oldVersionInfo, engineVersion.getSimpleVersionString()});
        }
        return fullUpgrade;
    }

    public static boolean isDesiredType(Properties startParams, int desiredProperty) {
        int engineType = 2;
        if (startParams != null) {
            engineType = Monitor.getEngineType(startParams);
        }
        return (engineType & desiredProperty) != 0;
    }

    public static boolean isDesiredType(int engineType, int desiredType) {
        return (engineType & desiredType) != 0;
    }

    public static int getEngineType(Properties startParams) {
        if (startParams != null) {
            String etp = startParams.getProperty("derby.engineType");
            int engineType = etp == null ? 2 : Integer.parseInt(etp.trim());
            return engineType;
        }
        return 2;
    }

    public static boolean isDesiredCreateType(Properties p, int type) {
        boolean plainCreate = Boolean.valueOf(p.getProperty("create"));
        if (plainCreate) {
            return (type & 2) != 0;
        }
        return Monitor.isDesiredType(p, type);
    }

    public static void logThrowable(Throwable t) {
        t.printStackTrace(Monitor.getStream().getPrintWriter());
    }
}

