/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u000f\u001f\u0001\rB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011\u00159\u0005\u0001\"\u0001I\u0011\u001dq\u0005A1A\u0005\n=Caa\u0015\u0001!\u0002\u0013\u0001\u0006b\u0002+\u0001\u0005\u0004%I!\u0016\u0005\u0007=\u0002\u0001\u000b\u0011\u0002,\t\u000f}\u0003!\u0019!C\u0005+\"1\u0001\r\u0001Q\u0001\nYCq!\u0019\u0001A\u0002\u0013%!\rC\u0004r\u0001\u0001\u0007I\u0011\u0002:\t\ra\u0004\u0001\u0015)\u0003d\u0011\u001dI\bA1A\u0005BiDaA \u0001!\u0002\u0013Y\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\u0004\u0001!\t%!\u0001\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0001bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\t\u0019\u0006\u0001C!\u0003+Bq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002>\u0002!I!a0\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAn\u0001\u0011\u0005\u0013Q\u001c\u0002\u0014\u0019>\u001c\u0017\r\u001c'fC\u0012,'/\u00128e!>Lg\u000e\u001e\u0006\u0003?\u0001\naa]3sm\u0016\u0014(\"A\u0011\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\n\u0016/!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111\u0006L\u0007\u0002=%\u0011QF\b\u0002\u000f\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u!\ty#'D\u00011\u0015\t\t\u0004%A\u0003vi&d7/\u0003\u00024a\t9Aj\\4hS:<\u0017\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bC\u0001\u001c:\u001b\u00059$B\u0001\u001d!\u0003\u001d\u0019G.^:uKJL!AO\u001c\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\u0006a!M]8lKJ\u001cuN\u001c4jOB\u00111&P\u0005\u0003}y\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\u0016B\u0013\t\u0011eD\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005-*\u0015B\u0001$\u001f\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003\u0019a\u0014N\\5u}Q)\u0011JS&M\u001bB\u00111\u0006\u0001\u0005\u0006i\u0015\u0001\r!\u000e\u0005\u0006w\u0015\u0001\r\u0001\u0010\u0005\u0006\u007f\u0015\u0001\r\u0001\u0011\u0005\u0006\u0007\u0016\u0001\r\u0001R\u0001\ne\u0016\u0004H.[2b\u0013\u0012,\u0012\u0001\u0015\t\u0003KEK!A\u0015\u0014\u0003\u0007%sG/\u0001\u0006sKBd\u0017nY1JI\u0002\n\u0001\"\\1y\u0005f$Xm]\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005Y\u0006twMC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&aB%oi\u0016<WM]\u0001\n[\u0006D()\u001f;fg\u0002\n\u0011BZ3uG\"\u001c\u0016N_3\u0002\u0015\u0019,Go\u00195TSj,\u0007%A\nj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|g.F\u0001d!\r)CMZ\u0005\u0003K\u001a\u0012aa\u00149uS>t\u0007CA4p\u001b\u0005A'BA5k\u0003\u0019\u0019w.\\7p]*\u0011\u0011e\u001b\u0006\u0003Y6\fa!\u00199bG\",'\"\u00018\u0002\u0007=\u0014x-\u0003\u0002qQ\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017aF5o!J|wM]3tgB\u000b'\u000f^5uS>tw\fJ3r)\t\u0019h\u000f\u0005\u0002&i&\u0011QO\n\u0002\u0005+:LG\u000fC\u0004x\u001b\u0005\u0005\t\u0019A2\u0002\u0007a$\u0013'\u0001\u000bj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u001dSN$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*vaB|'\u000f^3e+\u0005Y\bCA\u0013}\u0013\tihEA\u0004C_>dW-\u00198\u0002;%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fI\u0002\nQ\"\u001b8ji&\fG/Z\"m_N,G#A:\u0002\u000b\rdwn]3\u0002\u001d\t\u0014xn[3s\u000b:$\u0007k\\5oiR\tQ'A\u0003gKR\u001c\u0007\u000e\u0006\u0003\u0002\u000e\u0005\u0005\u0002cBA\b\u0003+1\u0017\u0011D\u0007\u0003\u0003#Q1!a\u0005'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003/\t\tBA\u0002NCB\u0004B!a\u0007\u0002\u001e5\t\u0001!C\u0002\u0002 1\u0012\u0011BR3uG\"$\u0015\r^1\t\u000f\u0005\rB\u00031\u0001\u0002&\u0005aa-\u001a;dQJ+\u0017/^3tiB!\u0011qEA\u001a\u001d\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017Q\u0006A!/Z9vKN$8/\u0003\u0003\u00022\u0005-\u0012\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002BA\u001b\u0003o\u0011qAQ;jY\u0012,'O\u0003\u0003\u00022\u0005-\u0012a\u00054fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$HCBA\u001f\u0003\u0007\n9\u0005E\u0002&\u0003\u007fI1!!\u0011'\u0005\u0011auN\\4\t\r\u0005\u0015S\u00031\u0001g\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Da!!\u0013\u0016\u0001\u0004\u0001\u0016AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\f\u0011CZ3uG\"d\u0015\r^3ti>3gm]3u)\u0019\ti$a\u0014\u0002R!1\u0011Q\t\fA\u0002\u0019Da!!\u0013\u0017\u0001\u0004\u0001\u0016\u0001\u00064fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000f\u0006\u0003\u0002X\u0005\u0015\u0005cBA\b\u0003+1\u0017\u0011\f\t\u0005\u00037\nyH\u0004\u0003\u0002^\u0005ed\u0002BA0\u0003krA!!\u0019\u0002t9!\u00111MA9\u001d\u0011\t)'a\u001c\u000f\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b#\u0003\u0019a$o\\8u}%\ta.\u0003\u0002m[&\u0011\u0011e[\u0005\u0003S*L1!a\u001ei\u0003\u001diWm]:bO\u0016LA!a\u001f\u0002~\u0005\u0001sJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0015\r\t9\b[\u0005\u0005\u0003\u0003\u000b\u0019I\u0001\bFa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;\u000b\t\u0005m\u0014Q\u0010\u0005\b\u0003\u000f;\u0002\u0019AAE\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\b\u0003\u001f\t)BZAF!\u0011\tY\"!$\n\u0007\u0005=EFA\u0005Fa>\u001c\u0007\u000eR1uC\u0006Q!-^5mI\u001a+Go\u00195\u0015\t\u0005U\u00151\u0017\t\u0007\u0003/\u000b)+a+\u000f\t\u0005e\u0015\u0011\u0015\b\u0005\u00037\u000byJ\u0004\u0003\u0002h\u0005u\u0015\"A\u0011\n\u0005}\u0001\u0013bAAR=\u0005)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0002BAT\u0003S\u0013ACU3tk2$x+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c(bAAR=A!Q\u0005ZAW!\u0011\t9*a,\n\t\u0005E\u0016\u0011\u0016\u0002\r%\u0016\u0004H.[2b\r\u0016$8\r\u001b\u0005\b\u0003\u000fC\u0002\u0019AA[!\u001d\ty!!\u0006g\u0003o\u00032aKA]\u0013\r\tYL\b\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/Z\u0001\u0017g\u0016dWm\u0019;QCJ$\u0018\u000e^5p]R{g)\u001a;dQR!\u0011\u0011YAe!\u0011)C-a1\u0011\r\u0015\n)MZA\\\u0013\r\t9M\n\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u001d\u0015\u00041\u0001\u00026\u00061\"-^5mI\u001a+Go\u00195G_J\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002\u0016\u0006=\u0017\u0011\u001b\u0005\u0007\u0003\u000bR\u0002\u0019\u00014\t\u000f\u0005M'\u00041\u0001\u00028\u0006Qa-\u001a;dQN#\u0018\r^3\u0002%9,\u0007\u0010\u001e*fC\u0012L\b+\u0019:uSRLwN\u001c\u000b\u0005\u0003\u0003\fI\u000eC\u0004\u0002\bn\u0001\r!!.\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a8\u0011\t\u0005\u0005\u0018\u0011\u001e\b\u0005\u0003G\f)\u000fE\u0002\u0002h\u0019J1!a:'\u0003\u0019\u0001&/\u001a3fM&!\u00111^Aw\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u001d\u0014")
public class LocalLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BrokerEndPoint sourceBroker;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private final boolean isTruncationOnFetchSupported;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public void initiateClose() {
    }

    @Override
    public void close() {
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        HashMap topicNames = new HashMap();
        request.data().topics().forEach(topic -> topicNames.put((Object)topic.topicId(), (Object)topic.topic()));
        java.util.Map fetchData = request.fetchData((java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)topicNames).asJava());
        short x$1 = request.version();
        long x$2 = 0L;
        int x$3 = Request$.MODULE$.FutureLocalReplicaId();
        int x$4 = request.minBytes();
        int x$5 = request.maxBytes();
        FetchLogEnd$ x$6 = FetchLogEnd$.MODULE$;
        None$ x$7 = None$.MODULE$;
        FetchParams fetchParams = new FetchParams(x$1, x$3, x$2, x$4, x$5, x$6, (Option<ClientMetadata>)x$7);
        this.replicaManager.fetchMessages(fetchParams, (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(fetchData).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            LocalLeaderEndPoint.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        });
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(fetchData.keySet().toArray())).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public long fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.replicaManager.getPartitionOrException(topicPartition).localLogOrException().logStartOffset();
    }

    @Override
    public long fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.replicaManager.getPartitionOrException(topicPartition).localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaManager.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitions);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            resultWithPartitions = this.buildFetchForPartition(tp, fetchState);
        } else if (None$.MODULE$.equals(option)) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)Set$.MODULE$.empty());
        } else {
            throw new MatchError(option);
        }
        return resultWithPartitions;
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$1(partitions, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitions);
            nextPartitionOpt.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$4(this, partitions, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition topicPartition, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaManager.futureLocalLogOrException(topicPartition).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$3 -> LocalLeaderEndPoint.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt((Object)x$3))))) : Optional.empty();
            Uuid topicId = (Uuid)fetchState.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
            requestMap.put(topicPartition, new FetchRequest.PartitionData(topicId, fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            partitionsWithError.$plus$eq((Object)topicPartition);
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)(fetchState.topicId().isEmpty() ? (short)12 : (short)ApiKeys.FETCH.latestVersion()), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitions) {
        return ((TraversableOnce)partitions.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LocalLeaderEndPoint.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$less((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    public String toString() {
        return "LocalLeaderEndPoint";
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            FetchPartitionData data = (FetchPartitionData)x0$1._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable & scala.Serializable)x$1 -> (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(data.error().code()).setHighWatermark(data.highWatermark()).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset()).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records()));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitions$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitions$1.get((Object)tp).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch())).foreach((Function1 & Serializable & scala.Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(LocalLeaderEndPoint $this, Map partitions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitions$1.size()).append(" remaining partitions to copy by this thread.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        return bl;
    }

    public LocalLeaderEndPoint(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.sourceBroker = sourceBroker;
        this.replicaManager = replicaManager;
        this.quota = quota;
        Logging.$init$(this);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
        this.isTruncationOnFetchSupported = false;
    }
}

