/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.PKeyDH;
import org.jruby.ext.openssl.PKeyDSA;
import org.jruby.ext.openssl.PKeyEC;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public abstract class PKey
extends RubyObject {
    private static final long serialVersionUID = 6114668087816965720L;

    static void createPKey(Ruby runtime, RubyModule OpenSSL2, RubyClass OpenSSLError) {
        RubyModule PKey2 = OpenSSL2.defineModuleUnder("PKey");
        PKey2.defineAnnotatedMethods(PKeyModule.class);
        RubyClass PKeyPKey = PKey2.defineClassUnder("PKey", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass PKeyError = PKey2.defineClassUnder("PKeyError", OpenSSLError, OpenSSLError.getAllocator());
        PKeyPKey.defineAnnotatedMethods(PKey.class);
        PKeyRSA.createPKeyRSA(runtime, PKey2, PKeyPKey, PKeyError);
        PKeyDSA.createPKeyDSA(runtime, PKey2, PKeyPKey, PKeyError);
        PKeyDH.createPKeyDH(runtime, PKey2, PKeyPKey, PKeyError);
        PKeyEC.createPKeyEC(runtime, PKey2, PKeyPKey, OpenSSLError);
    }

    public static RaiseException newPKeyError(Ruby runtime, String message) {
        return Utils.newError(runtime, (RubyClass)PKey._PKey(runtime).getConstantAt("PKeyError"), message);
    }

    static RubyModule _PKey(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstantAt("PKey");
    }

    public PKey(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2) {
        return this;
    }

    public abstract PublicKey getPublicKey();

    public abstract PrivateKey getPrivateKey();

    public String getAlgorithm() {
        return "NONE";
    }

    public boolean isPrivateKey() {
        return this.getPrivateKey() != null;
    }

    public abstract RubyString to_der();

    public abstract RubyString to_pem(ThreadContext var1, IRubyObject[] var2);

    @JRubyMethod(name={"sign"})
    public IRubyObject sign(IRubyObject digest2, IRubyObject data) {
        Ruby runtime = this.getRuntime();
        if (!this.isPrivateKey()) {
            throw runtime.newArgumentError("Private key is needed.");
        }
        String digAlg = digest2 instanceof Digest ? ((Digest)digest2).getShortAlgorithm() : digest2.asJavaString();
        try {
            ByteList sign2 = PKey.sign(digAlg + "WITH" + this.getAlgorithm(), this.getPrivateKey(), data.convertToString().getByteList());
            return RubyString.newString((Ruby)runtime, (ByteList)sign2);
        }
        catch (GeneralSecurityException ex) {
            throw PKey.newPKeyError(runtime, ex.getMessage());
        }
    }

    public ASN1Primitive toASN1PublicInfo() throws IOException {
        ASN1InputStream input = new ASN1InputStream(this.to_der().getBytes());
        ASN1Primitive data = input.readObject();
        if (data instanceof ASN1Sequence) {
            return ((ASN1Sequence)data).getObjectAt(1).toASN1Primitive();
        }
        return data;
    }

    public Object toJava(Class target) {
        if (PrivateKey.class.isAssignableFrom(target)) {
            PrivateKey key = this.getPrivateKey();
            if (key == null) {
                throw this.getRuntime().newRuntimeError("private key not available, to convert to " + target);
            }
            if (target.isInstance(key)) {
                return key;
            }
            throw this.getRuntime().newTypeError("cannot convert private key of type " + key.getClass() + " to " + target);
        }
        if (target.isAssignableFrom(PublicKey.class) || Key.class.isAssignableFrom(target)) {
            PublicKey key = this.getPublicKey();
            if (target.isInstance(key)) {
                return key;
            }
            throw this.getRuntime().newTypeError("cannot convert public key of type " + key.getClass() + " to " + target);
        }
        return super.toJava(target);
    }

    static ByteList sign(String signAlg, PrivateKey privateKey, ByteList data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = SecurityHelper.getSignature(signAlg);
        signature.initSign(privateKey);
        signature.update(data.getUnsafeBytes(), data.getBegin(), data.getRealSize());
        return new ByteList(signature.sign(), false);
    }

    @JRubyMethod(name={"verify"})
    public IRubyObject verify(IRubyObject digest2, IRubyObject sign2, IRubyObject data) {
        Ruby runtime = this.getRuntime();
        ByteList sigBytes = PKey.convertToString(runtime, sign2, "OpenSSL::PKey::PKeyError", "invalid signature").getByteList();
        ByteList dataBytes = PKey.convertToString(runtime, data, "OpenSSL::PKey::PKeyError", "invalid data").getByteList();
        String digAlg = digest2 instanceof Digest ? ((Digest)digest2).getShortAlgorithm() : digest2.asJavaString();
        String algorithm = digAlg + "WITH" + this.getAlgorithm();
        try {
            return runtime.newBoolean(PKey.verify(algorithm, this.getPublicKey(), dataBytes, sigBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw PKey.newPKeyError(runtime, "unsupported algorithm: " + algorithm);
        }
        catch (SignatureException e) {
            throw PKey.newPKeyError(runtime, "invalid signature");
        }
        catch (InvalidKeyException e) {
            throw PKey.newPKeyError(runtime, "invalid key");
        }
    }

    static RubyString convertToString(Ruby runtime, IRubyObject str, String errorType, CharSequence errorMsg) {
        try {
            return str.convertToString();
        }
        catch (RaiseException ex) {
            throw Utils.newError(runtime, (RubyClass)runtime.getClassFromPath(errorType), errorMsg == null ? null : errorMsg.toString());
        }
    }

    static boolean verify(String signAlg, PublicKey publicKey, ByteList data, ByteList sign2) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = SecurityHelper.getSignature(signAlg);
        signature.initVerify(publicKey);
        signature.update(data.getUnsafeBytes(), data.getBegin(), data.getRealSize());
        return signature.verify(sign2.getUnsafeBytes(), sign2.getBegin(), sign2.getRealSize());
    }

    static SecureRandom getSecureRandom(Ruby runtime) {
        return OpenSSL.getSecureRandom(runtime);
    }

    protected PrivateKey tryPKCS8EncodedKey(Ruby runtime, KeyFactory keyFactory, byte[] encodedKey) {
        try {
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        catch (InvalidKeySpecException e) {
            if (OpenSSL.isDebug(runtime)) {
                OpenSSL.debug(runtime, ((Object)((Object)this)).getClass().getSimpleName() + " could not generate (PKCS8) private key", e);
            }
        }
        catch (RuntimeException e) {
            if (PKey.isKeyGenerationFailure(e)) {
                if (OpenSSL.isDebug(runtime)) {
                    OpenSSL.debug(runtime, ((Object)((Object)this)).getClass().getSimpleName() + " could not generate (PKCS8) private key", e);
                }
            }
            OpenSSL.debugStackTrace(runtime, e);
        }
        return null;
    }

    protected static boolean isKeyGenerationFailure(RuntimeException e) {
        String msg;
        return e instanceof ClassCastException && (msg = e.getMessage()) != null && msg.contains("DLSequence cannot be cast to");
    }

    protected PublicKey tryX509EncodedKey(Ruby runtime, KeyFactory keyFactory, byte[] encodedKey) {
        try {
            return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        }
        catch (InvalidKeySpecException e) {
            if (OpenSSL.isDebug(runtime)) {
                OpenSSL.debug(runtime, ((Object)((Object)this)).getClass().getSimpleName() + " could not generate (X509) public key", e);
            }
        }
        catch (RuntimeException e) {
            if (PKey.isKeyGenerationFailure(e)) {
                if (OpenSSL.isDebug(runtime)) {
                    OpenSSL.debug(runtime, ((Object)((Object)this)).getClass().getSimpleName() + " could not generate (X509) public key", e);
                }
            }
            OpenSSL.debugStackTrace(runtime, e);
        }
        return null;
    }

    protected static void addSplittedAndFormatted(StringBuilder result, BigInteger value2) {
        String v = value2.toString(16);
        if (v.length() % 2 != 0) {
            v = "0" + v;
        }
        String sep = "";
        for (int i2 = 0; i2 < v.length(); i2 += 2) {
            result.append(sep);
            if (i2 % 30 == 0) {
                result.append("\n    ");
            }
            result.append(v.substring(i2, i2 + 2));
            sep = ":";
        }
        result.append("\n");
    }

    protected static CipherSpec cipherSpec(IRubyObject cipher2) {
        if (cipher2 != null && !cipher2.isNil()) {
            Cipher c = (Cipher)cipher2;
            return new CipherSpec(c.getCipherInstance(), c.getName(), c.getKeyLength() * 8);
        }
        return null;
    }

    @Deprecated
    protected static char[] password(IRubyObject pass) {
        if (pass != null && !pass.isNil()) {
            return pass.toString().toCharArray();
        }
        return null;
    }

    protected static char[] password(ThreadContext context2, IRubyObject pass, Block block) {
        if (pass != null && !pass.isNil()) {
            return pass.toString().toCharArray();
        }
        if (block != null && block.isGiven()) {
            return PKey.password(context2, block.call(context2), null);
        }
        return null;
    }

    protected static char[] passwordPrompt(ThreadContext context2) {
        return PKey.passwordPrompt(context2, "Enter PEM pass phrase:");
    }

    protected static char[] passwordPrompt(ThreadContext context2, String prompt) {
        RubyModule Kernel = context2.runtime.getKernel();
        Kernel.callMethod("print", (IRubyObject)context2.runtime.newString(prompt));
        RubyString gets = Kernel.callMethod(context2, "gets").convertToString();
        gets.chomp_bang(context2);
        return gets.decodeString().toCharArray();
    }

    protected static boolean ttySTDIN(ThreadContext context2) {
        IRubyObject stdin = context2.runtime.getGlobalVariables().get("$stdin");
        if (stdin == null || stdin.isNil()) {
            return false;
        }
        try {
            IRubyObject tty = stdin.callMethod(context2, "tty?");
            return !tty.isNil() && tty != context2.runtime.getFalse();
        }
        catch (RaiseException ex) {
            return false;
        }
    }

    static Object readPrivateKey(String str, char[] passwd) throws PEMInputOutput.PasswordRequiredException, IOException {
        return PEMInputOutput.readPrivateKey(new StringReader(str), passwd);
    }

    static Object readPrivateKey(RubyString str, char[] passwd) throws PEMInputOutput.PasswordRequiredException, IOException {
        return PKey.readPrivateKey(str.toString(), passwd);
    }

    protected static RubyString readInitArg(ThreadContext context2, IRubyObject arg) {
        return StringHelper.readPossibleDERInput(context2, arg);
    }

    static void supportedSignatureAlgorithm(Ruby runtime, RubyClass errorClass, PKey key, Digest digest2) {
        String keyAlg = key.getAlgorithm();
        String digAlg = digest2.getShortAlgorithm();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(digest2.name().toString())) {
            throw Utils.newError(runtime, errorClass, "unsupported key / digest algorithm ( " + keyAlg + " / " + digAlg + " )");
        }
    }

    static void supportedSignatureAlgorithm(Ruby runtime, PKey key, Digest digest2) {
        PKey.supportedSignatureAlgorithm(runtime, OpenSSL._OpenSSLError(runtime), key, digest2);
    }

    public static class PKeyModule {
        @JRubyMethod(name={"read"}, meta=true, required=1, optional=1)
        public static IRubyObject read(ThreadContext context2, IRubyObject recv, IRubyObject[] args) {
            char[] pass;
            IRubyObject data;
            Ruby runtime = context2.runtime;
            switch (args.length) {
                case 1: {
                    data = args[0];
                    pass = null;
                    break;
                }
                default: {
                    data = args[0];
                    pass = args[1].isNil() ? null : args[1].toString().toCharArray();
                }
            }
            RubyString str = PKey.readInitArg(context2, data);
            Object key = null;
            try {
                key = PKey.readPrivateKey(str, pass);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (key != null) {
                KeyPair keyPair = (KeyPair)key;
                String alg2 = PKeyModule.getAlgorithm(keyPair);
                if ("RSA".equals(alg2)) {
                    return new PKeyRSA(runtime, PKey._PKey(runtime).getClass("RSA"), (RSAPrivateCrtKey)keyPair.getPrivate(), (RSAPublicKey)keyPair.getPublic());
                }
                if ("DSA".equals(alg2)) {
                    return new PKeyDSA(runtime, PKey._PKey(runtime).getClass("DSA"), (DSAPrivateKey)keyPair.getPrivate(), (DSAPublicKey)keyPair.getPublic());
                }
                if ("ECDSA".equals(alg2)) {
                    return new PKeyEC(runtime, PKey._PKey(runtime).getClass("EC"), keyPair.getPrivate(), keyPair.getPublic());
                }
            }
            PublicKey pubKey = null;
            try {
                pubKey = PEMInputOutput.readRSAPublicKey(new StringReader(str.toString()), null);
                return new PKeyRSA(runtime, (RSAPublicKey)pubKey);
            }
            catch (IOException alg2) {
                try {
                    pubKey = PEMInputOutput.readDSAPublicKey(new StringReader(str.toString()), null);
                    return new PKeyDSA(runtime, (DSAPublicKey)pubKey);
                }
                catch (IOException alg2) {
                    byte[] input = StringHelper.readX509PEM(context2, (IRubyObject)str);
                    try {
                        pubKey = org.jruby.ext.openssl.impl.PKey.readPublicKey(input);
                    }
                    catch (IOException | GeneralSecurityException exception) {
                        // empty catch block
                    }
                    if (pubKey == null) {
                        try {
                            pubKey = PEMInputOutput.readPubKey(new StringReader(str.toString()));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (pubKey != null) {
                        if ("RSA".equals(pubKey.getAlgorithm())) {
                            return new PKeyRSA(runtime, (RSAPublicKey)pubKey);
                        }
                        if ("DSA".equals(pubKey.getAlgorithm())) {
                            return new PKeyDSA(runtime, (DSAPublicKey)pubKey);
                        }
                        if ("ECDSA".equals(pubKey.getAlgorithm())) {
                            return new PKeyEC(runtime, pubKey);
                        }
                    }
                    throw runtime.newArgumentError("Could not parse PKey");
                }
            }
        }

        private static String getAlgorithm(KeyPair key) {
            if (key.getPrivate() != null) {
                return key.getPrivate().getAlgorithm();
            }
            if (key.getPublic() != null) {
                return key.getPublic().getAlgorithm();
            }
            return null;
        }
    }
}

