/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcher;
import kafka.tools.TopicPartitionReplica;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.IncludeList;
import kafka.utils.Logging;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ReplicaVerificationTool$
implements Logging {
    public static ReplicaVerificationTool$ MODULE$;
    private final String clientId;
    private final String dateFormatString;
    private final SimpleDateFormat dateFormat;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaVerificationTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clientId() {
        return this.clientId;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(Time.SYSTEM.milliseconds()));
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void addShutdownHook_shutdownHook;
        void addShutdownHook_name;
        void var25_24;
        void var24_23;
        scala.collection.immutable.Map<Object, Node> map;
        Seq<TopicDescription> seq;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec topicWhiteListOpt = parser.accepts("topic-white-list", "DEPRECATED use --topics-include instead; ignored if --topics-include specified. List of topics to verify replica consistency. Defaults to '.*' (all topics)").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo((Object)".*", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec topicsIncludeOpt = parser.accepts("topics-include", "List of topics to verify replica consistency. Defaults to '.*' (all topics)").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo((Object)".*", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(30000L), (Object[])new Long[0]);
        AbstractOptionSpec helpOpt = parser.accepts("help", "Print usage information.").forHelp();
        AbstractOptionSpec versionOpt = parser.accepts("version", "Print version information and exit.").forHelp();
        OptionSet options = parser.parse(args);
        if (args.length == 0 || options.has((OptionSpec)helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        if (options.has((OptionSpec)versionOpt)) {
            throw CommandLineUtils$.MODULE$.printVersionAndDie();
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = options.has((OptionSpec)topicsIncludeOpt) ? (String)options.valueOf((OptionSpec)topicsIncludeOpt) : (String)options.valueOf((OptionSpec)topicWhiteListOpt);
        IncludeList topicsIncludeFilter = new IncludeList(regex);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException(new StringBuilder(21).append(regex).append(" is an invalid regex.").toString());
        }
        int fetchSize = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        long initialOffsetTime = (Long)options.valueOf((OptionSpec)initialOffsetTimeOpt);
        long reportInterval = (Long)options.valueOf((OptionSpec)reportIntervalOpt);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$1()));
        }
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Admin adminClient = this.createAdminClient(brokerList);
        try {
            seq = this.listTopicsMetadata(adminClient);
            map = this.brokerDetails(adminClient);
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> adminClient.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        scala.collection.immutable.Map<Object, Node> map2 = map;
        Seq<TopicDescription> topicsMetadata = seq;
        scala.collection.immutable.Map<Object, Node> brokerInfo = map2;
        void topicsMetadata2 = var24_23;
        void brokerInfo2 = var25_24;
        scala.collection.immutable.Map topicIds = ((TraversableOnce)topicsMetadata2.map((Function1 & Serializable & scala.Serializable)metadata -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)metadata.name()), (Object)metadata.topicId()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq filteredTopicMetadata = (Seq)topicsMetadata2.filter((Function1 & Serializable & scala.Serializable)topicMetaData -> BoxesRunTime.boxToBoolean((boolean)topicsIncludeFilter.isTopicAllowed(topicMetaData.name(), false)));
        if (filteredTopicMetadata.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$5(topicsIncludeOpt)));
            }
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        Seq topicPartitionReplicas = (Seq)filteredTopicMetadata.flatMap((Function1 & Serializable & scala.Serializable)topicMetadata -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)partitionMetadata -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new TopicPartitionReplica(topicMetadata.name(), partitionMetadata.partition(), node.id()), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$9(topicPartitionReplicas)));
        }
        scala.collection.immutable.Map brokerToTopicPartitions = (scala.collection.immutable.Map)topicPartitionReplicas.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.replicaId())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            Seq partitions = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), partitions.map((Function1 & Serializable & scala.Serializable)partition -> new TopicPartition(partition.topic(), partition.partitionId()), Seq$.MODULE$.canBuildFrom()));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$13(brokerToTopicPartitions)));
        }
        scala.collection.immutable.Map expectedReplicasPerTopicPartition = (scala.collection.immutable.Map)topicPartitionReplicas.groupBy((Function1 & Serializable & scala.Serializable)replica -> new TopicPartition(replica.topic(), replica.partitionId())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicAndPartition = (TopicPartition)x0$2._1();
            Seq replicaSet = (Seq)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)BoxesRunTime.boxToInteger((int)replicaSet.size()));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$16(expectedReplicasPerTopicPartition)));
        }
        Seq topicPartitions = (Seq)filteredTopicMetadata.flatMap((Function1 & Serializable & scala.Serializable)topicMetaData -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetaData.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new TopicPartition(topicMetaData.name(), partitionMetadata.partition()), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Properties consumerProps = this.consumerConfig(brokerList);
        ReplicaBuffer replicaBuffer = new ReplicaBuffer((Map<TopicPartition, Object>)expectedReplicasPerTopicPartition, this.initialOffsets((Seq<TopicPartition>)topicPartitions, consumerProps, initialOffsetTime), brokerToTopicPartitions.size(), reportInterval);
        int verificationBrokerId = ((Tuple2)brokerToTopicPartitions.head())._1$mcI$sp();
        AtomicInteger counter = new AtomicInteger(0);
        scala.collection.immutable.Iterable fetcherThreads = (scala.collection.immutable.Iterable)brokerToTopicPartitions.map(arg_0 -> ReplicaVerificationTool$.$anonfun$main$19((scala.collection.immutable.Map)brokerInfo2, topicIds, replicaBuffer, fetchSize, maxWaitMs, verificationBrokerId, consumerProps, counter, arg_0), Iterable$.MODULE$.canBuildFrom());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ReplicaVerificationTool$ replicaVerificationTool$ = MODULE$;
            if (replicaVerificationTool$ == null) {
                throw null;
            }
            ReplicaVerificationTool$ info_this = replicaVerificationTool$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$21()));
            }
            fetcherThreads.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.shutdown();
                return BoxedUnit.UNIT;
            });
        };
        String string = "ReplicaVerificationToolShutdownHook";
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.addShutdownHook((String)addShutdownHook_name, () -> Exit$.$anonfun$addShutdownHook$1((Function0)addShutdownHook_shutdownHook));
        fetcherThreads.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.start();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringBuilder(34).append(this.getCurrentTimeString()).append(": verification process is started.").toString());
    }

    private Seq<TopicDescription> listTopicsMetadata(Admin adminClient) {
        Set topics = (Set)adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get();
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((java.util.Map)adminClient.describeTopics((Collection)topics).allTopicNames().get()).values()).asScala()).toBuffer();
    }

    private scala.collection.immutable.Map<Object, Node> brokerDetails(Admin adminClient) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)n -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)n.id()), n), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Admin createAdminClient(String brokerUrl) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerUrl);
        return Admin.create((Properties)props);
    }

    private Map<TopicPartition, Object> initialOffsets(Seq<TopicPartition> topicPartitions, Properties consumerConfig, long initialOffsetTime) {
        Map map;
        try (KafkaConsumer<String, String> consumer = this.createConsumer(consumerConfig);){
            if (-1L == initialOffsetTime) {
                map = (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition k = (TopicPartition)x0$1._1();
                    Long v = (Long)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
            } else if (-2L == initialOffsetTime) {
                map = (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition k = (TopicPartition)x0$2._1();
                    Long v = (Long)x0$2._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
            } else {
                scala.collection.immutable.Map timestampsToSearch = ((TraversableOnce)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)Predef$.MODULE$.long2Long(initialOffsetTime)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                map = (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)timestampsToSearch).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    if (x0$3 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition k = (TopicPartition)x0$3._1();
                    OffsetAndTimestamp v = (OffsetAndTimestamp)x0$3._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)BoxesRunTime.boxToLong((long)v.offset()));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Properties consumerConfig(String brokerUrl) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", brokerUrl);
        properties.put("group.id", "ReplicaVerification");
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        return var2_2;
    }

    private KafkaConsumer<String, String> createConsumer(Properties consumerConfig) {
        return new KafkaConsumer(consumerConfig);
    }

    public static final /* synthetic */ String $anonfun$main$1() {
        return "Getting topic metadata...";
    }

    public static final /* synthetic */ String $anonfun$main$5(ArgumentAcceptingOptionSpec topicsIncludeOpt$1) {
        return new StringBuilder(88).append("No topics found. ").append(topicsIncludeOpt$1).append(" if specified, is either filtering out all topics or there is no topic.").toString();
    }

    public static final /* synthetic */ String $anonfun$main$9(Seq topicPartitionReplicas$1) {
        return new StringBuilder(27).append("Selected topic partitions: ").append(topicPartitionReplicas$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$13(scala.collection.immutable.Map brokerToTopicPartitions$1) {
        return new StringBuilder(29).append("Topic partitions per broker: ").append(brokerToTopicPartitions$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$16(scala.collection.immutable.Map expectedReplicasPerTopicPartition$1) {
        return new StringBuilder(39).append("Expected replicas per topic partition: ").append(expectedReplicasPerTopicPartition$1).toString();
    }

    public static final /* synthetic */ ReplicaFetcher $anonfun$main$19(scala.collection.immutable.Map brokerInfo$1, scala.collection.immutable.Map topicIds$1, ReplicaBuffer replicaBuffer$1, int fetchSize$1, int maxWaitMs$1, int verificationBrokerId$1, Properties consumerProps$1, AtomicInteger counter$1, Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        int brokerId = x0$3._1$mcI$sp();
        Seq topicPartitions = (Seq)x0$3._2();
        ReplicaFetcher replicaFetcher = new ReplicaFetcher(new StringBuilder(15).append("ReplicaFetcher-").append(brokerId).toString(), (Node)brokerInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Iterable<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<String, Uuid>)topicIds$1, replicaBuffer$1, 30000, 256000, fetchSize$1, maxWaitMs$1, 1, brokerId == verificationBrokerId$1, consumerProps$1, counter$1.incrementAndGet());
        return replicaFetcher;
    }

    public static final /* synthetic */ String $anonfun$main$21() {
        return "Stopping all fetchers";
    }

    private ReplicaVerificationTool$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.clientId = "replicaVerificationTool";
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
    }
}

