/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaState$;
import kafka.log.UnifiedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001\u0002\b\u0010\u0001QA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tM\u0001\u0011\t\u0011)A\u0005G!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015)\u0004\u0001\"\u00017\u0011\u001dY\u0004A1A\u0005\nqBa\u0001\u0014\u0001!\u0002\u0013i\u0004\"B'\u0001\t\u0003q\u0005\"B(\u0001\t\u0003\u0001\u0006\"B3\u0001\t\u00031\u0007\"B9\u0001\t\u0003\u0012\b\"\u0002@\u0001\t\u0003z\bbBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0002\b%\u0016\u0004H.[2b\u0015\t\u0001\u0012#A\u0004dYV\u001cH/\u001a:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0012\u0003\u0015)H/\u001b7t\u0013\t\u0001SDA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\t\t\u0003-\u0011J!!J\f\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#A\u0015\u0011\u0005)\u0012T\"A\u0016\u000b\u00051j\u0013AB2p[6|gN\u0003\u0002\u0013])\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0013\t\u00194F\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\na\u0001P5oSRtDcA\u001c:uA\u0011\u0001\bA\u0007\u0002\u001f!)\u0011%\u0002a\u0001G!)q%\u0002a\u0001S\u0005a!/\u001a9mS\u000e\f7\u000b^1uKV\tQ\bE\u0002?\u000f&k\u0011a\u0010\u0006\u0003\u0001\u0006\u000ba!\u0019;p[&\u001c'B\u0001\"D\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%@\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007C\u0001\u001dK\u0013\tYuB\u0001\u0007SKBd\u0017nY1Ti\u0006$X-A\u0007sKBd\u0017nY1Ti\u0006$X\rI\u0001\u000egR\fG/Z*oCB\u001c\bn\u001c;\u0016\u0003%\u000b\u0001#\u001e9eCR,g)\u001a;dQN#\u0018\r^3\u0015\u000bE#F,Y2\u0011\u0005Y\u0011\u0016BA*\u0018\u0005\u0011)f.\u001b;\t\u000bUK\u0001\u0019\u0001,\u00027\u0019|G\u000e\\8xKJ4U\r^2i\u001f\u001a47/\u001a;NKR\fG-\u0019;b!\t9&,D\u0001Y\u0015\tI\u0016#\u0001\u0004tKJ4XM]\u0005\u00037b\u0013\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011\u0015i\u0016\u00021\u0001_\u0003M1w\u000e\u001c7po\u0016\u00148\u000b^1si>3gm]3u!\t1r,\u0003\u0002a/\t!Aj\u001c8h\u0011\u0015\u0011\u0017\u00021\u0001_\u0003M1w\u000e\u001c7po\u0016\u0014h)\u001a;dQRKW.Z't\u0011\u0015!\u0017\u00021\u0001_\u0003=aW-\u00193fe\u0016sGm\u00144gg\u0016$\u0018!\u0005:fg\u0016$(+\u001a9mS\u000e\f7\u000b^1uKR)\u0011kZ5k_\")\u0001N\u0003a\u0001=\u0006i1-\u001e:sK:$H+[7f\u001bNDQ\u0001\u001a\u0006A\u0002yCQa\u001b\u0006A\u00021\f1\"[:OK^dU-\u00193feB\u0011a#\\\u0005\u0003]^\u0011qAQ8pY\u0016\fg\u000eC\u0003q\u0015\u0001\u0007A.\u0001\tjg\u001a{G\u000e\\8xKJLenU=oG\u0006AAo\\*ue&tw\rF\u0001t!\t!8P\u0004\u0002vsB\u0011aoF\u0007\u0002o*\u0011\u0001pE\u0001\u0007yI|w\u000e\u001e \n\u0005i<\u0012A\u0002)sK\u0012,g-\u0003\u0002}{\n11\u000b\u001e:j]\u001eT!A_\f\u0002\r\u0015\fX/\u00197t)\ra\u0017\u0011\u0001\u0005\b\u0003\u0007a\u0001\u0019AA\u0003\u0003\u0011!\b.\u0019;\u0011\u0007Y\t9!C\u0002\u0002\n]\u00111!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#A\u0012")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private final AtomicReference<ReplicaState> replicaState;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private AtomicReference<ReplicaState> replicaState() {
        return this.replicaState;
    }

    public ReplicaState stateSnapshot() {
        return this.replicaState().get();
    }

    public void updateFetchState(LogOffsetMetadata followerFetchOffsetMetadata, long followerStartOffset, long followerFetchTimeMs, long leaderEndOffset) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            long lastCaughtUpTime = followerFetchOffsetMetadata.messageOffset() >= leaderEndOffset ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), followerFetchTimeMs) : (followerFetchOffsetMetadata.messageOffset() >= currentReplicaState.lastFetchLeaderLogEndOffset() ? package$.MODULE$.max(currentReplicaState.lastCaughtUpTimeMs(), currentReplicaState.lastFetchTimeMs()) : currentReplicaState.lastCaughtUpTimeMs());
            return new ReplicaState(followerStartOffset, followerFetchOffsetMetadata, package$.MODULE$.max(leaderEndOffset, currentReplicaState.lastFetchLeaderLogEndOffset()), followerFetchTimeMs, lastCaughtUpTime);
        });
    }

    public void resetReplicaState(long currentTimeMs, long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        this.replicaState().updateAndGet(currentReplicaState -> {
            long lastCaughtUpTimeMs;
            long l = lastCaughtUpTimeMs = isFollowerInSync ? currentTimeMs : 0L;
            if (isNewLeader) {
                return new ReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, lastCaughtUpTimeMs);
            }
            return new ReplicaState(currentReplicaState.logStartOffset(), currentReplicaState.logEndOffsetMetadata(), leaderEndOffset, isFollowerInSync ? currentTimeMs : 0L, lastCaughtUpTimeMs);
        });
        this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new java.lang.StringBuilder(26).append("Reset state of replica to ").append(this).toString());
    }

    public String toString() {
        ReplicaState replicaState = this.replicaState().get();
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new java.lang.StringBuilder(18).append("Replica(replicaId=").append(this.brokerId()).toString());
        replicaString.append(new java.lang.StringBuilder(8).append(", topic=").append(this.topicPartition().topic()).toString());
        replicaString.append(new java.lang.StringBuilder(12).append(", partition=").append(this.topicPartition().partition()).toString());
        replicaString.append(new java.lang.StringBuilder(21).append(", lastCaughtUpTimeMs=").append(replicaState.lastCaughtUpTimeMs()).toString());
        replicaString.append(new java.lang.StringBuilder(17).append(", logStartOffset=").append(replicaState.logStartOffset()).toString());
        replicaString.append(new java.lang.StringBuilder(15).append(", logEndOffset=").append(replicaState.logEndOffsetMetadata().messageOffset()).toString());
        replicaString.append(new java.lang.StringBuilder(23).append(", logEndOffsetMetadata=").append(replicaState.logEndOffsetMetadata()).toString());
        replicaString.append(new java.lang.StringBuilder(30).append(", lastFetchLeaderLogEndOffset=").append(replicaState.lastFetchLeaderLogEndOffset()).toString());
        replicaString.append(new java.lang.StringBuilder(18).append(", lastFetchTimeMs=").append(replicaState.lastFetchTimeMs()).toString());
        replicaString.append(")");
        return replicaString.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof Replica)) return false;
        Replica replica = (Replica)that;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public Replica(int brokerId, TopicPartition topicPartition) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        Logging.$init$(this);
        this.replicaState = new AtomicReference<ReplicaState>(ReplicaState$.MODULE$.Empty());
    }
}

