/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.AbstractSimpleMetricExt;
import org.logstash.instrument.metrics.MetricExt;
import org.logstash.instrument.metrics.NullNamespacedMetricExt;
import org.logstash.instrument.metrics.timer.NullTimerMetric;

@JRubyClass(name={"NullMetric"})
public final class NullMetricExt
extends AbstractSimpleMetricExt {
    private static final long serialVersionUID = 1L;
    private static final IRubyObject NULL_TIMER_METRIC = RubyUtil.toRubyObject(NullTimerMetric.getInstance());
    private transient IRubyObject collector;

    public static NullMetricExt create() {
        return new NullMetricExt(RubyUtil.RUBY, RubyUtil.NULL_METRIC_CLASS).initialize(RubyUtil.RUBY.getCurrentContext(), new IRubyObject[0]);
    }

    public NullMetricExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(optional=1)
    public NullMetricExt initialize(ThreadContext context, IRubyObject[] collector) {
        this.collector = collector.length == 0 ? context.nil : collector[0];
        return this;
    }

    @Override
    protected IRubyObject getCollector(ThreadContext context) {
        return this.collector;
    }

    @Override
    protected IRubyObject doIncrement(ThreadContext context, IRubyObject[] args) {
        MetricExt.validateKey(context, null, args[1]);
        return context.nil;
    }

    @Override
    protected IRubyObject doDecrement(ThreadContext context, IRubyObject[] args) {
        MetricExt.validateKey(context, null, args[1]);
        return context.nil;
    }

    @Override
    protected IRubyObject getGauge(ThreadContext context, IRubyObject namespace, IRubyObject key, IRubyObject value) {
        MetricExt.validateKey(context, null, key);
        return context.nil;
    }

    @Override
    protected IRubyObject getTimer(ThreadContext context, IRubyObject namespace, IRubyObject key) {
        MetricExt.validateKey(context, null, key);
        return NULL_TIMER_METRIC;
    }

    @Override
    protected IRubyObject doReportTime(ThreadContext context, IRubyObject namespace, IRubyObject key, IRubyObject duration) {
        MetricExt.validateKey(context, null, key);
        return context.nil;
    }

    @Override
    protected IRubyObject doTime(ThreadContext context, IRubyObject namespace, IRubyObject key, Block block) {
        MetricExt.validateKey(context, null, key);
        if (!block.isGiven()) {
            return NullTimedExecution.INSTANCE;
        }
        return block.call(context);
    }

    @Override
    protected AbstractNamespacedMetricExt createNamespaced(ThreadContext context, IRubyObject name) {
        MetricExt.validateName(context, name, RubyUtil.METRIC_NO_NAMESPACE_PROVIDED_CLASS);
        return NullNamespacedMetricExt.create(this, name instanceof RubyArray ? (RubyArray)name : RubyArray.newArray((Ruby)context.runtime, (IRubyObject)name));
    }

    @JRubyClass(name={"NullTimedExecution"})
    public static final class NullTimedExecution
    extends RubyObject {
        private static final long serialVersionUID = 1L;
        private static final NullTimedExecution INSTANCE = new NullTimedExecution(RubyUtil.RUBY, RubyUtil.NULL_TIMED_EXECUTION_CLASS);

        public NullTimedExecution(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public RubyFixnum stop(ThreadContext context) {
            return RubyFixnum.newFixnum((Ruby)context.runtime, (long)0L);
        }
    }
}

