/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.expression;

import org.logstash.common.SourceWithMetadata;
import org.logstash.common.Util;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.expression.BooleanExpression;
import org.logstash.config.ir.expression.Expression;

public abstract class BinaryBooleanExpression
extends BooleanExpression {
    private final Expression left;
    private final Expression right;

    @Override
    public boolean sourceComponentEquals(SourceComponent sourceComponent) {
        if (sourceComponent == null) {
            return false;
        }
        if (this == sourceComponent) {
            return true;
        }
        if (this.getClass().equals(sourceComponent.getClass())) {
            BinaryBooleanExpression other = (BinaryBooleanExpression)sourceComponent;
            return this.getLeft().sourceComponentEquals(other.getLeft()) && this.getRight().sourceComponentEquals(other.getRight());
        }
        return false;
    }

    public Expression getRight() {
        return this.right;
    }

    public Expression getLeft() {
        return this.left;
    }

    protected BinaryBooleanExpression(SourceWithMetadata meta, Expression left, Expression right) {
        super(meta);
        BinaryBooleanExpression.ensureNotNull(left, "left", meta);
        BinaryBooleanExpression.ensureNotNull(right, "right", meta);
        this.left = left;
        this.right = right;
    }

    public abstract String rubyOperator();

    @Override
    public String toRubyString() {
        return "(" + this.getLeft().toRubyString() + this.rubyOperator() + this.getRight().toRubyString() + ")";
    }

    @Override
    public String uniqueHash() {
        return Util.digest(this.getClass().getCanonicalName() + "[" + this.getLeft().hashSource() + "|" + this.getRight().hashSource() + "]");
    }

    private static void ensureNotNull(Expression expression, String side, SourceWithMetadata meta) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Failed to parse %s-hand side of conditional %s", side, String.valueOf(meta)));
        }
    }
}

