/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class ReceivePreReqdArgInstr
extends ReceiveArgBase
implements FixedArityInstr {
    public ReceivePreReqdArgInstr(Variable result2, int argIndex) {
        super(Operation.RECV_PRE_REQD_ARG, result2, argIndex);
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new ReceivePreReqdArgInstr(info.getRenamedVariable(this.result), this.argIndex);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            return new CopyInstr(ii.getRenamedVariable(this.result), ii.getArg(this.argIndex));
        }
        return new ReqdArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), -1, -1, this.argIndex);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getArgIndex());
    }

    public static ReceivePreReqdArgInstr decode(IRReaderDecoder d) {
        return new ReceivePreReqdArgInstr(d.decodeVariable(), d.decodeInt());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceivePreReqdArgInstr(this);
    }
}

