/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.ext.ripper.RipperLexer;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.LexingCommon;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private int nest;
    private List<ByteList> regexpFragments;
    private boolean regexpDynamic;
    protected Encoding encodingOut;

    public StringTerm(int flags2, int begin2, int end2) {
        this.flags = flags2;
        this.begin = (char)begin2;
        this.end = (char)end2;
        this.nest = 0;
        if ((flags2 & 4) != 0) {
            this.regexpFragments = new ArrayList<ByteList>();
        }
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    protected ByteList createByteList(RipperLexer lexer) {
        return new ByteList(ByteList.NULL_ARRAY, lexer.getEncoding());
    }

    private int endFound(RipperLexer lexer) throws IOException {
        if ((this.flags & 8) != 0) {
            this.flags |= 0x8000;
            lexer.pushback(0);
            lexer.addDelayedToken(lexer.tokp, lexer.lex_p);
            return 32;
        }
        lexer.setStrTerm(null);
        if ((this.flags & 4) != 0) {
            this.validateRegexp(lexer);
            lexer.dispatchScanEvent(383);
            lexer.setState(2);
            return 383;
        }
        if ((this.flags & 0x40) != 0 && lexer.isLabelSuffix()) {
            lexer.nextc();
            lexer.setState(1025);
            return 396;
        }
        lexer.setState(2);
        return 373;
    }

    private void validateRegexp(RipperLexer lexer) throws IOException {
        Ruby runtime2 = lexer.getRuntime();
        RegexpOptions options2 = lexer.parseRegexpFlags();
        for (ByteList fragment : this.regexpFragments) {
            lexer.checkRegexpFragment(runtime2, fragment, options2);
        }
        if (!this.regexpDynamic && this.regexpFragments.size() == 1) {
            lexer.checkRegexpSyntax(runtime2, this.regexpFragments.get(0), options2);
        }
        this.regexpFragments.clear();
        this.regexpDynamic = false;
    }

    @Override
    public int parseString(RipperLexer lexer, LexerSource src) throws IOException {
        boolean spaceSeen = false;
        if ((this.flags & 0x8000) != 0) {
            if ((this.flags & 8) != 0) {
                lexer.nextc();
            }
            lexer.setState(2);
            lexer.setStrTerm(null);
            return (this.flags & 4) != 0 ? 383 : 373;
        }
        ByteList buffer = this.createByteList(lexer);
        int c = lexer.nextc();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = lexer.nextc())) {
            }
            spaceSeen = true;
        }
        if ((this.flags & 0x4000) != 0) {
            this.flags &= 0xFFFFBFFF;
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            return this.endFound(lexer);
        }
        if (spaceSeen) {
            lexer.pushback(c);
            lexer.addDelayedToken(lexer.tokp, lexer.lex_p);
            return 32;
        }
        if ((this.flags & 2) != 0 && c == 35) {
            int token = lexer.peekVariableName(372, 371);
            if (token != 0) {
                if ((this.flags & 4) != 0) {
                    this.regexpDynamic = true;
                }
                return token;
            }
            buffer.append(c);
        }
        lexer.pushback(c);
        if (this.parseStringIntoBuffer(lexer, src, buffer, lexer.getEncoding()) == -1) {
            if ((this.flags & 4) != 0) {
                lexer.compile_error("unterminated regexp meets end of file");
            } else {
                lexer.compile_error("unterminated string meets end of file");
            }
            this.flags |= 0x8000;
        }
        lexer.setValue(lexer.createStr(buffer, this.flags));
        if ((this.flags & 4) != 0) {
            this.regexpFragments.add(buffer);
        }
        lexer.flush_string_content(this.encodingOut);
        return 378;
    }

    private void mixedEscape(RipperLexer lexer, Encoding foundEncoding, Encoding parserEncoding) {
        lexer.compile_error(" mixed within " + parserEncoding);
    }

    public int parseStringIntoBuffer(RipperLexer lexer, LexerSource src, ByteList buffer, Encoding enc) throws IOException {
        int c;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape2 = (this.flags & 1) != 0;
        boolean regexp2 = (this.flags & 4) != 0;
        boolean symbol = (this.flags & 0x10) != 0;
        boolean hasNonAscii = false;
        block5: while ((c = lexer.nextc()) != -1) {
            block28: {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                if (lexer.getHeredocIndent() > 0) {
                                    lexer.update_heredoc_indent(c);
                                }
                                if (this.begin == '\u0000' || c != this.begin) break block27;
                                ++this.nest;
                                break block28;
                            }
                            if (c != this.end) break block29;
                            if (this.nest == 0) {
                                lexer.pushback(c);
                                break;
                            }
                            --this.nest;
                            break block28;
                        }
                        if (!expand || c != 35 || lexer.peek(10)) break block30;
                        int c2 = lexer.nextc();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            lexer.pushback(c2);
                            lexer.pushback(c);
                            break;
                        }
                        lexer.pushback(c2);
                        break block28;
                    }
                    if (c != 92) break block31;
                    c = lexer.nextc();
                    switch (c) {
                        case 10: {
                            if (qwords) break;
                            if (expand) continue block5;
                            buffer.append(92);
                            break;
                        }
                        case 92: {
                            if (escape2) {
                                buffer.append(c);
                                break;
                            }
                            break block28;
                        }
                        case 117: {
                            if (!expand) {
                                buffer.append(92);
                                break;
                            }
                            if (regexp2) {
                                lexer.readUTFEscapeRegexpLiteral(buffer);
                            } else {
                                lexer.readUTFEscape(buffer, true, symbol);
                            }
                            if (!hasNonAscii || buffer.getEncoding() == enc) continue block5;
                            this.mixedEscape(lexer, buffer.getEncoding(), enc);
                            continue block5;
                        }
                        default: {
                            if (c == -1) {
                                return -1;
                            }
                            if (!lexer.isASCII()) {
                                if (!expand) {
                                    buffer.append(92);
                                }
                                hasNonAscii = true;
                                if (buffer.getEncoding() != enc) {
                                    this.mixedEscape(lexer, buffer.getEncoding(), enc);
                                    continue block5;
                                }
                                if (lexer.tokenAddMBC(c, buffer)) continue block5;
                                lexer.compile_error("invalid multibyte char (" + enc + ")");
                                return -1;
                            }
                            if (regexp2) {
                                if (c == this.end && !this.simple_re_meta(c)) {
                                    buffer.append(c);
                                    continue block5;
                                }
                                lexer.pushback(c);
                                this.parseEscapeIntoBuffer(lexer, src, buffer);
                                if (!hasNonAscii || buffer.getEncoding() == enc) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), enc);
                                continue block5;
                            }
                            if (expand) {
                                lexer.pushback(c);
                                if (escape2) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break;
                            }
                            if (qwords && Character.isWhitespace(c)) break;
                            if (c != this.end && (this.begin == '\u0000' || c != this.begin)) {
                                buffer.append(92);
                                break;
                            }
                            break block28;
                        }
                    }
                    break block28;
                }
                if (!lexer.isASCII()) {
                    hasNonAscii = true;
                    if (buffer.getEncoding() != enc) {
                        this.mixedEscape(lexer, buffer.getEncoding(), enc);
                        continue;
                    }
                    if (lexer.tokenAddMBC(c, buffer)) continue;
                    lexer.compile_error("invalid multibyte char (" + enc + ")");
                    return -1;
                }
                if (qwords && Character.isWhitespace(c)) {
                    lexer.pushback(c);
                    break;
                }
            }
            if ((c & 0x80) != 0) {
                hasNonAscii = true;
                if (buffer.getEncoding() != enc) {
                    this.mixedEscape(lexer, buffer.getEncoding(), enc);
                    continue;
                }
            }
            buffer.append(c);
        }
        this.encodingOut = buffer.getEncoding();
        return c;
    }

    private boolean simple_re_meta(int c) {
        switch (c) {
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 62: 
            case 63: 
            case 93: 
            case 94: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private void escaped(RipperLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(lexer, src, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(RipperLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append(c);
                for (int i2 = 0; i2 < 2; ++i2) {
                    c = lexer.nextc();
                    if (c == -1) {
                        lexer.compile_error("Invalid escape character syntax");
                    }
                    if (!LexingCommon.isOctChar(c)) {
                        lexer.pushback(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append(c);
                c = lexer.nextc();
                if (!LexingCommon.isHexChar(c)) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(c);
                c = lexer.nextc();
                if (LexingCommon.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                lexer.pushback(c);
                break;
            }
            case 77: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(lexer, src, buffer);
                break;
            }
            case 67: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(lexer, src, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(lexer, src, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                if (c != 92 || c != this.end) {
                    buffer.append(92);
                }
                buffer.append(c);
            }
        }
    }
}

