/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jruby.RubyArray;
import org.logstash.config.ir.compiler.Closure;
import org.logstash.config.ir.compiler.ComputeStepSyntaxElement;
import org.logstash.config.ir.compiler.Dataset;
import org.logstash.config.ir.compiler.DatasetCompiler;
import org.logstash.config.ir.compiler.SyntaxElement;
import org.logstash.config.ir.compiler.SyntaxFactory;
import org.logstash.config.ir.compiler.ValueSyntaxElement;
import org.logstash.config.ir.compiler.VariableDefinition;

interface MethodSyntaxElement
extends SyntaxElement {
    public static MethodSyntaxElement constructor(String classname, Closure body) {
        return new MethodSyntaxElementImpl(classname, "", body, Collections.singletonList(ComputeStepSyntaxElement.CTOR_ARGUMENT));
    }

    public static MethodSyntaxElement clear(Closure body) {
        return new MethodSyntaxElementImpl(Void.TYPE, "clear", body, new VariableDefinition[0]);
    }

    public static MethodSyntaxElement compute(Closure body) {
        return new MethodSyntaxElementImpl(Collection.class, "compute", body, new VariableDefinition(RubyArray.class, DatasetCompiler.BATCH_ARG), new VariableDefinition(Boolean.TYPE, DatasetCompiler.FLUSH_ARG), new VariableDefinition(Boolean.TYPE, DatasetCompiler.SHUTDOWN_ARG));
    }

    public static MethodSyntaxElement right(ValueSyntaxElement elseData) {
        return new MethodSyntaxElementImpl(Dataset.class, "right", Closure.wrap(SyntaxFactory.ret(elseData)), new VariableDefinition[0]);
    }

    public static final class MethodSyntaxElementImpl
    implements MethodSyntaxElement {
        private final String name;
        private final String returnType;
        private final Closure body;
        private final Iterable<VariableDefinition> arguments;

        private MethodSyntaxElementImpl(Class<?> returnType, String name, Closure body, VariableDefinition ... arguments) {
            this(returnType.getName(), name, body, Arrays.asList(arguments));
        }

        private MethodSyntaxElementImpl(String returnType, String name, Closure body, Iterable<VariableDefinition> arguments) {
            this.name = name;
            this.returnType = returnType;
            this.arguments = arguments;
            this.body = body;
        }

        @Override
        public String generateCode() {
            return SyntaxFactory.join("public ", this.returnType, " ", this.name, "(", StreamSupport.stream(this.arguments.spliterator(), false).map(VariableDefinition::generateCode).collect(Collectors.joining(",")), ") {", this.body.generateCode(), "}");
        }
    }
}

