/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.netty;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.Cipher;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SslContextBuilder {
    private static final Logger logger = LogManager.getLogger(SslContextBuilder.class);
    private File sslKeyFile;
    private File sslCertificateFile;
    private SslClientVerifyMode verifyMode = SslClientVerifyMode.FORCE_PEER;
    public static final Set<String> SUPPORTED_CIPHERS = new HashSet<String>(Arrays.asList(((SSLServerSocketFactory)SSLServerSocketFactory.getDefault()).getSupportedCipherSuites()));
    private static final String[] DEFAULT_CIPHERS;
    private static final String[] DEFAULT_CIPHERS_LIMITED;
    private String[] ciphers = DEFAULT_CIPHERS;
    private String[] protocols = new String[]{"TLSv1.2", "TLSv1.3"};
    private String[] certificateAuthorities;
    private String passPhrase;

    public SslContextBuilder(String sslCertificateFilePath, String sslKeyFilePath, String pass) throws IllegalArgumentException {
        this.sslCertificateFile = new File(sslCertificateFilePath);
        if (!this.sslCertificateFile.canRead()) {
            throw new IllegalArgumentException(String.format("Certificate file cannot be read. Please confirm the user running Logstash has permissions to read: %s", sslCertificateFilePath));
        }
        this.sslKeyFile = new File(sslKeyFilePath);
        if (!this.sslKeyFile.canRead()) {
            throw new IllegalArgumentException(String.format("Private key file cannot be read. Please confirm the user running Logstash has permissions to read: %s", sslKeyFilePath));
        }
        this.passPhrase = pass;
    }

    public SslContextBuilder setProtocols(String[] protocols) {
        this.protocols = protocols;
        return this;
    }

    public SslContextBuilder setCipherSuites(String[] ciphersSuite) throws IllegalArgumentException {
        for (String cipher : ciphersSuite) {
            if (!SUPPORTED_CIPHERS.contains(cipher)) {
                if (!SslContextBuilder.isUnlimitedJCEAvailable()) {
                    logger.warn("JCE Unlimited Strength Jurisdiction Policy not installed");
                }
                throw new IllegalArgumentException("Cipher `" + cipher + "` is not available");
            }
            logger.debug("{} cipher is supported", (Object)cipher);
        }
        this.ciphers = ciphersSuite;
        return this;
    }

    public static String[] getDefaultCiphers() {
        if (SslContextBuilder.isUnlimitedJCEAvailable()) {
            return DEFAULT_CIPHERS;
        }
        logger.warn("JCE Unlimited Strength Jurisdiction Policy not installed - max key length is 128 bits");
        return DEFAULT_CIPHERS_LIMITED;
    }

    public static boolean isUnlimitedJCEAvailable() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("AES not available", (Throwable)e);
            return false;
        }
    }

    public SslContextBuilder setCertificateAuthorities(String[] cert) {
        this.certificateAuthorities = cert;
        return this;
    }

    public SslContextBuilder setVerifyMode(SslClientVerifyMode mode) {
        this.verifyMode = mode;
        return this;
    }

    public File getSslKeyFile() {
        return this.sslKeyFile;
    }

    public File getSslCertificateFile() {
        return this.sslCertificateFile;
    }

    public SslContext buildContext() throws Exception {
        io.netty.handler.ssl.SslContextBuilder builder = io.netty.handler.ssl.SslContextBuilder.forServer((File)this.sslCertificateFile, (File)this.sslKeyFile, (String)this.passPhrase);
        if (logger.isDebugEnabled()) {
            logger.debug("Available ciphers: " + SUPPORTED_CIPHERS);
            logger.debug("Ciphers:  " + Arrays.toString(this.ciphers));
        }
        builder.ciphers(Arrays.asList(this.ciphers));
        if (this.requireClientAuth()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Certificate Authorities: " + Arrays.toString(this.certificateAuthorities));
            }
            builder.trustManager(this.loadCertificateCollection(this.certificateAuthorities));
            if (this.verifyMode == SslClientVerifyMode.FORCE_PEER) {
                builder.clientAuth(ClientAuth.REQUIRE);
            } else if (this.verifyMode == SslClientVerifyMode.VERIFY_PEER) {
                builder.clientAuth(ClientAuth.OPTIONAL);
            }
        } else {
            builder.clientAuth(ClientAuth.NONE);
        }
        builder.protocols(this.protocols);
        try {
            return builder.build();
        }
        catch (SSLException e) {
            logger.debug("Failed to initialize SSL", (Throwable)e);
            if (("failed to initialize the server-side SSL context".equals(e.getMessage()) || "failed to initialize the client-side SSL context".equals(e.getMessage())) && e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (Exception e) {
            logger.debug("Failed to initialize SSL", (Throwable)e);
            throw e;
        }
    }

    private X509Certificate[] loadCertificateCollection(String[] certificates) throws IOException, CertificateException {
        logger.debug("Load certificates collection");
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList collections = new ArrayList();
        for (int i = 0; i < certificates.length; ++i) {
            String certificate = certificates[i];
            logger.debug("Loading certificates from file {}", (Object)certificate);
            try (FileInputStream in = new FileInputStream(certificate);){
                List certificatesChains = (List)certificateFactory.generateCertificates(in);
                collections.addAll(certificatesChains);
                continue;
            }
        }
        return collections.toArray(new X509Certificate[collections.size()]);
    }

    private boolean requireClientAuth() {
        return this.certificateAuthorities != null;
    }

    private FileInputStream createFileInputStream(String filepath) throws FileNotFoundException {
        return new FileInputStream(filepath);
    }

    String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    static {
        String[] defaultCipherCandidates = new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"};
        DEFAULT_CIPHERS = (String[])Arrays.stream(defaultCipherCandidates).filter(SUPPORTED_CIPHERS::contains).toArray(String[]::new);
        DEFAULT_CIPHERS_LIMITED = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"};
    }

    public static enum SslClientVerifyMode {
        VERIFY_PEER,
        FORCE_PEER;

    }
}

