/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.MetricType;

public class FlowMetric
extends AbstractMetric<Map<String, Double>> {
    private final Metric<? extends Number> numeratorMetric;
    private final Metric<? extends Number> denominatorMetric;
    private final Capture baseline;
    private final AtomicReference<Capture> head;
    private final AtomicReference<Capture> instant = new AtomicReference();
    private final LongSupplier nanoTimeSupplier;
    static final String LIFETIME_KEY = "lifetime";
    static final String CURRENT_KEY = "current";

    public FlowMetric(String name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric) {
        this(System::nanoTime, name, numeratorMetric, denominatorMetric);
    }

    FlowMetric(LongSupplier nanoTimeSupplier, String name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric) {
        super(name);
        this.nanoTimeSupplier = nanoTimeSupplier;
        this.numeratorMetric = numeratorMetric;
        this.denominatorMetric = denominatorMetric;
        this.baseline = this.doCapture();
        this.head = new AtomicReference<Capture>(this.baseline);
    }

    public void capture() {
        Capture newestHead = this.doCapture();
        Capture previousHead = this.head.getAndSet(newestHead);
        this.instant.getAndAccumulate(previousHead, (current, given) -> newestHead.calculateCapturePeriod((Capture)given).toMillis() > 100L ? given : current);
    }

    @Override
    public Map<String, Double> getValue() {
        Capture headCapture = this.head.get();
        if (Objects.isNull(headCapture)) {
            return Map.of();
        }
        HashMap rates = new HashMap();
        headCapture.calculateRate(this.baseline).ifPresent(rate -> rates.put(LIFETIME_KEY, rate));
        headCapture.calculateRate(this.instant::get).ifPresent(rate -> rates.put(CURRENT_KEY, rate));
        return Map.copyOf(rates);
    }

    Capture doCapture() {
        return new Capture(this.numeratorMetric.getValue(), this.denominatorMetric.getValue(), this.nanoTimeSupplier.getAsLong());
    }

    @Override
    public MetricType getType() {
        return MetricType.FLOW_RATE;
    }

    private static class Capture {
        private final Number numerator;
        private final Number denominator;
        private final long nanoTimestamp;

        public Capture(Number numerator, Number denominator, long nanoTimestamp) {
            this.numerator = numerator;
            this.denominator = denominator;
            this.nanoTimestamp = nanoTimestamp;
        }

        OptionalDouble calculateRate(Capture baseline) {
            Objects.requireNonNull(baseline, "baseline");
            if (baseline == this) {
                return OptionalDouble.empty();
            }
            double deltaNumerator = this.numerator.doubleValue() - baseline.numerator.doubleValue();
            double deltaDenominator = this.denominator.doubleValue() - baseline.denominator.doubleValue();
            if (deltaDenominator == 0.0) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(BigDecimal.valueOf(deltaNumerator).divide(BigDecimal.valueOf(deltaDenominator), 3, RoundingMode.HALF_UP).doubleValue());
        }

        OptionalDouble calculateRate(Supplier<Capture> possibleBaseline) {
            return Optional.ofNullable(possibleBaseline.get()).map(this::calculateRate).orElseGet(OptionalDouble::empty);
        }

        Duration calculateCapturePeriod(Capture baseline) {
            return Duration.ofNanos(Math.subtractExact(this.nanoTimestamp, baseline.nanoTimestamp));
        }
    }
}

