/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DeleteTopicsRequestData
implements ApiMessage {
    List<DeleteTopicState> topics;
    List<String> topicNames;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 6;

    public DeleteTopicsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteTopicsRequestData() {
        this.topics = new ArrayList<DeleteTopicState>(0);
        this.topicNames = new ArrayList<String>(0);
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 20;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DeleteTopicState> newCollection;
        int arrayLength;
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new ArrayList<DeleteTopicState>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteTopicState(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            this.topics = new ArrayList<DeleteTopicState>(0);
        }
        if (_version <= 5) {
            int length;
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicNames was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    length = _readable.readUnsignedVarint() - 1;
                    if (length < 0) {
                        throw new RuntimeException("non-nullable field topicNames element was serialized as null");
                    }
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field topicNames element had invalid length " + length);
                    }
                    newCollection.add((DeleteTopicState)((Object)_readable.readString(length)));
                }
                this.topicNames = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicNames was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    length = _readable.readShort();
                    if (length < 0) {
                        throw new RuntimeException("non-nullable field topicNames element was serialized as null");
                    }
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field topicNames element had invalid length " + length);
                    }
                    newCollection.add((DeleteTopicState)((Object)_readable.readString(length)));
                }
                this.topicNames = newCollection;
            }
        } else {
            this.topicNames = new ArrayList<String>(0);
        }
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 6) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (DeleteTopicState topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else if (!this.topics.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topics at version " + _version);
        }
        if (_version <= 5) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.topicNames.size() + 1);
                for (String topicNamesElement : this.topicNames) {
                    byte[] _stringBytes = _cache.getSerializedValue(topicNamesElement);
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    _writable.writeByteArray(_stringBytes);
                }
            } else {
                _writable.writeInt(this.topicNames.size());
                for (String topicNamesElement : this.topicNames) {
                    byte[] _stringBytes = _cache.getSerializedValue(topicNamesElement);
                    _writable.writeShort((short)_stringBytes.length);
                    _writable.writeByteArray(_stringBytes);
                }
            }
        }
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 6) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            for (DeleteTopicState topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version);
            }
        }
        if (_version <= 5) {
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicNames.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (String topicNamesElement : this.topicNames) {
                byte[] _stringBytes = topicNamesElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topicNamesElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(topicNamesElement, _stringBytes);
                if (_version >= 4) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                    continue;
                }
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteTopicsRequestData)) {
            return false;
        }
        DeleteTopicsRequestData other = (DeleteTopicsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.topicNames == null ? other.topicNames != null : !this.topicNames.equals(other.topicNames)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.topicNames == null ? 0 : this.topicNames.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public DeleteTopicsRequestData duplicate() {
        DeleteTopicsRequestData _duplicate = new DeleteTopicsRequestData();
        ArrayList<DeleteTopicState> newTopics = new ArrayList<DeleteTopicState>(this.topics.size());
        for (DeleteTopicState _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        ArrayList<String> newTopicNames = new ArrayList<String>(this.topicNames.size());
        for (String _element : this.topicNames) {
            newTopicNames.add(_element);
        }
        _duplicate.topicNames = newTopicNames;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "DeleteTopicsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", topicNames=" + MessageUtil.deepToString(this.topicNames.iterator()) + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<DeleteTopicState> topics() {
        return this.topics;
    }

    public List<String> topicNames() {
        return this.topicNames;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteTopicsRequestData setTopics(List<DeleteTopicState> v) {
        this.topics = v;
        return this;
    }

    public DeleteTopicsRequestData setTopicNames(List<String> v) {
        this.topicNames = v;
        return this;
    }

    public DeleteTopicsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic_names", new ArrayOf(Type.STRING), "The names of the topics to delete"), new Field("timeout_ms", Type.INT32, "The length of time in milliseconds to wait for the deletions to complete."))));
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field("topic_names", new CompactArrayOf(Type.COMPACT_STRING), "The names of the topics to delete"), new Field("timeout_ms", Type.INT32, "The length of time in milliseconds to wait for the deletions to complete."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_6 = new Schema(new Field("topics", new CompactArrayOf(DeleteTopicState.SCHEMA_6), "The name or topic ID of the topic"), new Field("timeout_ms", Type.INT32, "The length of time in milliseconds to wait for the deletions to complete."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
    }

    public static class DeleteTopicState
    implements Message {
        String name;
        Uuid topicId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_6 = new Schema(new Field("name", Type.COMPACT_NULLABLE_STRING, "The topic name"), new Field("topic_id", Type.UUID, "The unique topic ID"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, null, SCHEMA_6};
        public static final short LOWEST_SUPPORTED_VERSION = 6;
        public static final short HIGHEST_SUPPORTED_VERSION = 6;

        public DeleteTopicState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DeleteTopicState() {
            this.name = "";
            this.topicId = Uuid.ZERO_UUID;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteTopicState");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.name = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field name had invalid length " + length);
                }
                this.name = _readable.readString(length);
            }
            this.topicId = _readable.readUuid();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 6) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteTopicState");
            }
            int _numTaggedFields = 0;
            if (this.name == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.name);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUuid(this.topicId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteTopicState");
            }
            if (this.name == null) {
                _size.addBytes(1);
            } else {
                byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'name' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.name, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(16);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteTopicState)) {
                return false;
            }
            DeleteTopicState other = (DeleteTopicState)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.topicId.hashCode();
            return hashCode;
        }

        @Override
        public DeleteTopicState duplicate() {
            DeleteTopicState _duplicate = new DeleteTopicState();
            _duplicate.name = this.name == null ? null : this.name;
            _duplicate.topicId = this.topicId;
            return _duplicate;
        }

        public String toString() {
            return "DeleteTopicState(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", topicId=" + this.topicId.toString() + ")";
        }

        public String name() {
            return this.name;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteTopicState setName(String v) {
            this.name = v;
            return this;
        }

        public DeleteTopicState setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }
    }
}

