/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret;

import java.util.Locale;
import java.util.regex.Pattern;

public class SecretIdentifier {
    private static final Pattern colonPattern = Pattern.compile(":");
    private static final String VERSION = "v1";
    private static final Pattern urnPattern = Pattern.compile("urn:logstash:secret:v1:.*$");
    private final String key;

    public SecretIdentifier(String key) {
        this.key = SecretIdentifier.validateWithTransform(key, "key");
    }

    public static SecretIdentifier fromExternalForm(String urn) {
        if (urn == null || !urnPattern.matcher(urn).matches()) {
            throw new IllegalArgumentException("Invalid external form " + urn);
        }
        String[] parts = colonPattern.split(urn, 5);
        return new SecretIdentifier(SecretIdentifier.validateWithTransform(parts[4], "key"));
    }

    private static String validateWithTransform(String part, String partName) {
        if (part == null || part.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s may not be null or empty", partName));
        }
        return part.toLowerCase(Locale.US);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretIdentifier that = (SecretIdentifier)o;
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (VERSION != null ? VERSION.hashCode() : 0);
        return result;
    }

    public String toExternalForm() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("urn").append(":");
        sb.append("logstash").append(":");
        sb.append("secret").append(":");
        sb.append(VERSION).append(":");
        sb.append(this.key);
        return sb.toString();
    }

    public String toString() {
        return this.toExternalForm();
    }
}

