/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import co.elastic.logstash.api.Filter;
import co.elastic.logstash.api.FilterMatchListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Event;
import org.logstash.RubyUtil;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.config.ir.compiler.CommonActions;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;

@JRubyClass(name={"JavaFilterDelegator"})
public class JavaFilterDelegatorExt
extends AbstractFilterDelegatorExt {
    private static final long serialVersionUID = 1L;
    private RubyString configName;
    private transient Filter filter;
    private transient FilterMatchListener filterMatchListener;

    public JavaFilterDelegatorExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public static JavaFilterDelegatorExt create(String configName, String id, AbstractNamespacedMetricExt metric, Filter filter, Map<String, Object> pluginArgs) {
        JavaFilterDelegatorExt instance = new JavaFilterDelegatorExt(RubyUtil.RUBY, RubyUtil.JAVA_FILTER_DELEGATOR_CLASS);
        instance.configName = RubyUtil.RUBY.newString(configName);
        AbstractNamespacedMetricExt scopedMetric = metric.namespace(RubyUtil.RUBY.getCurrentContext(), (IRubyObject)RubyUtil.RUBY.newSymbol(filter.getId()));
        instance.initMetrics(id, scopedMetric);
        instance.filter = filter;
        instance.initializeFilterMatchListener(pluginArgs);
        return instance;
    }

    @Override
    protected RubyArray doMultiFilter(RubyArray batch) {
        List<co.elastic.logstash.api.Event> inputEvents = batch.stream().map(x -> ((JrubyEventExtLibrary.RubyEvent)((Object)((Object)x))).getEvent()).collect(Collectors.toList());
        Collection<co.elastic.logstash.api.Event> outputEvents = this.filter.filter(inputEvents, this.filterMatchListener);
        RubyArray newBatch = RubyArray.newArray((Ruby)RubyUtil.RUBY, (int)outputEvents.size());
        for (co.elastic.logstash.api.Event outputEvent : outputEvents) {
            newBatch.add((Object)JrubyEventExtLibrary.RubyEvent.newRubyEvent(RubyUtil.RUBY, (Event)outputEvent));
        }
        return newBatch;
    }

    @Override
    protected void doRegister(ThreadContext context) {
    }

    @Override
    protected IRubyObject doFlush(ThreadContext context, RubyHash options) {
        if (this.filter.requiresFlush()) {
            Collection<co.elastic.logstash.api.Event> outputEvents = this.filter.flush(this.filterMatchListener);
            Ruby runtime = context.runtime;
            RubyArray newBatch = RubyArray.newArray((Ruby)runtime, (int)outputEvents.size());
            for (co.elastic.logstash.api.Event outputEvent : outputEvents) {
                newBatch.add((Object)JrubyEventExtLibrary.RubyEvent.newRubyEvent(runtime, (Event)outputEvent));
            }
            return newBatch;
        }
        return context.nil;
    }

    @Override
    protected IRubyObject closeImpl(ThreadContext context) {
        return context.nil;
    }

    @Override
    protected IRubyObject doCloseImpl(ThreadContext context) {
        return context.nil;
    }

    @Override
    protected IRubyObject doStopImpl(ThreadContext context) {
        return context.nil;
    }

    @Override
    protected IRubyObject reloadable(ThreadContext context) {
        return context.tru;
    }

    @Override
    protected IRubyObject isThreadsafe(ThreadContext context) {
        return context.tru;
    }

    @Override
    protected IRubyObject getConfigName(ThreadContext context) {
        return this.configName;
    }

    @Override
    protected boolean getHasFlush() {
        return this.filter.requiresFlush();
    }

    @Override
    protected boolean getPeriodicFlush() {
        return this.filter.requiresPeriodicFlush();
    }

    private void initializeFilterMatchListener(Map<String, Object> pluginArgs) {
        ArrayList<Consumer<co.elastic.logstash.api.Event>> filterActions = new ArrayList<Consumer<co.elastic.logstash.api.Event>>();
        for (Map.Entry<String, Object> entry : pluginArgs.entrySet()) {
            Consumer<co.elastic.logstash.api.Event> filterAction = CommonActions.getFilterAction(entry);
            if (filterAction == null) continue;
            filterActions.add(filterAction);
        }
        this.filterMatchListener = filterActions.size() == 0 ? e -> {} : new DecoratingFilterMatchListener(filterActions);
    }

    static class DecoratingFilterMatchListener
    implements FilterMatchListener {
        private final List<Consumer<co.elastic.logstash.api.Event>> actions;

        DecoratingFilterMatchListener(List<Consumer<co.elastic.logstash.api.Event>> actions) {
            this.actions = actions;
        }

        @Override
        public void filterMatched(co.elastic.logstash.api.Event e) {
            for (Consumer<co.elastic.logstash.api.Event> action : this.actions) {
                action.accept(e);
            }
        }
    }
}

