/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.Html4Document;
import nokogiri.NokogiriService;
import nokogiri.XmlAttr;
import nokogiri.XmlCdata;
import nokogiri.XmlComment;
import nokogiri.XmlDocument;
import nokogiri.XmlDtd;
import nokogiri.XmlElement;
import nokogiri.XmlEntityReference;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.XmlProcessingInstruction;
import nokogiri.XmlText;
import nokogiri.internals.NokogiriNamespaceCache;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NokogiriHelpers {
    public static final String CACHED_NODE = "NOKOGIRI_CACHED_NODE";
    public static final String ROOT_NODE_INVALID = "NOKOGIRI_ROOT_NODE_INVALID";
    public static final String ENCODED_STRING = "NOKOGIRI_ENCODED_STRING";
    private static final Pattern encoded_pattern = Pattern.compile("&amp;|&gt;|&lt;|&#13;");
    private static final String[] encoded = new String[]{"&amp;", "&gt;", "&lt;", "&#13;"};
    private static final Pattern decoded_pattern = Pattern.compile("&|>|<|\r");
    private static final String[] decoded = new String[]{"&", ">", "<", "\r"};
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final Set<String> CharsetNames = Charset.availableCharsets().keySet();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final ByteList _Sw = new ByteList(new byte[]{45, 83, 119}, false);
    private static final ByteList _Jw = new ByteList(new byte[]{45, 74, 119}, false);
    private static final ByteList _Ew = new ByteList(new byte[]{45, 69, 119}, false);
    private static final ByteList _Ww = new ByteList(new byte[]{45, 87, 119}, false);
    private static final Charset Shift_JIS = Charset.forName("Shift_JIS");
    private static final Charset ISO_2022_JP = Charset.forName("ISO-2022-JP");
    private static final Charset EUC_JP = Charset.forName("EUC-JP");

    public static XmlNode getCachedNode(Node node) {
        return (XmlNode)((Object)node.getUserData(CACHED_NODE));
    }

    public static void clearCachedNode(Node node) {
        node.setUserData(CACHED_NODE, null, null);
    }

    public static void clearXpathContext(Node node) {
        if (node == null) {
            return;
        }
        Node node2 = node.getOwnerDocument();
        if (node2 == null) {
            node2 = node;
        }
        node2.setUserData("CACHED_XPATH_CONTEXT", null, null);
    }

    public static IRubyObject getCachedNodeOrCreate(Ruby ruby, Node node) {
        XmlNode xmlNode;
        if (node == null) {
            return ruby.getNil();
        }
        if (node.getNodeType() == 2 && NokogiriHelpers.isNamespace(node.getNodeName()) && !((xmlNode = (XmlDocument)((Object)node.getOwnerDocument().getUserData(CACHED_NODE))) instanceof Html4Document)) {
            String string = NokogiriHelpers.getLocalNameForNamespace(((Attr)node).getName(), null);
            String string2 = ((Attr)node).getValue();
            XmlNamespace xmlNamespace = ((XmlDocument)xmlNode).getNamespaceCache().get(string, string2);
            if (xmlNamespace != null) {
                return xmlNamespace;
            }
            return XmlNamespace.createFromAttr(ruby, (Attr)node);
        }
        xmlNode = NokogiriHelpers.getCachedNode(node);
        if (xmlNode == null) {
            xmlNode = (XmlNode)NokogiriHelpers.constructNode(ruby, node);
            node.setUserData(CACHED_NODE, (Object)xmlNode, null);
        }
        return xmlNode;
    }

    public static IRubyObject constructNode(Ruby ruby, Node node) {
        if (node == null) {
            return ruby.getNil();
        }
        switch (node.getNodeType()) {
            case 1: {
                XmlElement xmlElement = (XmlElement)NokogiriService.XML_ELEMENT_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Element"));
                xmlElement.setNode(ruby, node);
                return xmlElement;
            }
            case 2: {
                XmlAttr xmlAttr = (XmlAttr)NokogiriService.XML_ATTR_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Attr"));
                xmlAttr.setNode(ruby, node);
                return xmlAttr;
            }
            case 3: {
                XmlText xmlText = (XmlText)NokogiriService.XML_TEXT_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Text"));
                xmlText.setNode(ruby, node);
                return xmlText;
            }
            case 8: {
                XmlComment xmlComment = (XmlComment)NokogiriService.XML_COMMENT_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Comment"));
                xmlComment.setNode(ruby, node);
                return xmlComment;
            }
            case 6: {
                return new XmlNode(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::EntityDecl"), node);
            }
            case 5: {
                XmlEntityReference xmlEntityReference = (XmlEntityReference)NokogiriService.XML_ENTITY_REFERENCE_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::EntityReference"));
                xmlEntityReference.setNode(ruby, node);
                return xmlEntityReference;
            }
            case 7: {
                XmlProcessingInstruction xmlProcessingInstruction = (XmlProcessingInstruction)NokogiriService.XML_PROCESSING_INSTRUCTION_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::ProcessingInstruction"));
                xmlProcessingInstruction.setNode(ruby, node);
                return xmlProcessingInstruction;
            }
            case 4: {
                XmlCdata xmlCdata = (XmlCdata)NokogiriService.XML_CDATA_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::CDATA"));
                xmlCdata.setNode(ruby, node);
                return xmlCdata;
            }
            case 9: {
                XmlDocument xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document"));
                xmlDocument.setDocumentNode(ruby, (Document)node);
                return xmlDocument;
            }
            case 10: {
                XmlDtd xmlDtd = (XmlDtd)NokogiriService.XML_DTD_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::DTD"));
                xmlDtd.setNode(ruby, node);
                return xmlDtd;
            }
        }
        XmlNode xmlNode = (XmlNode)NokogiriService.XML_NODE_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Node"));
        xmlNode.setNode(ruby, node);
        return xmlNode;
    }

    public static RubyClass getNokogiriClass(Ruby ruby, String string) {
        return NokogiriService.getNokogiriClassCache(ruby).get(string);
    }

    public static IRubyObject stringOrNil(Ruby ruby, String string) {
        return string == null ? ruby.getNil() : NokogiriHelpers.convertString(ruby, string);
    }

    public static IRubyObject stringOrNil(Ruby ruby, CharSequence charSequence) {
        return charSequence == null ? ruby.getNil() : NokogiriHelpers.convertString(ruby, charSequence);
    }

    public static IRubyObject stringOrNil(Ruby ruby, byte[] byArray) {
        return byArray == null ? ruby.getNil() : RubyString.newString((Ruby)ruby, (byte[])byArray);
    }

    public static IRubyObject stringOrBlank(Ruby ruby, String string) {
        return string == null ? ruby.newString() : NokogiriHelpers.convertString(ruby, string);
    }

    public static RubyString convertString(Ruby ruby, String string) {
        return RubyString.newUTF8String((Ruby)ruby, (String)string);
    }

    public static RubyString convertString(Ruby ruby, CharSequence charSequence) {
        return RubyString.newUTF8String((Ruby)ruby, (CharSequence)charSequence);
    }

    public static IRubyObject nonEmptyStringOrNil(Ruby ruby, String string) {
        if (string == null || string.length() == 0) {
            return ruby.getNil();
        }
        return RubyString.newString((Ruby)ruby, (String)string);
    }

    public static String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        return n > 0 ? string.substring(0, n) : null;
    }

    public static String getLocalPart(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public static String getLocalNameForNamespace(String string, String string2) {
        String string3 = NokogiriHelpers.getLocalPart(string);
        return "xmlns".equals(string3) ? string2 : string3;
    }

    public static String rubyStringToString(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return null;
        }
        return iRubyObject.convertToString().decodeString();
    }

    public static String rubyStringToString(RubyString rubyString) {
        return rubyString.decodeString();
    }

    public static ByteArrayInputStream stringBytesToStream(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString || iRubyObject.respondsTo("to_str")) {
            ByteList byteList = iRubyObject.convertToString().getByteList();
            return new ByteArrayInputStream(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        }
        return null;
    }

    public static String getNodeCompletePath(Node node) {
        Node node2;
        String string = "";
        Node node3 = node;
        do {
            Node node4;
            String string2 = "";
            String string3 = "?";
            int n = 0;
            boolean bl = false;
            if (node3.getNodeType() == 9) {
                if (string.startsWith("/")) break;
                string3 = "/";
                node2 = null;
            } else if (node3.getNodeType() == 1) {
                bl = false;
                string3 = "/";
                string2 = node3.getLocalName();
                if (string2 == null) {
                    string2 = node3.getNodeName();
                }
                if (node3.getNamespaceURI() != null) {
                    if (node3.getPrefix() != null) {
                        string2 = node3.getPrefix() + ":" + string2;
                    } else {
                        bl = true;
                        string2 = "*";
                    }
                }
                node2 = node3.getParentNode();
                for (node4 = node3.getPreviousSibling(); node4 != null; node4 = node4.getPreviousSibling()) {
                    if (node4.getNodeType() != 1 || !bl && !NokogiriHelpers.fullNamesMatch(node4, node3)) continue;
                    ++n;
                }
                if (n == 0) {
                    for (node4 = node3.getNextSibling(); node4 != null && n == 0; node4 = node4.getNextSibling()) {
                        if (node4.getNodeType() != 1 || !bl && !NokogiriHelpers.fullNamesMatch(node4, node3)) continue;
                        ++n;
                    }
                    if (n != 0) {
                        n = 1;
                    }
                } else {
                    ++n;
                }
            } else if (node3.getNodeType() == 8) {
                string3 = "/";
                string2 = "comment()";
                node2 = node3.getParentNode();
                for (node4 = node3.getPreviousSibling(); node4 != null; node4 = node4.getPreviousSibling()) {
                    if (node4.getNodeType() != 8) continue;
                    ++n;
                }
                if (n == 0) {
                    for (node4 = node3.getNextSibling(); node4 != null && n == 0; node4 = node4.getNextSibling()) {
                        if (node4.getNodeType() != 8) continue;
                        ++n;
                    }
                    if (n != 0) {
                        n = 1;
                    }
                } else {
                    n = 1;
                }
            } else if (node3.getNodeType() == 3 || node3.getNodeType() == 4) {
                string3 = "/";
                string2 = "text()";
                node2 = node3.getParentNode();
                for (node4 = node3.getPreviousSibling(); node4 != null; node4 = node4.getPreviousSibling()) {
                    if (node4.getNodeType() != 3 && node4.getNodeType() != 4) continue;
                    ++n;
                }
                if (n == 0) {
                    for (node4 = node3.getNextSibling(); node4 != null && n == 0; node4 = node4.getNextSibling()) {
                        if (node4.getNodeType() != 3 && node4.getNodeType() != 4) continue;
                        ++n;
                    }
                } else {
                    ++n;
                }
            } else if (node3.getNodeType() == 7) {
                string3 = "/";
                string2 = "processing-instruction('" + node3.getLocalName() + "')";
                node2 = node3.getParentNode();
                for (node4 = node3.getParentNode(); node4 != null; node4 = node4.getPreviousSibling()) {
                    if (node4.getNodeType() != 7 || !node4.getLocalName().equals(node3.getLocalName())) continue;
                    ++n;
                }
                if (n == 0) {
                    for (node4 = node3.getNextSibling(); node4 != null && n == 0; node4 = node4.getNextSibling()) {
                        if (node4.getNodeType() != 7 || !node4.getLocalName().equals(node3.getLocalName())) continue;
                        ++n;
                    }
                    if (n != 0) {
                        n = 1;
                    }
                } else {
                    ++n;
                }
            } else if (node3.getNodeType() == 2) {
                string3 = "/@";
                string2 = node3.getLocalName();
                if (node3.getNamespaceURI() != null && node3.getPrefix() != null) {
                    string2 = node3.getPrefix() + ":" + string2;
                }
                node2 = ((Attr)node3).getOwnerElement();
            } else {
                node2 = node3.getParentNode();
            }
            string = n == 0 ? string3 + string2 + string : string3 + string2 + "[" + n + "]" + string;
        } while ((node3 = node2) != null);
        return string;
    }

    static boolean compareTwoNodes(Node node, Node node2) {
        return NokogiriHelpers.nodesAreEqual(node.getLocalName(), node2.getLocalName()) && NokogiriHelpers.nodesAreEqual(node.getPrefix(), node2.getPrefix());
    }

    private static boolean nodesAreEqual(Object object, Object object2) {
        return object == null && object2 == null || object != null && object2 != null && object2.equals(object);
    }

    private static boolean fullNamesMatch(Node node, Node node2) {
        return node.getNodeName().equals(node2.getNodeName());
    }

    private static StringBuffer convert(Pattern pattern, CharSequence charSequence, String[] stringArray, String[] stringArray2) {
        Matcher matcher = pattern.matcher(charSequence);
        boolean bl = matcher.find();
        StringBuffer stringBuffer = new StringBuffer(charSequence.length() + 8);
        while (bl) {
            String string = matcher.group();
            String string2 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.contains(stringArray[i])) continue;
                string2 = string.replace(stringArray[i], stringArray2[i]);
                break;
            }
            matcher.appendReplacement(stringBuffer, string2);
            bl = matcher.find();
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer;
    }

    public static CharSequence encodeJavaString(CharSequence charSequence) {
        return NokogiriHelpers.convert(decoded_pattern, charSequence, decoded, encoded);
    }

    public static CharSequence decodeJavaString(CharSequence charSequence) {
        return NokogiriHelpers.convert(encoded_pattern, charSequence, encoded, decoded);
    }

    public static boolean isNamespace(Node node) {
        return XMLNS_URI.equals(node.getNamespaceURI()) || NokogiriHelpers.isNamespace(node.getNodeName());
    }

    public static boolean isNamespace(String string) {
        return string.startsWith("xmlns");
    }

    public static boolean isNonDefaultNamespace(Node node) {
        return NokogiriHelpers.isNamespace(node) && !"xmlns".equals(node.getNodeName());
    }

    public static boolean isXmlBase(String string) {
        return "xml:base".equals(string) || "xlink:href".equals(string);
    }

    public static boolean isBlank(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof XmlText)) {
            return false;
        }
        CharSequence charSequence = ((XmlNode)iRubyObject).getContentImpl();
        return charSequence == null || NokogiriHelpers.isBlank(charSequence);
    }

    public static boolean isBlank(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) <= ' '; ++n) {
        }
        return n == n2;
    }

    public static boolean isBlank(String string) {
        return string.isEmpty() || NokogiriHelpers.isBlank((CharSequence)string);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static CharSequence canonicalizeWhitespace(CharSequence charSequence) {
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                if (bl) continue;
                stringBuilder.append(c);
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public static String newQName(String string, Node node) {
        String string2 = NokogiriHelpers.getLocalPart(node.getNodeName());
        if (string == null) {
            return string2;
        }
        return string + ':' + string2;
    }

    public static IRubyObject[] nodeListToRubyArray(Ruby ruby, NodeList nodeList) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            iRubyObjectArray[i] = NokogiriHelpers.getCachedNodeOrCreate(ruby, nodeList.item(i));
        }
        return iRubyObjectArray;
    }

    public static IRubyObject[] nodeListToArray(Ruby ruby, List<Node> list) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[list.size()];
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            iRubyObjectArray[i] = NokogiriHelpers.getCachedNodeOrCreate(ruby, list.get(i));
        }
        return iRubyObjectArray;
    }

    public static RubyArray nodeArrayToRubyArray(Ruby ruby, Node[] nodeArray) {
        RubyArray rubyArray = RubyArray.newArray((Ruby)ruby, (int)nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            rubyArray.append(NokogiriHelpers.getCachedNodeOrCreate(ruby, nodeArray[i]));
        }
        return rubyArray;
    }

    public static String getValidEncodingOrNull(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return null;
        }
        String string = NokogiriHelpers.rubyStringToString(iRubyObject.convertToString());
        if (CharsetNames.contains(string)) {
            return string;
        }
        return null;
    }

    public static String getValidEncoding(IRubyObject iRubyObject) {
        String string = NokogiriHelpers.getValidEncodingOrNull(iRubyObject);
        if (string != null) {
            return string;
        }
        return Charset.defaultCharset().name();
    }

    public static String adjustSystemIdIfNecessary(String string, String string2, String string3, String string4) {
        if (string4 == null) {
            return string4;
        }
        File file = new File(string4);
        if (file.isAbsolute()) {
            return string4;
        }
        String string5 = NokogiriHelpers.resolveSystemId(string3, string4);
        if (string5 != null) {
            return string5;
        }
        string5 = NokogiriHelpers.resolveSystemId(string, string4);
        if (string5 != null) {
            return string5;
        }
        return NokogiriHelpers.resolveSystemId(string2, string4);
    }

    private static String resolveSystemId(String string, String string2) {
        File file;
        if (string == null || string.length() < 1) {
            return null;
        }
        File file2 = new File(string = string.replace("%20", " "));
        String string3 = file2.isDirectory() ? string : file2.getParent();
        if (string3 == null) {
            return null;
        }
        if (string3.toLowerCase().startsWith("file:")) {
            string3 = string3.substring("file:".length());
        }
        if ((file = new File(string3 + "/" + string2)).exists()) {
            return file.getPath();
        }
        return null;
    }

    public static boolean isUTF8(String string) {
        if (string == null) {
            return true;
        }
        if ("UTF-8".equals(string)) {
            return true;
        }
        return UTF8.aliases().contains(string);
    }

    public static ByteBuffer convertEncoding(Charset charset, CharSequence charSequence) {
        return charset.encode(CharBuffer.wrap(charSequence));
    }

    public static CharSequence convertEncodingByNKFIfNecessary(ThreadContext threadContext, XmlDocument xmlDocument, CharSequence charSequence) {
        if (!(xmlDocument instanceof Html4Document)) {
            return charSequence;
        }
        String string = ((Html4Document)xmlDocument).getPraedEncoding();
        if (string == null) {
            return charSequence;
        }
        String string2 = NokogiriHelpers.rubyStringToString(xmlDocument.getEncoding());
        if (string2 == null) {
            return charSequence;
        }
        Charset charset = Charset.forName(string2);
        if (Charset.forName(string).compareTo(charset) == 0) {
            return charSequence;
        }
        if (charSequence.length() == 0) {
            return charSequence;
        }
        return NokogiriHelpers.nkf(threadContext, charset, charSequence);
    }

    private static CharSequence nkf(ThreadContext threadContext, Charset charset, CharSequence charSequence) {
        Class<?> clazz;
        Ruby ruby = threadContext.getRuntime();
        ByteList byteList = Shift_JIS.compareTo(charset) == 0 ? _Sw : (ISO_2022_JP.compareTo(charset) == 0 ? _Jw : (EUC_JP.compareTo(charset) == 0 ? _Ew : _Ww));
        try {
            clazz = ruby.getClassLoader().loadClass("org.jruby.ext.nkf.RubyNKF");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return charSequence;
        }
        try {
            Method method = clazz.getMethod("nkf", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
            RubyString rubyString = (RubyString)method.invoke(null, threadContext, null, ruby.newString(byteList), ruby.newString(charSequence.toString()));
            return NokogiriHelpers.rubyStringToString(rubyString);
        }
        catch (SecurityException securityException) {
            return charSequence;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return charSequence;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return charSequence;
        }
        catch (IllegalAccessException illegalAccessException) {
            return charSequence;
        }
        catch (InvocationTargetException invocationTargetException) {
            return charSequence;
        }
    }

    public static boolean shouldEncode(Node node) {
        Boolean bl = (Boolean)node.getUserData(ENCODED_STRING);
        return bl == null || bl == false;
    }

    public static boolean shouldDecode(Node node) {
        return !NokogiriHelpers.shouldEncode(node);
    }

    public static NokogiriNamespaceCache getNamespaceCache(Node node) {
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNode(node.getOwnerDocument());
        return xmlDocument.getNamespaceCache();
    }

    public static Node renameNode(Node node, String string, String string2) throws DOMException {
        Document document = node.getOwnerDocument();
        NokogiriNamespaceCache nokogiriNamespaceCache = NokogiriHelpers.getNamespaceCache(node);
        Node node2 = document.renameNode(node, string, string2);
        if (node2 != node) {
            nokogiriNamespaceCache.replaceNode(node, node2);
        }
        return node2;
    }
}

