/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.log;

import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.log.LogstashLoggerContextFactory;

@JRubyClass(name={"Logger"})
public class LoggerExt
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final Object CONFIG_LOCK = new Object();
    private transient Logger logger;

    public LoggerExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    public LoggerExt initialize(ThreadContext context, IRubyObject loggerName) {
        this.logger = LogManager.getLogger((String)loggerName.asJavaString());
        return this;
    }

    @JRubyMethod(name={"debug?"})
    public RubyBoolean isDebug(ThreadContext context) {
        return this.logger.isDebugEnabled() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"info?"})
    public RubyBoolean isInfo(ThreadContext context) {
        return this.logger.isInfoEnabled() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"error?"})
    public RubyBoolean isError(ThreadContext context) {
        return this.logger.isErrorEnabled() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"warn?"})
    public RubyBoolean isWarn(ThreadContext context) {
        return this.logger.isWarnEnabled() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"fatal?"})
    public RubyBoolean isFatal(ThreadContext context) {
        return this.logger.isDebugEnabled() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"trace?"})
    public RubyBoolean isTrace(ThreadContext context) {
        return this.logger.isDebugEnabled() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"debug"}, required=1, optional=1)
    public IRubyObject rubyDebug(ThreadContext context, IRubyObject[] args) {
        if (args.length > 1) {
            this.logger.debug(args[0].asJavaString(), (Object)args[1]);
        } else {
            this.logger.debug(args[0].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"warn"}, required=1, optional=1)
    public IRubyObject rubyWarn(ThreadContext context, IRubyObject[] args) {
        if (args.length > 1) {
            this.logger.warn(args[0].asJavaString(), (Object)args[1]);
        } else {
            this.logger.warn(args[0].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"info"}, required=1, optional=1)
    public IRubyObject rubyInfo(ThreadContext context, IRubyObject[] args) {
        if (args.length > 1) {
            this.logger.info(args[0].asJavaString(), (Object)args[1]);
        } else {
            this.logger.info(args[0].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"error"}, required=1, optional=1)
    public IRubyObject rubyError(ThreadContext context, IRubyObject[] args) {
        if (args.length > 1) {
            this.logger.error(args[0].asJavaString(), (Object)args[1]);
        } else {
            this.logger.error(args[0].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"fatal"}, required=1, optional=1)
    public IRubyObject rubyFatal(ThreadContext context, IRubyObject[] args) {
        if (args.length > 1) {
            this.logger.fatal(args[0].asJavaString(), (Object)args[1]);
        } else {
            this.logger.fatal(args[0].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"trace"}, required=1, optional=1)
    public IRubyObject rubyTrace(ThreadContext context, IRubyObject[] args) {
        if (args.length > 1) {
            this.logger.trace(args[0].asJavaString(), (Object)args[1]);
        } else {
            this.logger.trace(args[0].asJavaString());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"configure_logging"}, meta=true, required=1, optional=1)
    public static IRubyObject configureLogging(ThreadContext context, IRubyObject self, IRubyObject[] args) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            IRubyObject path = args.length > 1 ? args[1] : null;
            String level = args[0].asJavaString();
            try {
                LoggerExt.setLevel(level, path == null || path.isNil() ? null : path.asJavaString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("invalid level[%s] for logger[%s]", level, path));
            }
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"reconfigure", "initialize"}, meta=true)
    public static IRubyObject reconfigure(ThreadContext context, IRubyObject self, IRubyObject configPath) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            URI configLocation = URI.create(configPath.asJavaString());
            String filePath = configLocation.getPath();
            File configFile = new File(filePath);
            if (configFile.exists()) {
                String logsLocation = System.getProperty("ls.logs");
                System.out.println(String.format("Sending Logstash logs to %s which is now configured via log4j2.properties", logsLocation));
                LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
                loggerContext.setConfigLocation(configLocation);
                LogManager.setFactory((LoggerContextFactory)new LogstashLoggerContextFactory((org.apache.logging.log4j.spi.LoggerContext)loggerContext));
            } else {
                System.out.println(String.format("Could not find log4j2 configuration at path %s. Using default config which logs errors to the console", filePath));
            }
        }
        return context.nil;
    }

    @JRubyMethod(name={"get_logging_context"}, meta=true)
    public static IRubyObject getLoggingContext(ThreadContext context, IRubyObject self) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)LoggerContext.getContext((boolean)false));
    }

    private static void setLevel(String level, String loggerPath) {
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        Level logLevel = Level.valueOf((String)level);
        if (loggerPath == null || loggerPath.equals("")) {
            LoggerConfig rootLogger = config.getRootLogger();
            if (rootLogger.getLevel() != logLevel) {
                rootLogger.setLevel(logLevel);
                loggerContext.updateLoggers();
            }
        } else {
            LoggerConfig packageLogger = config.getLoggerConfig(loggerPath);
            if (!packageLogger.getName().equals(loggerPath)) {
                config.addLogger(loggerPath, new LoggerConfig(loggerPath, logLevel, true));
                loggerContext.updateLoggers();
            } else if (packageLogger.getLevel() != logLevel) {
                packageLogger.setLevel(logLevel);
                loggerContext.updateLoggers();
            }
        }
    }
}

