/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ext;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.execution.queue.QueueWriter;
import org.logstash.ext.JRubyAbstractQueueWriteClientExt;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.counter.LongCounter;

@JRubyClass(name={"WrappedWriteClient"})
public final class JRubyWrappedWriteClientExt
extends RubyObject
implements QueueWriter {
    private static final long serialVersionUID = 1L;
    private static final RubySymbol PUSH_DURATION_KEY = RubyUtil.RUBY.newSymbol("queue_push_duration_in_millis");
    private JRubyAbstractQueueWriteClientExt writeClient;
    private transient LongCounter eventsMetricsCounter;
    private transient LongCounter eventsMetricsTime;
    private transient LongCounter pipelineMetricsCounter;
    private transient LongCounter pipelineMetricsTime;
    private transient LongCounter pluginMetricsCounter;
    private transient LongCounter pluginMetricsTime;

    public JRubyWrappedWriteClientExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(required=4)
    public JRubyWrappedWriteClientExt initialize(ThreadContext context, IRubyObject[] args) {
        return this.initialize((JRubyAbstractQueueWriteClientExt)args[0], args[1].asJavaString(), (AbstractMetricExt)args[2], args[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRubyWrappedWriteClientExt initialize(JRubyAbstractQueueWriteClientExt queueWriteClientExt, String pipelineId, AbstractMetricExt metric, IRubyObject pluginId) {
        this.writeClient = queueWriteClientExt;
        AbstractMetricExt abstractMetricExt = metric;
        synchronized (abstractMetricExt) {
            AbstractNamespacedMetricExt eventsMetrics = JRubyWrappedWriteClientExt.getMetric(metric, "stats", "events");
            this.eventsMetricsCounter = LongCounter.fromRubyBase(eventsMetrics, MetricKeys.IN_KEY);
            this.eventsMetricsTime = LongCounter.fromRubyBase(eventsMetrics, PUSH_DURATION_KEY);
            AbstractNamespacedMetricExt pipelineMetrics = JRubyWrappedWriteClientExt.getMetric(metric, "stats", "pipelines", pipelineId, "events");
            this.pipelineMetricsCounter = LongCounter.fromRubyBase(pipelineMetrics, MetricKeys.IN_KEY);
            this.pipelineMetricsTime = LongCounter.fromRubyBase(pipelineMetrics, PUSH_DURATION_KEY);
            AbstractNamespacedMetricExt pluginMetrics = JRubyWrappedWriteClientExt.getMetric(metric, "stats", "pipelines", pipelineId, "plugins", "inputs", pluginId.asJavaString(), "events");
            this.pluginMetricsCounter = LongCounter.fromRubyBase(pluginMetrics, MetricKeys.OUT_KEY);
            this.pluginMetricsTime = LongCounter.fromRubyBase(pluginMetrics, PUSH_DURATION_KEY);
        }
        return this;
    }

    @JRubyMethod(name={"push", "<<"}, required=1)
    public IRubyObject push(ThreadContext context, IRubyObject event) throws InterruptedException {
        long start = System.nanoTime();
        this.incrementCounters(1L);
        JRubyAbstractQueueWriteClientExt res = this.writeClient.doPush(context, (JrubyEventExtLibrary.RubyEvent)event);
        this.incrementTimers(start);
        return res;
    }

    @JRubyMethod(name={"push_batch"}, required=1)
    public IRubyObject pushBatch(ThreadContext context, IRubyObject batch) throws InterruptedException {
        long start = System.nanoTime();
        this.incrementCounters(((Collection)batch).size());
        JRubyAbstractQueueWriteClientExt res = this.writeClient.doPushBatch(context, (Collection)batch);
        this.incrementTimers(start);
        return res;
    }

    @Deprecated
    @JRubyMethod(name={"get_new_batch"})
    public IRubyObject newBatch(ThreadContext context) {
        return context.runtime.newArray();
    }

    private void incrementCounters(long count) {
        this.eventsMetricsCounter.increment(count);
        this.pipelineMetricsCounter.increment(count);
        this.pluginMetricsCounter.increment(count);
    }

    private void incrementTimers(long start) {
        long increment = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        this.eventsMetricsTime.increment(increment);
        this.pipelineMetricsTime.increment(increment);
        this.pluginMetricsTime.increment(increment);
    }

    private static AbstractNamespacedMetricExt getMetric(AbstractMetricExt base, String ... keys) {
        return base.namespace(RubyUtil.RUBY.getCurrentContext(), JRubyWrappedWriteClientExt.toSymbolArray(keys));
    }

    private static IRubyObject toSymbolArray(String ... strings) {
        IRubyObject[] res = new IRubyObject[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            res[i] = RubyUtil.RUBY.newSymbol(strings[i]);
        }
        return RubyUtil.RUBY.newArray(res);
    }

    @Override
    public void push(Map<String, Object> event) {
        long start = System.nanoTime();
        this.incrementCounters(1L);
        this.writeClient.push(event);
        this.incrementTimers(start);
    }
}

