/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.parser;

import java.util.Locale;
import org.joda.time.DateTimeZone;
import org.logstash.filters.parser.CasualISO8601Parser;
import org.logstash.filters.parser.JodaParser;
import org.logstash.filters.parser.TAI64NParser;
import org.logstash.filters.parser.TimestampParser;
import org.logstash.filters.parser.UnixEpochParser;
import org.logstash.filters.parser.UnixMillisEpochParser;

public class TimestampParserFactory {
    private DateTimeZone timezone;
    private static final String ISO8601 = "ISO8601";
    private static final String UNIX = "UNIX";
    private static final String UNIX_MS = "UNIX_MS";
    private static final String TAI64N = "TAI64N";

    public static TimestampParser makeParser(String pattern, Locale locale, String zone) {
        String tz;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((tz = zone) == null) {
            tz = DateTimeZone.getDefault().getID();
        } else if (zone.contains("%{")) {
            tz = null;
        }
        switch (pattern) {
            case "ISO8601": {
                return new CasualISO8601Parser(tz);
            }
            case "UNIX": {
                return new UnixEpochParser();
            }
            case "TAI64N": {
                return new TAI64NParser();
            }
            case "UNIX_MS": {
                return new UnixMillisEpochParser();
            }
        }
        return new JodaParser(pattern, locale, tz);
    }

    public static TimestampParser makeParser(String pattern) {
        return TimestampParserFactory.makeParser(pattern, (Locale)null, null);
    }

    public static TimestampParser makeParser(String pattern, String locale, String zone) {
        return TimestampParserFactory.makeParser(pattern, locale == null ? null : Locale.forLanguageTag(locale), zone);
    }
}

