/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.util;

import com.google.common.io.BaseEncoding;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.conn.ssl.TrustStrategy;

public class CATrustedFingerprintTrustStrategy
implements TrustStrategy {
    private final Set<Fingerprint> trustedFingerprints;
    private final Supplier<Date> dateSupplier;

    public CATrustedFingerprintTrustStrategy(String hexEncodedTrustedFingerprint) {
        this(hexEncodedTrustedFingerprint, Date::new);
    }

    public CATrustedFingerprintTrustStrategy(String hexEncodedTrustedFingerprint, Supplier<Date> dateSupplier) {
        this(Set.of(Fingerprint.fromHex(hexEncodedTrustedFingerprint)), dateSupplier);
    }

    public CATrustedFingerprintTrustStrategy(Collection<String> hexEncodedTrustedFingerprints) {
        this(hexEncodedTrustedFingerprints, Date::new);
    }

    public CATrustedFingerprintTrustStrategy(Collection<String> hexEncodedTrustedFingerprints, Supplier<Date> dateSupplier) {
        this(hexEncodedTrustedFingerprints.stream().map(Fingerprint::fromHex).collect(Collectors.toUnmodifiableSet()), dateSupplier);
    }

    CATrustedFingerprintTrustStrategy(Set<Fingerprint> trustedFingerprints) {
        this(trustedFingerprints, Date::new);
    }

    CATrustedFingerprintTrustStrategy(Set<Fingerprint> trustedFingerprints, Supplier<Date> dateSupplier) {
        this.trustedFingerprints = Set.copyOf(trustedFingerprints);
        this.dateSupplier = dateSupplier;
    }

    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain.length == 0 || this.trustedFingerprints.isEmpty()) {
            return false;
        }
        MessageDigest sha256Digest = this.sha256();
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate currentCandidate = chain[i];
            byte[] derEncoding = currentCandidate.getEncoded();
            Fingerprint candidateFingerprint = new Fingerprint(sha256Digest.digest(derEncoding));
            if (!this.trustedFingerprints.contains(candidateFingerprint)) continue;
            Date currentDate = this.dateSupplier.get();
            currentCandidate.checkValidity(currentDate);
            while (i > 0) {
                X509Certificate signer = chain[i];
                X509Certificate signed = chain[i - 1];
                this.verifyAndValidate(signed, signer, currentDate);
                --i;
            }
            return true;
        }
        return false;
    }

    private MessageDigest sha256() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private void verifyAndValidate(X509Certificate signed, X509Certificate signer, Date currentDate) throws CertificateException {
        try {
            signed.verify(signer.getPublicKey());
            signed.checkValidity(currentDate);
        }
        catch (SignatureException e) {
            throw new CertificateException(e);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class Fingerprint {
        private static final BaseEncoding HEX_ENCODING = BaseEncoding.base16().upperCase();
        private final byte[] value;

        static Fingerprint fromHex(String hexEncodedFingerprint) {
            try {
                byte[] bytes = HEX_ENCODING.decode((CharSequence)hexEncodedFingerprint.toUpperCase());
                return new Fingerprint(bytes);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("BAD INPUT: `%s`", hexEncodedFingerprint), e);
            }
        }

        private Fingerprint(byte[] fingerprint) {
            this.value = fingerprint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fingerprint that = (Fingerprint)o;
            return Arrays.equals(this.value, that.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }
}

