/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestConverter;

public class IngestJson {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestJson::mapProcessor).collect(Collectors.toList());
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(filters_pipeline, appendStdio));
    }

    private static String mapProcessor(Map processor) {
        return IngestConverter.filterHash(IngestConverter.createHash("json", IngestJson.jsonHash(processor)));
    }

    static String jsonHash(Map<String, Map> processor) {
        Map json_data = processor.get("json");
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(IngestConverter.createField("source", IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)json_data.get("field")))));
        if (json_data.containsKey("target_field")) {
            parts.add(IngestConverter.createField("target", IngestConverter.quoteString(IngestConverter.dotsToSquareBrackets((String)json_data.get("target_field")))));
        }
        return IngestConverter.joinHashFields(parts.toArray(new String[0]));
    }

    public static boolean has_json(Map<String, Object> processor) {
        return processor.containsKey("json");
    }
}

