/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.input;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.DLQEntry;
import org.logstash.Timestamp;
import org.logstash.ackedqueue.Queueable;
import org.logstash.common.io.DeadLetterQueueReader;
import org.logstash.input.SinceDB;

public class DeadLetterQueueInputPlugin {
    private static final Logger logger = LogManager.getLogger(DeadLetterQueueInputPlugin.class);
    static final char VERSION = '1';
    private final Path queuePath;
    private final boolean commitOffsets;
    private final Path sinceDbPath;
    private final AtomicBoolean open;
    private final AtomicBoolean readerHasState;
    private final Timestamp targetTimestamp;
    private volatile DeadLetterQueueReader queueReader;
    private SinceDB sinceDb;

    public DeadLetterQueueInputPlugin(Path path, boolean commitOffsets, Path sinceDbPath, Timestamp targetTimestamp) throws IOException {
        this.queuePath = path;
        this.commitOffsets = commitOffsets;
        this.open = new AtomicBoolean(true);
        this.sinceDbPath = sinceDbPath;
        this.targetTimestamp = targetTimestamp;
        this.readerHasState = new AtomicBoolean(false);
        this.sinceDb = SinceDB.fromPath(sinceDbPath);
    }

    private synchronized DeadLetterQueueReader lazyInitQueueReader() throws IOException {
        if (this.queueReader == null) {
            File queueDir = this.queuePath.toFile();
            if (!queueDir.exists()) {
                logger.warn("DLQ sub-path {} does not exist", (Object)this.queuePath);
                throw new NoSuchFileException("DLQ sub-path " + this.queuePath + " does not exist");
            }
            if (!queueDir.isDirectory()) {
                logger.warn("DLQ sub-path {} is not a directory", (Object)this.queuePath);
                throw new NotDirectoryException("DLQ sub-path " + this.queuePath + " is not a directory");
            }
            this.queueReader = new DeadLetterQueueReader(this.queuePath);
            this.setInitialReaderState(this.queueReader);
        }
        return this.queueReader;
    }

    public void register() throws IOException {
        if (this.queuePath.toFile().isDirectory()) {
            this.lazyInitQueueReader();
        }
    }

    private void setInitialReaderState(DeadLetterQueueReader queueReader) throws IOException {
        if (this.sinceDbPath != null && Files.exists(this.sinceDbPath, new LinkOption[0]) && this.targetTimestamp == null) {
            this.sinceDb = SinceDB.fromPath(this.sinceDbPath);
            if (!this.sinceDb.isAssigned()) {
                return;
            }
            queueReader.setCurrentReaderAndPosition(this.sinceDb.getCurrentSegment(), this.sinceDb.getOffset());
            this.readerHasState.set(true);
        } else if (this.targetTimestamp != null) {
            queueReader.seekToNextEvent(this.targetTimestamp);
            this.readerHasState.set(false);
        }
    }

    public void run(Consumer<Queueable> queueConsumer) throws IOException, InterruptedException {
        DeadLetterQueueReader queueReader = this.lazyInitQueueReader();
        while (this.open.get()) {
            DLQEntry entry = queueReader.pollEntry(100L);
            if (entry == null) continue;
            this.readerHasState.set(true);
            queueConsumer.accept((Queueable)entry);
        }
    }

    public void close() {
        this.open.set(false);
        DeadLetterQueueReader queueReader = this.queueReader;
        if (queueReader != null && this.commitOffsets && this.readerHasState.get()) {
            logger.debug("retrieving current DLQ segment and position");
            this.sinceDb = SinceDB.getUpdated(this.sinceDb, queueReader);
        }
        try {
            logger.debug("closing DLQ reader");
            if (queueReader != null) {
                queueReader.close();
            }
        }
        catch (Exception e) {
            logger.warn("error closing DLQ reader", (Throwable)e);
        }
        finally {
            this.sinceDb.flush();
        }
    }
}

