/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.QueueFactoryExt;
import org.logstash.ackedqueue.ext.JRubyAckedQueueExt;
import org.logstash.ackedqueue.ext.JRubyWrappedAckedQueueExt;
import org.logstash.common.DeadLetterQueueFactory;
import org.logstash.common.EnvironmentVariableProvider;
import org.logstash.common.SourceWithMetadata;
import org.logstash.common.io.QueueStorageType;
import org.logstash.config.ir.ConfigCompiler;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.PipelineConfig;
import org.logstash.config.ir.PipelineIR;
import org.logstash.execution.AbstractWrappedQueueExt;
import org.logstash.execution.PipelineReporterExt;
import org.logstash.execution.QueueReadClientBase;
import org.logstash.ext.JRubyAbstractQueueWriteClientExt;
import org.logstash.ext.JRubyWrappedWriteClientExt;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.NullMetricExt;
import org.logstash.plugins.ConfigVariableExpander;
import org.logstash.secret.store.SecretStore;
import org.logstash.secret.store.SecretStoreExt;

@JRubyClass(name={"AbstractPipeline"})
public class AbstractPipelineExt
extends RubyBasicObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(AbstractPipelineExt.class);
    private static final RubyArray CAPACITY_NAMESPACE = RubyArray.newArray((Ruby)RubyUtil.RUBY, (IRubyObject)RubyUtil.RUBY.newSymbol("capacity"));
    private static final RubyArray DATA_NAMESPACE = RubyArray.newArray((Ruby)RubyUtil.RUBY, (IRubyObject)RubyUtil.RUBY.newSymbol("data"));
    private static final RubySymbol PAGE_CAPACITY_IN_BYTES = RubyUtil.RUBY.newSymbol("page_capacity_in_bytes");
    private static final RubySymbol MAX_QUEUE_SIZE_IN_BYTES = RubyUtil.RUBY.newSymbol("max_queue_size_in_bytes");
    private static final RubySymbol MAX_QUEUE_UNREAD_EVENTS = RubyUtil.RUBY.newSymbol("max_unread_events");
    private static final RubySymbol QUEUE_SIZE_IN_BYTES = RubyUtil.RUBY.newSymbol("queue_size_in_bytes");
    private static final RubySymbol FREE_SPACE_IN_BYTES = RubyUtil.RUBY.newSymbol("free_space_in_bytes");
    private static final RubySymbol STORAGE_TYPE = RubyUtil.RUBY.newSymbol("storage_type");
    private static final RubySymbol PATH = RubyUtil.RUBY.newSymbol("path");
    private static final RubySymbol TYPE_KEY = RubyUtil.RUBY.newSymbol("type");
    private static final RubySymbol QUEUE_KEY = RubyUtil.RUBY.newSymbol("queue");
    private static final RubySymbol DLQ_KEY = RubyUtil.RUBY.newSymbol("dlq");
    private static final RubySymbol STORAGE_POLICY = RubyUtil.RUBY.newSymbol("storage_policy");
    private static final RubySymbol DROPPED_EVENTS = RubyUtil.RUBY.newSymbol("dropped_events");
    private static final RubySymbol LAST_ERROR = RubyUtil.RUBY.newSymbol("last_error");
    private static final RubyArray EVENTS_METRIC_NAMESPACE = RubyArray.newArray((Ruby)RubyUtil.RUBY, (IRubyObject[])new IRubyObject[]{MetricKeys.STATS_KEY, MetricKeys.EVENTS_KEY});
    protected PipelineIR lir;
    private final RubyString ephemeralId = RubyUtil.RUBY.newString(UUID.randomUUID().toString());
    private AbstractNamespacedMetricExt dlqMetric;
    private RubyString configString;
    private List<SourceWithMetadata> configParts;
    private RubyString configHash;
    private IRubyObject settings;
    private IRubyObject pipelineSettings;
    private IRubyObject pipelineId;
    private AbstractMetricExt metric;
    private IRubyObject dlqWriter;
    private PipelineReporterExt reporter;
    private AbstractWrappedQueueExt queue;
    private JRubyAbstractQueueWriteClientExt inputQueueClient;
    private QueueReadClientBase filterQueueClient;

    public AbstractPipelineExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    public final AbstractPipelineExt initialize(ThreadContext context, IRubyObject pipelineConfig, IRubyObject namespacedMetric, IRubyObject rubyLogger) throws NoSuchAlgorithmException {
        this.reporter = new PipelineReporterExt(context.runtime, RubyUtil.PIPELINE_REPORTER_CLASS).initialize(context, rubyLogger, (IRubyObject)this);
        this.pipelineSettings = pipelineConfig;
        this.configString = (RubyString)this.pipelineSettings.callMethod(context, "config_string");
        this.configParts = ((PipelineConfig)this.pipelineSettings.toJava(PipelineConfig.class)).getConfigParts();
        this.configHash = context.runtime.newString(Hex.encodeHexString((byte[])MessageDigest.getInstance("SHA1").digest(this.configString.getBytes())));
        this.settings = this.pipelineSettings.callMethod(context, "settings");
        IRubyObject id = this.getSetting(context, "pipeline.id");
        this.pipelineId = id.isNil() ? this.id() : id;
        if (namespacedMetric.isNil()) {
            this.metric = new NullMetricExt(context.runtime, RubyUtil.NULL_METRIC_CLASS).initialize(context, new IRubyObject[0]);
        } else {
            AbstractMetricExt java = (AbstractMetricExt)namespacedMetric;
            this.metric = this.getSetting(context, "metric.collect").isTrue() ? java : new NullMetricExt(context.runtime, RubyUtil.NULL_METRIC_CLASS).initialize(context, new IRubyObject[]{java.collector(context)});
        }
        boolean supportEscapes = this.getSetting(context, "config.support_escapes").isTrue();
        try (ConfigVariableExpander cve = new ConfigVariableExpander(this.getSecretStore(context), EnvironmentVariableProvider.defaultProvider());){
            this.lir = ConfigCompiler.configToPipelineIR(this.configParts, supportEscapes, cve);
        }
        catch (InvalidIRException iirex) {
            throw new IllegalArgumentException(iirex);
        }
        return this;
    }

    @JRubyMethod(name={"open_queue"})
    public final IRubyObject openQueue(ThreadContext context) {
        try {
            this.queue = QueueFactoryExt.create(context, null, this.settings);
        }
        catch (Exception ex) {
            LOGGER.error("Logstash failed to create queue.", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        this.inputQueueClient = this.queue.writeClient(context);
        this.filterQueueClient = this.queue.readClient();
        this.filterQueueClient.setEventsMetric((IRubyObject)this.metric.namespace(context, (IRubyObject)EVENTS_METRIC_NAMESPACE));
        this.filterQueueClient.setPipelineMetric((IRubyObject)this.metric.namespace(context, (IRubyObject)RubyArray.newArray((Ruby)context.runtime, (IRubyObject[])new IRubyObject[]{MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, this.pipelineId.convertToString().intern(), MetricKeys.EVENTS_KEY})));
        return context.nil;
    }

    @JRubyMethod(name={"filter_queue_client"})
    public final QueueReadClientBase filterQueueClient() {
        return this.filterQueueClient;
    }

    @JRubyMethod(name={"config_str"})
    public final RubyString configStr() {
        return this.configString;
    }

    @JRubyMethod(name={"config_hash"})
    public final RubyString configHash() {
        return this.configHash;
    }

    @JRubyMethod(name={"ephemeral_id"})
    public final RubyString ephemeralId() {
        return this.ephemeralId;
    }

    @JRubyMethod
    public final IRubyObject settings() {
        return this.settings;
    }

    @JRubyMethod(name={"pipeline_config"})
    public final IRubyObject pipelineConfig() {
        return this.pipelineSettings;
    }

    @JRubyMethod(name={"pipeline_id"})
    public final IRubyObject pipelineId() {
        return this.pipelineId;
    }

    @JRubyMethod
    public final AbstractMetricExt metric() {
        return this.metric;
    }

    @JRubyMethod
    public final IRubyObject lir(ThreadContext context) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)this.lir);
    }

    @JRubyMethod(name={"dlq_writer"})
    public final IRubyObject dlqWriter(ThreadContext context) {
        if (this.dlqWriter == null) {
            if (this.dlqEnabled(context).isTrue()) {
                QueueStorageType storageType = QueueStorageType.parse(this.getSetting(context, "dead_letter_queue.storage_policy").asJavaString());
                this.dlqWriter = JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)DeadLetterQueueFactory.getWriter(this.pipelineId.asJavaString(), this.getSetting(context, "path.dead_letter_queue").asJavaString(), this.getSetting(context, "dead_letter_queue.max_bytes").convertToInteger().getLongValue(), Duration.ofMillis(this.getSetting(context, "dead_letter_queue.flush_interval").convertToInteger().getLongValue()), storageType));
            } else {
                this.dlqWriter = RubyUtil.DUMMY_DLQ_WRITER_CLASS.callMethod(context, "new");
            }
        }
        return this.dlqWriter;
    }

    @JRubyMethod(name={"dlq_enabled?"})
    public final IRubyObject dlqEnabled(ThreadContext context) {
        return this.getSetting(context, "dead_letter_queue.enable");
    }

    @JRubyMethod(name={"close_dlq_writer"})
    public final IRubyObject closeDlqWriter(ThreadContext context) {
        this.dlqWriter.callMethod(context, "close");
        if (this.dlqEnabled(context).isTrue()) {
            DeadLetterQueueFactory.release(this.pipelineId.asJavaString());
        }
        return context.nil;
    }

    @JRubyMethod
    public final PipelineReporterExt reporter() {
        return this.reporter;
    }

    @JRubyMethod(name={"collect_dlq_stats"})
    public final IRubyObject collectDlqStats(ThreadContext context) {
        if (this.dlqEnabled(context).isTrue()) {
            this.getDlqMetric(context).gauge(context, (IRubyObject)QUEUE_SIZE_IN_BYTES, this.dlqWriter(context).callMethod(context, "get_current_queue_size"));
            this.getDlqMetric(context).gauge(context, (IRubyObject)STORAGE_POLICY, this.dlqWriter(context).callMethod(context, "get_storage_policy"));
            this.getDlqMetric(context).gauge(context, (IRubyObject)MAX_QUEUE_SIZE_IN_BYTES, (IRubyObject)this.getSetting(context, "dead_letter_queue.max_bytes").convertToInteger());
            this.getDlqMetric(context).gauge(context, (IRubyObject)DROPPED_EVENTS, this.dlqWriter(context).callMethod(context, "get_dropped_events"));
            this.getDlqMetric(context).gauge(context, (IRubyObject)LAST_ERROR, this.dlqWriter(context).callMethod(context, "get_last_error"));
        }
        return context.nil;
    }

    @JRubyMethod(name={"system?"})
    public final IRubyObject isSystem(ThreadContext context) {
        return this.getSetting(context, "pipeline.system");
    }

    @JRubyMethod(name={"configured_as_reloadable?"})
    public final IRubyObject isConfiguredReloadable(ThreadContext context) {
        return this.getSetting(context, "pipeline.reloadable");
    }

    @JRubyMethod(name={"collect_stats"})
    public final IRubyObject collectStats(ThreadContext context) throws IOException {
        AbstractNamespacedMetricExt pipelineMetric = this.metric.namespace(context, (IRubyObject)RubyArray.newArray((Ruby)context.runtime, Arrays.asList(MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, this.pipelineId.asString().intern(), QUEUE_KEY)));
        pipelineMetric.gauge(context, (IRubyObject)TYPE_KEY, this.getSetting(context, "queue.type"));
        if (this.queue instanceof JRubyWrappedAckedQueueExt) {
            JRubyAckedQueueExt inner = ((JRubyWrappedAckedQueueExt)this.queue).rubyGetQueue();
            RubyString dirPath = inner.ruby_dir_path(context);
            AbstractNamespacedMetricExt capacityMetrics = pipelineMetric.namespace(context, (IRubyObject)CAPACITY_NAMESPACE);
            capacityMetrics.gauge(context, (IRubyObject)PAGE_CAPACITY_IN_BYTES, inner.ruby_page_capacity(context));
            capacityMetrics.gauge(context, (IRubyObject)MAX_QUEUE_SIZE_IN_BYTES, inner.ruby_max_size_in_bytes(context));
            capacityMetrics.gauge(context, (IRubyObject)MAX_QUEUE_UNREAD_EVENTS, inner.ruby_max_unread_events(context));
            capacityMetrics.gauge(context, (IRubyObject)QUEUE_SIZE_IN_BYTES, inner.ruby_persisted_size_in_bytes(context));
            AbstractNamespacedMetricExt dataMetrics = pipelineMetric.namespace(context, (IRubyObject)DATA_NAMESPACE);
            FileStore fileStore = Files.getFileStore(Paths.get(dirPath.asJavaString(), new String[0]));
            dataMetrics.gauge(context, (IRubyObject)FREE_SPACE_IN_BYTES, (IRubyObject)context.runtime.newFixnum(fileStore.getUnallocatedSpace()));
            dataMetrics.gauge(context, (IRubyObject)STORAGE_TYPE, (IRubyObject)context.runtime.newString(fileStore.type()));
            dataMetrics.gauge(context, (IRubyObject)PATH, (IRubyObject)dirPath);
            pipelineMetric.gauge(context, (IRubyObject)MetricKeys.EVENTS_KEY, inner.ruby_unread_count(context));
        }
        return context.nil;
    }

    @JRubyMethod(name={"input_queue_client"})
    public final JRubyAbstractQueueWriteClientExt inputQueueClient() {
        return this.inputQueueClient;
    }

    @JRubyMethod
    public final AbstractWrappedQueueExt queue() {
        return this.queue;
    }

    @JRubyMethod
    public final IRubyObject close(ThreadContext context) throws IOException {
        this.filterQueueClient.close();
        this.queue.close(context);
        this.closeDlqWriter(context);
        return context.nil;
    }

    @JRubyMethod(name={"wrapped_write_client"}, visibility=Visibility.PROTECTED)
    public final JRubyWrappedWriteClientExt wrappedWriteClient(ThreadContext context, IRubyObject pluginId) {
        return new JRubyWrappedWriteClientExt(context.runtime, RubyUtil.WRAPPED_WRITE_CLIENT_CLASS).initialize(this.inputQueueClient, this.pipelineId.asJavaString(), this.metric, pluginId);
    }

    @JRubyMethod(name={"pipeline_source_details"}, visibility=Visibility.PROTECTED)
    public RubyArray getPipelineSourceDetails(ThreadContext context) {
        ArrayList<RubyString> pipelineSources = new ArrayList<RubyString>(this.configParts.size());
        for (SourceWithMetadata sourceWithMetadata : this.configParts) {
            String protocol;
            switch (protocol = sourceWithMetadata.getProtocol()) {
                case "string": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)"config string"));
                    break;
                }
                case "file": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)sourceWithMetadata.getId()));
                    break;
                }
                case "x-pack-metrics": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)"monitoring pipeline"));
                    break;
                }
                case "x-pack-config-management": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)"central pipeline management"));
                    break;
                }
                case "module": {
                    pipelineSources.add(RubyString.newString((Ruby)context.runtime, (String)"module"));
                }
            }
        }
        return RubyArray.newArray((Ruby)context.runtime, pipelineSources);
    }

    protected final IRubyObject getSetting(ThreadContext context, String name) {
        return this.settings.callMethod(context, "get_value", (IRubyObject)context.runtime.newString(name));
    }

    protected final boolean hasSetting(ThreadContext context, String name) {
        return this.settings.callMethod(context, "registered?", (IRubyObject)context.runtime.newString(name)) == context.tru;
    }

    protected SecretStore getSecretStore(ThreadContext context) {
        String keystoreFile = this.hasSetting(context, "keystore.file") ? this.getSetting(context, "keystore.file").asJavaString() : null;
        String keystoreClassname = this.hasSetting(context, "keystore.classname") ? this.getSetting(context, "keystore.classname").asJavaString() : null;
        return keystoreFile != null && keystoreClassname != null ? SecretStoreExt.getIfExists(keystoreFile, keystoreClassname) : null;
    }

    private AbstractNamespacedMetricExt getDlqMetric(ThreadContext context) {
        if (this.dlqMetric == null) {
            this.dlqMetric = this.metric.namespace(context, (IRubyObject)RubyArray.newArray((Ruby)context.runtime, Arrays.asList(MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, this.pipelineId.asString().intern(), DLQ_KEY)));
        }
        return this.dlqMetric;
    }
}

