/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.snmp4j.log.JavaLogAdapter;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;

public class JavaLogFactory
extends LogFactory {
    @Override
    protected LogAdapter createLogger(Class c) {
        return new JavaLogAdapter(Logger.getLogger(c.getName()));
    }

    @Override
    protected LogAdapter createLogger(String className) {
        return new JavaLogAdapter(Logger.getLogger(className));
    }

    @Override
    public LogAdapter getRootLogger() {
        return new JavaLogAdapter(Logger.getLogger(""));
    }

    @Override
    public Iterator loggers() {
        Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
        return new JavaLogAdapterIterator(loggerNames);
    }

    public class JavaLogAdapterIterator
    implements Iterator {
        private Enumeration<String> loggerNames;

        protected JavaLogAdapterIterator(Enumeration<String> loggerNames) {
            this.loggerNames = loggerNames;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean hasNext() {
            return this.loggerNames.hasMoreElements();
        }

        public Object next() {
            String loggerName = this.loggerNames.nextElement();
            Logger logger = Logger.getLogger(loggerName);
            return new JavaLogAdapter(logger);
        }
    }
}

