/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public class TransformMetadata
implements Metadata.Custom {
    public static final String TYPE = "transform";
    public static final ParseField RESET_MODE = new ParseField("reset_mode", new String[0]);
    public static final TransformMetadata EMPTY_METADATA = new TransformMetadata(false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = new ObjectParser("transform_metadata", true, Builder::new);
    private final boolean resetMode;

    private TransformMetadata(boolean resetMode) {
        this.resetMode = resetMode;
    }

    public boolean isResetMode() {
        return this.resetMode;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new TransformMetadataDiff((TransformMetadata)previousState, this);
    }

    public TransformMetadata(StreamInput in) throws IOException {
        this.resetMode = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.resetMode);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return ChunkedToXContentHelper.field(RESET_MODE.getPreferredName(), this.resetMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformMetadata that = (TransformMetadata)o;
        return this.resetMode == that.resetMode;
    }

    public final String toString() {
        return Strings.toString(this);
    }

    public int hashCode() {
        return Objects.hash(this.resetMode);
    }

    public static TransformMetadata getTransformMetadata(ClusterState state) {
        TransformMetadata TransformMetadata2;
        TransformMetadata transformMetadata = TransformMetadata2 = state == null ? null : (TransformMetadata)state.getMetadata().custom(TYPE);
        if (TransformMetadata2 == null) {
            return EMPTY_METADATA;
        }
        return TransformMetadata2;
    }

    static {
        LENIENT_PARSER.declareBoolean(Builder::isResetMode, RESET_MODE);
    }

    public static class TransformMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final boolean resetMode;

        TransformMetadataDiff(TransformMetadata before, TransformMetadata after) {
            this.resetMode = after.resetMode;
        }

        public TransformMetadataDiff(StreamInput in) throws IOException {
            this.resetMode = in.readBoolean();
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new TransformMetadata(this.resetMode);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.resetMode);
        }

        @Override
        public String getWriteableName() {
            return TransformMetadata.TYPE;
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.MINIMUM_COMPATIBLE;
        }
    }

    public static class Builder {
        private boolean resetMode;

        public static Builder from(@Nullable TransformMetadata previous) {
            return new Builder(previous);
        }

        public Builder() {
        }

        public Builder(@Nullable TransformMetadata previous) {
            if (previous != null) {
                this.resetMode = previous.resetMode;
            }
        }

        public Builder isResetMode(boolean isResetMode) {
            this.resetMode = isResetMode;
            return this;
        }

        public TransformMetadata build() {
            return new TransformMetadata(this.resetMode);
        }
    }
}

