/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;

public final class RoleMappingMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "role_mappings";
    private static final ConstructingObjectParser<RoleMappingMetadata, Void> PARSER = new ConstructingObjectParser("role_mappings", args -> new RoleMappingMetadata(new LinkedHashSet<ExpressionRoleMapping>((Collection)args[0])));
    private static final RoleMappingMetadata EMPTY;
    private final Set<ExpressionRoleMapping> roleMappings;

    public static RoleMappingMetadata getFromClusterState(ClusterState clusterState) {
        return clusterState.metadata().custom(TYPE, EMPTY);
    }

    public RoleMappingMetadata(Set<ExpressionRoleMapping> roleMappings) {
        this.roleMappings = roleMappings;
    }

    public RoleMappingMetadata(StreamInput input) throws IOException {
        this.roleMappings = input.readCollectionAsSet(ExpressionRoleMapping::new);
    }

    public Set<ExpressionRoleMapping> getRoleMappings() {
        return this.roleMappings;
    }

    public boolean isEmpty() {
        return this.roleMappings.isEmpty();
    }

    public ClusterState updateClusterState(ClusterState clusterState) {
        if (this.isEmpty()) {
            return clusterState.copyAndUpdateMetadata(b -> b.removeCustom(TYPE));
        }
        return clusterState.copyAndUpdateMetadata(b -> b.putCustom(TYPE, this));
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput streamInput) throws IOException {
        return RoleMappingMetadata.readDiffFrom(Metadata.Custom.class, TYPE, streamInput);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.startArray(TYPE), this.roleMappings.iterator(), ChunkedToXContentHelper.endArray());
    }

    public static RoleMappingMetadata fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.SECURITY_ROLE_MAPPINGS_IN_CLUSTER_STATE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.roleMappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleMappingMetadata other = (RoleMappingMetadata)o;
        return Objects.equals(this.roleMappings, other.roleMappings);
    }

    public int hashCode() {
        return Objects.hash(this.roleMappings);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RoleMapping[entries=[");
        Iterator<ExpressionRoleMapping> entryList = this.roleMappings.iterator();
        boolean firstEntry = true;
        while (entryList.hasNext()) {
            if (!firstEntry) {
                builder.append(",");
            }
            builder.append(entryList.next().toString());
            firstEntry = false;
        }
        return builder.append("]]").toString();
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ExpressionRoleMapping.parse("name_not_available_after_deserialization", p), new ParseField(TYPE, new String[0]));
        EMPTY = new RoleMappingMetadata(Set.of());
    }
}

