/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

public class RealmConfig {
    final RealmIdentifier identifier;
    final boolean enabled;
    final int order;
    private final Environment env;
    private final Settings settings;
    private final ThreadContext threadContext;
    public static ConstructingObjectParser<RealmIdentifier, Void> REALM_IDENTIFIER_PARSER = new ConstructingObjectParser<RealmIdentifier, Void>("realm_identifier", false, (args, v) -> new RealmIdentifier((String)args[0], (String)args[1]));

    public RealmConfig(RealmIdentifier identifier, Settings settings, Environment env, ThreadContext threadContext) {
        this.identifier = identifier;
        this.settings = settings;
        this.env = env;
        this.threadContext = threadContext;
        this.enabled = (Boolean)this.getSetting(RealmSettings.ENABLED_SETTING);
        if (this.enabled && !this.hasSetting(RealmSettings.ORDER_SETTING.apply(this.type()))) {
            throw new IllegalArgumentException("'order' is a mandatory parameter for realm config. Found invalid config for realm: '" + identifier.name + "'\nPlease see the breaking changes documentation.");
        }
        this.order = (Integer)this.getSetting(RealmSettings.ORDER_SETTING);
    }

    public RealmIdentifier identifier() {
        return this.identifier;
    }

    public String name() {
        return this.identifier.name;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public int order() {
        return this.order;
    }

    public String type() {
        return this.identifier.type;
    }

    public Settings settings() {
        return this.settings;
    }

    public Environment env() {
        return this.env;
    }

    public ThreadContext threadContext() {
        return this.threadContext;
    }

    public <T> Setting<T> getConcreteSetting(Setting.AffixSetting<T> setting) {
        return setting.getConcreteSettingForNamespace(this.name());
    }

    public <T> Setting<T> getConcreteSetting(Function<String, Setting.AffixSetting<T>> settingFactory) {
        return this.getConcreteSetting(settingFactory.apply(this.type()));
    }

    public <T> T getSetting(Setting.AffixSetting<T> setting) {
        return this.getConcreteSetting(setting).get(this.settings);
    }

    public <T> T getSetting(Function<String, Setting.AffixSetting<T>> settingFactory) {
        return this.getSetting(settingFactory.apply(this.type()));
    }

    public <T> T getSetting(Function<String, Setting.AffixSetting<T>> settingFactory, Supplier<T> orElse) {
        return this.getSetting(settingFactory.apply(this.type()), orElse);
    }

    public <T> T getSetting(Setting.AffixSetting<T> setting, Supplier<T> orElse) {
        Setting<T> concrete = setting.getConcreteSettingForNamespace(this.name());
        if (concrete.exists(this.settings)) {
            return concrete.get(this.settings);
        }
        return orElse.get();
    }

    public <T> boolean hasSetting(Function<String, Setting.AffixSetting<T>> settingFactory) {
        return this.getConcreteSetting(settingFactory).exists(this.settings);
    }

    public <T> boolean hasSetting(Setting.AffixSetting<T> setting) {
        return this.getConcreteSetting(setting).exists(this.settings);
    }

    static {
        REALM_IDENTIFIER_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        REALM_IDENTIFIER_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
    }

    public static class RealmIdentifier
    implements Writeable,
    ToXContentObject,
    Comparable<RealmIdentifier> {
        private final String type;
        private final String name;

        public RealmIdentifier(String type, String name) {
            this.type = Objects.requireNonNull(type, "Realm type cannot be null");
            this.name = Objects.requireNonNull(name, "Realm name cannot be null");
        }

        public RealmIdentifier(StreamInput in) throws IOException {
            this.type = in.readString();
            this.name = in.readString();
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            RealmIdentifier other = (RealmIdentifier)o;
            return Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.name);
        }

        public String toString() {
            return this.type + "/" + this.name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeString(this.name);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.name);
            builder.field("type", this.type);
            builder.endObject();
            return builder;
        }

        @Override
        public int compareTo(RealmIdentifier other) {
            int result = this.name.compareTo(other.name);
            return result == 0 ? this.type.compareTo(other.type) : result;
        }
    }
}

