/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissions;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;

public final class GetUserPrivilegesResponse
extends ActionResponse {
    private final Set<String> cluster;
    private final Set<ConfigurableClusterPrivilege> configurableClusterPrivileges;
    private final Set<Indices> index;
    private final Set<RoleDescriptor.ApplicationResourcePrivileges> application;
    private final Set<String> runAs;
    private final Set<RemoteIndices> remoteIndex;
    private final RemoteClusterPermissions remoteClusterPermissions;

    public GetUserPrivilegesResponse(StreamInput in) throws IOException {
        super(in);
        this.cluster = in.readCollectionAsImmutableSet(StreamInput::readString);
        this.configurableClusterPrivileges = in.readCollectionAsImmutableSet(ConfigurableClusterPrivileges.READER);
        this.index = in.readCollectionAsImmutableSet(Indices::new);
        this.application = in.readCollectionAsImmutableSet(RoleDescriptor.ApplicationResourcePrivileges::new);
        this.runAs = in.readCollectionAsImmutableSet(StreamInput::readString);
        this.remoteIndex = in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? in.readCollectionAsImmutableSet(RemoteIndices::new) : Set.of();
        this.remoteClusterPermissions = in.getTransportVersion().onOrAfter(TransportVersions.ROLE_REMOTE_CLUSTER_PRIVS) ? new RemoteClusterPermissions(in) : RemoteClusterPermissions.NONE;
    }

    public GetUserPrivilegesResponse(Set<String> cluster, Set<ConfigurableClusterPrivilege> conditionalCluster, Set<Indices> index, Set<RoleDescriptor.ApplicationResourcePrivileges> application, Set<String> runAs, Set<RemoteIndices> remoteIndex, RemoteClusterPermissions remoteClusterPermissions) {
        this.cluster = Collections.unmodifiableSet(cluster);
        this.configurableClusterPrivileges = Collections.unmodifiableSet(conditionalCluster);
        this.index = Collections.unmodifiableSet(index);
        this.application = Collections.unmodifiableSet(application);
        this.runAs = Collections.unmodifiableSet(runAs);
        this.remoteIndex = Collections.unmodifiableSet(remoteIndex);
        this.remoteClusterPermissions = remoteClusterPermissions;
    }

    public Set<String> getClusterPrivileges() {
        return this.cluster;
    }

    public Set<ConfigurableClusterPrivilege> getConditionalClusterPrivileges() {
        return this.configurableClusterPrivileges;
    }

    public Set<Indices> getIndexPrivileges() {
        return this.index;
    }

    public Set<RemoteIndices> getRemoteIndexPrivileges() {
        return this.remoteIndex;
    }

    public RemoteClusterPermissions getRemoteClusterPermissions() {
        return this.remoteClusterPermissions;
    }

    public Set<RoleDescriptor.ApplicationResourcePrivileges> getApplicationPrivileges() {
        return this.application;
    }

    public Set<String> getRunAs() {
        return this.runAs;
    }

    public boolean hasRemoteIndicesPrivileges() {
        return false == this.remoteIndex.isEmpty();
    }

    public boolean hasRemoteClusterPrivileges() {
        return this.remoteClusterPermissions.hasPrivileges();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.cluster);
        out.writeCollection(this.configurableClusterPrivileges, ConfigurableClusterPrivileges.WRITER);
        out.writeCollection(this.index);
        out.writeCollection(this.application);
        out.writeStringCollection(this.runAs);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeCollection(this.remoteIndex);
        } else if (this.hasRemoteIndicesPrivileges()) {
            throw new IllegalArgumentException("versions of Elasticsearch before [" + TransportVersions.V_8_8_0.toReleaseVersion() + "] can't handle remote indices privileges and attempted to send to [" + out.getTransportVersion().toReleaseVersion() + "]");
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.ROLE_REMOTE_CLUSTER_PRIVS)) {
            this.remoteClusterPermissions.writeTo(out);
        } else if (this.hasRemoteClusterPrivileges()) {
            throw new IllegalArgumentException("versions of Elasticsearch before [" + TransportVersions.ROLE_REMOTE_CLUSTER_PRIVS + "] can't handle remote cluster privileges and attempted to send to [" + out.getTransportVersion() + "]");
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetUserPrivilegesResponse that = (GetUserPrivilegesResponse)other;
        return Objects.equals(this.cluster, that.cluster) && Objects.equals(this.configurableClusterPrivileges, that.configurableClusterPrivileges) && Objects.equals(this.index, that.index) && Objects.equals(this.application, that.application) && Objects.equals(this.runAs, that.runAs) && Objects.equals(this.remoteIndex, that.remoteIndex) && Objects.equals(this.remoteClusterPermissions, that.remoteClusterPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.configurableClusterPrivileges, this.index, this.application, this.runAs, this.remoteIndex, this.remoteClusterPermissions);
    }

    public static class Indices
    implements ToXContentObject,
    Writeable {
        private final Set<String> indices;
        private final Set<String> privileges;
        private final Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> fieldSecurity;
        private final Set<BytesReference> queries;
        private final boolean allowRestrictedIndices;

        public Indices(Collection<String> indices, Collection<String> privileges, Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> fieldSecurity, Set<BytesReference> queries, boolean allowRestrictedIndices) {
            this.indices = Collections.unmodifiableSet(new TreeSet<String>(Objects.requireNonNull(indices)));
            this.privileges = Collections.unmodifiableSet(new TreeSet<String>(Objects.requireNonNull(privileges)));
            this.fieldSecurity = Collections.unmodifiableSet(Objects.requireNonNull(fieldSecurity));
            this.queries = Collections.unmodifiableSet(Objects.requireNonNull(queries));
            this.allowRestrictedIndices = allowRestrictedIndices;
        }

        public Indices(StreamInput in) throws IOException {
            this.indices = Collections.unmodifiableSet(new TreeSet<String>(in.readCollectionAsSet(StreamInput::readString)));
            this.privileges = Collections.unmodifiableSet(new TreeSet<String>(in.readCollectionAsSet(StreamInput::readString)));
            this.fieldSecurity = in.readCollectionAsImmutableSet(input -> {
                String[] grant = input.readOptionalStringArray();
                String[] exclude = input.readOptionalStringArray();
                return new FieldPermissionsDefinition.FieldGrantExcludeGroup(grant, exclude);
            });
            this.queries = in.readCollectionAsImmutableSet(StreamInput::readBytesReference);
            this.allowRestrictedIndices = in.readBoolean();
        }

        public Set<String> getIndices() {
            return this.indices;
        }

        public Set<String> getPrivileges() {
            return this.privileges;
        }

        public Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> getFieldSecurity() {
            return this.fieldSecurity;
        }

        public Set<BytesReference> getQueries() {
            return this.queries;
        }

        public boolean allowRestrictedIndices() {
            return this.allowRestrictedIndices;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("indices=[").append(Strings.collectionToCommaDelimitedString(this.indices)).append("], allow_restricted_indices=[").append(this.allowRestrictedIndices).append("], privileges=[").append(Strings.collectionToCommaDelimitedString(this.privileges)).append("]");
            if (!this.fieldSecurity.isEmpty()) {
                sb.append(", fls=[").append(Strings.collectionToCommaDelimitedString(this.fieldSecurity)).append("]");
            }
            if (!this.queries.isEmpty()) {
                sb.append(", dls=[").append(this.queries.stream().map(BytesReference::utf8ToString).collect(Collectors.joining(","))).append("]");
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Indices that = (Indices)o;
            return this.indices.equals(that.indices) && this.privileges.equals(that.privileges) && this.fieldSecurity.equals(that.fieldSecurity) && this.queries.equals(that.queries) && this.allowRestrictedIndices == that.allowRestrictedIndices;
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.privileges, this.fieldSecurity, this.queries, this.allowRestrictedIndices);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder);
            return builder.endObject();
        }

        void innerToXContent(XContentBuilder builder) throws IOException {
            builder.field(RoleDescriptor.Fields.NAMES.getPreferredName(), (Collection<String>)this.indices);
            builder.field(RoleDescriptor.Fields.PRIVILEGES.getPreferredName(), (Collection<String>)this.privileges);
            if (this.fieldSecurity.stream().anyMatch(g -> Indices.nonEmpty(g.getGrantedFields()) || Indices.nonEmpty(g.getExcludedFields()))) {
                builder.startArray(RoleDescriptor.Fields.FIELD_PERMISSIONS.getPreferredName());
                List sortedFieldSecurity = this.fieldSecurity.stream().sorted().toList();
                for (FieldPermissionsDefinition.FieldGrantExcludeGroup group : sortedFieldSecurity) {
                    builder.startObject();
                    if (Indices.nonEmpty(group.getGrantedFields())) {
                        builder.array(RoleDescriptor.Fields.GRANT_FIELDS.getPreferredName(), group.getGrantedFields());
                    }
                    if (Indices.nonEmpty(group.getExcludedFields())) {
                        builder.array(RoleDescriptor.Fields.EXCEPT_FIELDS.getPreferredName(), group.getExcludedFields());
                    }
                    builder.endObject();
                }
                builder.endArray();
            }
            if (!this.queries.isEmpty()) {
                builder.startArray(RoleDescriptor.Fields.QUERY.getPreferredName());
                for (BytesReference q : this.queries) {
                    builder.value(q.utf8ToString());
                }
                builder.endArray();
            }
            builder.field(RoleDescriptor.Fields.ALLOW_RESTRICTED_INDICES.getPreferredName(), this.allowRestrictedIndices);
        }

        private static boolean nonEmpty(String[] grantedFields) {
            return grantedFields != null && grantedFields.length != 0;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.indices);
            out.writeStringCollection(this.privileges);
            out.writeCollection(this.fieldSecurity, (output, fields) -> {
                output.writeOptionalStringArray(fields.getGrantedFields());
                output.writeOptionalStringArray(fields.getExcludedFields());
            });
            out.writeCollection(this.queries, StreamOutput::writeBytesReference);
            out.writeBoolean(this.allowRestrictedIndices);
        }
    }

    public record RemoteIndices(Indices indices, Set<String> remoteClusters) implements ToXContentObject,
    Writeable
    {
        public RemoteIndices(StreamInput in) throws IOException {
            this(new Indices(in), Collections.unmodifiableSet(new TreeSet<String>(in.readCollectionAsSet(StreamInput::readString))));
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.indices.innerToXContent(builder);
            builder.field(RoleDescriptor.Fields.CLUSTERS.getPreferredName(), (Collection<String>)this.remoteClusters);
            return builder.endObject();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.indices.writeTo(out);
            out.writeStringCollection(this.remoteClusters);
        }
    }
}

