/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.settings;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class UpdateSecuritySettingsAction {
    public static final ActionType<AcknowledgedResponse> INSTANCE = new ActionType("cluster:admin/xpack/security/settings/update");
    public static final String MAIN_INDEX_NAME = "security";
    public static final String TOKENS_INDEX_NAME = "security-tokens";
    public static final String PROFILES_INDEX_NAME = "security-profile";
    public static final Set<String> ALLOWED_SETTING_KEYS = Set.of("index.number_of_replicas", "index.auto_expand_replicas");

    private UpdateSecuritySettingsAction() {
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final Map<String, Object> mainIndexSettings;
        private final Map<String, Object> tokensIndexSettings;
        private final Map<String, Object> profilesIndexSettings;
        private static final ConstructingObjectParser<Request, Factory> PARSER = new ConstructingObjectParser<Request, Factory>("update_security_settings_request", false, (a, factory) -> factory.create((Map)a[0], (Map)a[1], (Map)a[2]));

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, Map<String, Object> mainIndexSettings, Map<String, Object> tokensIndexSettings, Map<String, Object> profilesIndexSettings) {
            super(masterNodeTimeout, ackTimeout);
            this.mainIndexSettings = Objects.requireNonNullElse(mainIndexSettings, Collections.emptyMap());
            this.tokensIndexSettings = Objects.requireNonNullElse(tokensIndexSettings, Collections.emptyMap());
            this.profilesIndexSettings = Objects.requireNonNullElse(profilesIndexSettings, Collections.emptyMap());
        }

        public static Request readFrom(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter(TransportVersions.SECURITY_SETTINGS_REQUEST_TIMEOUTS)) {
                return new Request(in);
            }
            return new Request(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS, in);
        }

        private Request(StreamInput in) throws IOException {
            super(in);
            this.mainIndexSettings = in.readGenericMap();
            this.tokensIndexSettings = in.readGenericMap();
            this.profilesIndexSettings = in.readGenericMap();
        }

        private Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, StreamInput in) throws IOException {
            super(masterNodeTimeout, ackTimeout);
            this.mainIndexSettings = in.readGenericMap();
            this.tokensIndexSettings = in.readGenericMap();
            this.profilesIndexSettings = in.readGenericMap();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.SECURITY_SETTINGS_REQUEST_TIMEOUTS)) {
                super.writeTo(out);
            }
            out.writeGenericMap(this.mainIndexSettings);
            out.writeGenericMap(this.tokensIndexSettings);
            out.writeGenericMap(this.profilesIndexSettings);
        }

        public static Request parse(XContentParser parser, Factory factory) {
            return PARSER.apply(parser, factory);
        }

        public Map<String, Object> mainIndexSettings() {
            return this.mainIndexSettings;
        }

        public Map<String, Object> tokensIndexSettings() {
            return this.tokensIndexSettings;
        }

        public Map<String, Object> profilesIndexSettings() {
            return this.profilesIndexSettings;
        }

        @Override
        public ActionRequestValidationException validate() {
            if (this.mainIndexSettings.isEmpty() && this.tokensIndexSettings.isEmpty() && this.profilesIndexSettings.isEmpty()) {
                return ValidateActions.addValidationError("No settings given to update", null);
            }
            ActionRequestValidationException validationException = Request.validateIndexSettings(this.mainIndexSettings, UpdateSecuritySettingsAction.MAIN_INDEX_NAME, null);
            validationException = Request.validateIndexSettings(this.tokensIndexSettings, UpdateSecuritySettingsAction.TOKENS_INDEX_NAME, validationException);
            validationException = Request.validateIndexSettings(this.profilesIndexSettings, UpdateSecuritySettingsAction.PROFILES_INDEX_NAME, validationException);
            return validationException;
        }

        private static ActionRequestValidationException validateIndexSettings(Map<String, Object> indexSettings, String indexName, ActionRequestValidationException existingExceptions) {
            Set<String> forbiddenSettings = Sets.difference(indexSettings.keySet(), ALLOWED_SETTING_KEYS);
            if (forbiddenSettings.size() > 0) {
                return ValidateActions.addValidationError("illegal settings for index [" + indexName + "]: " + forbiddenSettings + ", these settings may not be configured. Only the following settings may be configured for that index: " + ALLOWED_SETTING_KEYS, existingExceptions);
            }
            return existingExceptions;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.MAIN_INDEX_NAME, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.TOKENS_INDEX_NAME, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.PROFILES_INDEX_NAME, new String[0]));
        }

        public static interface Factory {
            public Request create(Map<String, Object> var1, Map<String, Object> var2, Map<String, Object> var3);
        }
    }
}

