/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.search.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class SubmitAsyncSearchRequest
extends ActionRequest {
    public static long MIN_KEEP_ALIVE = TimeValue.timeValueSeconds(1L).millis();
    private TimeValue waitForCompletionTimeout = TimeValue.timeValueSeconds(1L);
    private boolean keepOnCompletion = false;
    private TimeValue keepAlive = TimeValue.timeValueDays(5L);
    private final SearchRequest request;

    public SubmitAsyncSearchRequest(String ... indices) {
        this(new SearchSourceBuilder(), indices);
    }

    public SubmitAsyncSearchRequest(SearchSourceBuilder source, String ... indices) {
        this.request = new SearchRequest(indices, source);
        this.request.setCcsMinimizeRoundtrips(false);
        this.request.setPreFilterShardSize(1);
        this.request.setBatchedReduceSize(5);
        this.request.requestCache(true);
    }

    public SubmitAsyncSearchRequest(StreamInput in) throws IOException {
        this.request = new SearchRequest(in);
        this.waitForCompletionTimeout = in.readTimeValue();
        this.keepAlive = in.readTimeValue();
        this.keepOnCompletion = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.request.writeTo(out);
        out.writeTimeValue(this.waitForCompletionTimeout);
        out.writeTimeValue(this.keepAlive);
        out.writeBoolean(this.keepOnCompletion);
    }

    public SubmitAsyncSearchRequest setBatchedReduceSize(int size) {
        this.request.setBatchedReduceSize(size);
        return this;
    }

    public int getBatchReduceSize() {
        return this.request.getBatchedReduceSize();
    }

    public boolean isCcsMinimizeRoundtrips() {
        return this.request.isCcsMinimizeRoundtrips();
    }

    public void setCcsMinimizeRoundtrips(boolean ccsMinimizeRoundtrips) {
        this.request.setCcsMinimizeRoundtrips(ccsMinimizeRoundtrips);
    }

    public SubmitAsyncSearchRequest setWaitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        return this;
    }

    public TimeValue getWaitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public SubmitAsyncSearchRequest setKeepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public SearchRequest getSearchRequest() {
        return this.request;
    }

    public SubmitAsyncSearchRequest setKeepOnCompletion(boolean value) {
        this.keepOnCompletion = value;
        return this;
    }

    public boolean isKeepOnCompletion() {
        return this.keepOnCompletion;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = this.request.validate();
        if (this.request.scroll() != null) {
            validationException = ValidateActions.addValidationError("[scroll] queries are not supported", validationException);
        }
        if (this.request.isSuggestOnly()) {
            validationException = ValidateActions.addValidationError("suggest-only queries are not supported", validationException);
        }
        if (this.keepAlive.getMillis() < MIN_KEEP_ALIVE) {
            validationException = ValidateActions.addValidationError("[keep_alive] must be greater or equals than 1 second, got:" + this.keepAlive.toString(), validationException);
        }
        if (this.request.getPreFilterShardSize() == null || this.request.getPreFilterShardSize() != 1) {
            validationException = ValidateActions.addValidationError("[pre_filter_shard_size] cannot be changed for async search queries", validationException);
        }
        return validationException;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, null, parentTaskId, headers){

            @Override
            public String getDescription() {
                return "waitForCompletionTimeout[" + SubmitAsyncSearchRequest.this.waitForCompletionTimeout + "], keepOnCompletion[" + SubmitAsyncSearchRequest.this.keepOnCompletion + "] keepAlive[" + SubmitAsyncSearchRequest.this.keepAlive + "], request=" + SubmitAsyncSearchRequest.this.request.buildDescription();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitAsyncSearchRequest request1 = (SubmitAsyncSearchRequest)o;
        return this.keepOnCompletion == request1.keepOnCompletion && this.waitForCompletionTimeout.equals(request1.waitForCompletionTimeout) && this.keepAlive.equals(request1.keepAlive) && this.request.equals(request1.request);
    }

    public int hashCode() {
        return Objects.hash(this.waitForCompletionTimeout, this.keepOnCompletion, this.keepAlive, this.request);
    }
}

