/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class RollupFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final int numberOfRollupJobs;

    public RollupFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.numberOfRollupJobs = input.getTransportVersion().onOrAfter(TransportVersions.ROLLUP_USAGE) ? input.readVInt() : 0;
    }

    public RollupFeatureSetUsage(int numberOfRollupJobs) {
        super("rollup", true, true);
        this.numberOfRollupJobs = numberOfRollupJobs;
    }

    public int getNumberOfRollupJobs() {
        return this.numberOfRollupJobs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.ROLLUP_USAGE)) {
            out.writeVInt(this.numberOfRollupJobs);
        }
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("number_of_rollup_jobs", this.numberOfRollupJobs);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_0_0;
    }
}

