/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class BucketInfluencer
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "bucket_influencer";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("bucket_influencer", new String[0]);
    public static final ParseField INFLUENCER_FIELD_NAME = new ParseField("influencer_field_name", new String[0]);
    public static final ParseField INITIAL_ANOMALY_SCORE = new ParseField("initial_anomaly_score", new String[0]);
    public static final ParseField ANOMALY_SCORE = new ParseField("anomaly_score", new String[0]);
    public static final ParseField RAW_ANOMALY_SCORE = new ParseField("raw_anomaly_score", new String[0]);
    public static final ParseField PROBABILITY = new ParseField("probability", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final String BUCKET_TIME = "bucket_time";
    public static final ConstructingObjectParser<BucketInfluencer, Void> STRICT_PARSER = BucketInfluencer.createParser(false);
    public static final ConstructingObjectParser<BucketInfluencer, Void> LENIENT_PARSER = BucketInfluencer.createParser(true);
    private final String jobId;
    private String influenceField;
    private double initialAnomalyScore;
    private double anomalyScore;
    private double rawAnomalyScore;
    private double probability;
    private boolean isInterim;
    private final Date timestamp;
    private final long bucketSpan;

    private static ConstructingObjectParser<BucketInfluencer, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<BucketInfluencer, Void> parser = new ConstructingObjectParser<BucketInfluencer, Void>(RESULT_TYPE_FIELD.getPreferredName(), ignoreUnknownFields, a -> new BucketInfluencer((String)a[0], (Date)a[1], (Long)a[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        parser.declareString((bucketInfluencer, s) -> {}, Result.RESULT_TYPE);
        parser.declareString(BucketInfluencer::setInfluencerFieldName, INFLUENCER_FIELD_NAME);
        parser.declareDouble(BucketInfluencer::setInitialAnomalyScore, INITIAL_ANOMALY_SCORE);
        parser.declareDouble(BucketInfluencer::setAnomalyScore, ANOMALY_SCORE);
        parser.declareDouble(BucketInfluencer::setRawAnomalyScore, RAW_ANOMALY_SCORE);
        parser.declareDouble(BucketInfluencer::setProbability, PROBABILITY);
        parser.declareBoolean(BucketInfluencer::setIsInterim, Result.IS_INTERIM);
        return parser;
    }

    public BucketInfluencer(String jobId, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        this.bucketSpan = bucketSpan;
    }

    public BucketInfluencer(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.influenceField = in.readOptionalString();
        this.initialAnomalyScore = in.readDouble();
        this.anomalyScore = in.readDouble();
        this.rawAnomalyScore = in.readDouble();
        this.probability = in.readDouble();
        this.isInterim = in.readBoolean();
        this.timestamp = new Date(in.readLong());
        this.bucketSpan = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeOptionalString(this.influenceField);
        out.writeDouble(this.initialAnomalyScore);
        out.writeDouble(this.anomalyScore);
        out.writeDouble(this.rawAnomalyScore);
        out.writeDouble(this.probability);
        out.writeBoolean(this.isInterim);
        out.writeLong(this.timestamp.getTime());
        out.writeLong(this.bucketSpan);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        if (this.influenceField != null) {
            builder.field(INFLUENCER_FIELD_NAME.getPreferredName(), this.influenceField);
        }
        builder.field(INITIAL_ANOMALY_SCORE.getPreferredName(), this.initialAnomalyScore);
        builder.field(ANOMALY_SCORE.getPreferredName(), this.anomalyScore);
        builder.field(RAW_ANOMALY_SCORE.getPreferredName(), this.rawAnomalyScore);
        builder.field(PROBABILITY.getPreferredName(), this.probability);
        builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        return builder;
    }

    public String getId() {
        return this.jobId + "_bucket_influencer_" + this.timestamp.getTime() + "_" + this.bucketSpan + (String)(this.influenceField == null ? "" : "_" + this.influenceField);
    }

    public String getJobId() {
        return this.jobId;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public String getInfluencerFieldName() {
        return this.influenceField;
    }

    public void setInfluencerFieldName(String fieldName) {
        this.influenceField = fieldName;
    }

    public double getInitialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    public void setInitialAnomalyScore(double influenceScore) {
        this.initialAnomalyScore = influenceScore;
    }

    public double getAnomalyScore() {
        return this.anomalyScore;
    }

    public void setAnomalyScore(double score) {
        this.anomalyScore = score;
    }

    public double getRawAnomalyScore() {
        return this.rawAnomalyScore;
    }

    public void setRawAnomalyScore(double score) {
        this.rawAnomalyScore = score;
    }

    public void setIsInterim(boolean isInterim) {
        this.isInterim = isInterim;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.influenceField, this.initialAnomalyScore, this.anomalyScore, this.rawAnomalyScore, this.probability, this.isInterim, this.timestamp, this.jobId, this.bucketSpan);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BucketInfluencer other = (BucketInfluencer)obj;
        return Objects.equals(this.influenceField, other.influenceField) && Double.compare(this.initialAnomalyScore, other.initialAnomalyScore) == 0 && Double.compare(this.anomalyScore, other.anomalyScore) == 0 && Double.compare(this.rawAnomalyScore, other.rawAnomalyScore) == 0 && Double.compare(this.probability, other.probability) == 0 && Objects.equals(this.isInterim, other.isInterim) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.jobId, other.jobId) && this.bucketSpan == other.bucketSpan;
    }
}

