/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateTrainedModelDeploymentAction
extends ActionType<CreateTrainedModelAssignmentAction.Response> {
    public static final UpdateTrainedModelDeploymentAction INSTANCE = new UpdateTrainedModelDeploymentAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/deployment/update";

    public UpdateTrainedModelDeploymentAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/trained_models/deployment/update", Request::new);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        private String deploymentId;
        private int numberOfAllocations;

        public static Request parseRequest(String deploymentId, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (request.getDeploymentId() == null) {
                request.setDeploymentId(deploymentId);
            } else if (!Strings.isNullOrEmpty(deploymentId) && !deploymentId.equals(request.getDeploymentId())) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", StartTrainedModelDeploymentAction.Request.MODEL_ID, request.getDeploymentId(), deploymentId), new Object[0]);
            }
            return request;
        }

        private Request() {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
        }

        public Request(String deploymentId) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.setDeploymentId(deploymentId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.deploymentId = in.readString();
            this.numberOfAllocations = in.readVInt();
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, StartTrainedModelDeploymentAction.Request.MODEL_ID);
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public void setNumberOfAllocations(int numberOfAllocations) {
            this.numberOfAllocations = numberOfAllocations;
        }

        public int getNumberOfAllocations() {
            return this.numberOfAllocations;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.deploymentId);
            out.writeVInt(this.numberOfAllocations);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName(), this.deploymentId);
            builder.field(StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS.getPreferredName(), this.numberOfAllocations);
            builder.endObject();
            return builder;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            if (this.numberOfAllocations < 1) {
                validationException.addValidationError("[" + StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS + "] must be a positive integer");
            }
            return validationException.validationErrors().isEmpty() ? null : validationException;
        }

        public int hashCode() {
            return Objects.hash(this.deploymentId, this.numberOfAllocations);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.deploymentId, other.deploymentId) && this.numberOfAllocations == other.numberOfAllocations;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(Request::setDeploymentId, StartTrainedModelDeploymentAction.Request.MODEL_ID);
            PARSER.declareInt(Request::setNumberOfAllocations, StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS);
            PARSER.declareString((r, val) -> r.ackTimeout(TimeValue.parseTimeValue(val, TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }
}

