/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.core.ml.inference.assignment.Priority;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlTaskParams;

public class StartTrainedModelDeploymentAction
extends ActionType<CreateTrainedModelAssignmentAction.Response> {
    public static final StartTrainedModelDeploymentAction INSTANCE = new StartTrainedModelDeploymentAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/deployment/start";
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);
    private static final ByteSizeValue MEMORY_OVERHEAD = ByteSizeValue.ofMb(240L);
    private static final ByteSizeValue ELSER_1_OR_2_MEMORY_USAGE = ByteSizeValue.ofMb(2004L);
    public static final AllocationStatus.State DEFAULT_WAITFOR_STATE = AllocationStatus.State.STARTED;
    public static final int DEFAULT_NUM_ALLOCATIONS = 1;
    public static final int DEFAULT_NUM_THREADS = 1;
    public static final int DEFAULT_QUEUE_CAPACITY = 1024;
    public static final Priority DEFAULT_PRIORITY = Priority.NORMAL;

    public StartTrainedModelDeploymentAction() {
        super(NAME);
    }

    public static long estimateMemoryUsageBytes(String modelId, long totalDefinitionLength, long perDeploymentMemoryBytes, long perAllocationMemoryBytes, int numberOfAllocations) {
        if (StartTrainedModelDeploymentAction.isElserV1Or2Model(modelId)) {
            return ELSER_1_OR_2_MEMORY_USAGE.getBytes();
        }
        long baseSize = MEMORY_OVERHEAD.getBytes() + 2L * totalDefinitionLength;
        if (perDeploymentMemoryBytes == 0L && perAllocationMemoryBytes == 0L) {
            return baseSize;
        }
        return Math.max(baseSize, perDeploymentMemoryBytes + perAllocationMemoryBytes * (long)numberOfAllocations + totalDefinitionLength);
    }

    private static boolean isElserV1Or2Model(String modelId) {
        return modelId.startsWith(".elser_model_1") || modelId.startsWith(".elser_model_2");
    }

    public static interface TaskMatcher {
        public static boolean match(Task task, String expectedId) {
            if (task instanceof TaskMatcher) {
                if (Strings.isAllOrWildcard(expectedId)) {
                    return true;
                }
                String expectedDescription = MlTasks.trainedModelAssignmentTaskDescription(expectedId);
                return expectedDescription.equals(task.getDescription());
            }
            return false;
        }
    }

    public static class TaskParams
    implements MlTaskParams,
    Writeable,
    ToXContentObject {
        public static final MlConfigVersion VERSION_INTRODUCED = MlConfigVersion.V_8_0_0;
        private static final ParseField MODEL_BYTES = new ParseField("model_bytes", new String[0]);
        public static final ParseField NUMBER_OF_ALLOCATIONS = new ParseField("number_of_allocations", new String[0]);
        public static final ParseField THREADS_PER_ALLOCATION = new ParseField("threads_per_allocation", new String[0]);
        private static final ParseField LEGACY_MODEL_THREADS = new ParseField("model_threads", new String[0]);
        public static final ParseField LEGACY_INFERENCE_THREADS = new ParseField("inference_threads", new String[0]);
        public static final ParseField QUEUE_CAPACITY = new ParseField("queue_capacity", new String[0]);
        public static final ParseField CACHE_SIZE = new ParseField("cache_size", new String[0]);
        public static final ParseField PRIORITY = new ParseField("priority", new String[0]);
        public static final ParseField PER_DEPLOYMENT_MEMORY_BYTES = new ParseField("per_deployment_memory_bytes", new String[0]);
        public static final ParseField PER_ALLOCATION_MEMORY_BYTES = new ParseField("per_allocation_memory_bytes", new String[0]);
        private static final ConstructingObjectParser<TaskParams, Void> PARSER = new ConstructingObjectParser("trained_model_deployment_params", true, a -> new TaskParams((String)a[0], (String)a[1], (Long)a[2], (Integer)a[3], (Integer)a[4], (Integer)a[5], (ByteSizeValue)a[6], (Integer)a[7], (Integer)a[8], a[9] == null ? null : Priority.fromString((String)a[9]), (Long)a[10], (Long)a[11]));
        private final String modelId;
        private final String deploymentId;
        private final ByteSizeValue cacheSize;
        private final long modelBytes;
        private final int threadsPerAllocation;
        private final int numberOfAllocations;
        private final int queueCapacity;
        private final Priority priority;
        private final long perDeploymentMemoryBytes;
        private final long perAllocationMemoryBytes;

        public static boolean mayAssignToNode(@Nullable DiscoveryNode node) {
            return node != null && node.getRoles().contains(DiscoveryNodeRole.ML_ROLE) && MlConfigVersion.fromNode(node).onOrAfter(VERSION_INTRODUCED);
        }

        public static TaskParams fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        private TaskParams(String modelId, @Nullable String deploymentId, long modelBytes, Integer numberOfAllocations, Integer threadsPerAllocation, int queueCapacity, ByteSizeValue cacheSizeValue, Integer legacyModelThreads, Integer legacyInferenceThreads, Priority priority, Long perDeploymentMemoryBytes, Long perAllocationMemoryBytes) {
            this(modelId, deploymentId == null ? modelId : deploymentId, modelBytes, numberOfAllocations == null ? legacyModelThreads : numberOfAllocations, threadsPerAllocation == null ? legacyInferenceThreads : threadsPerAllocation, queueCapacity, cacheSizeValue, priority == null ? Priority.NORMAL : priority, perDeploymentMemoryBytes == null ? 0L : perDeploymentMemoryBytes, perAllocationMemoryBytes == null ? 0L : perAllocationMemoryBytes);
        }

        public TaskParams(String modelId, String deploymentId, long modelBytes, int numberOfAllocations, int threadsPerAllocation, int queueCapacity, @Nullable ByteSizeValue cacheSize, Priority priority, long perDeploymentMemoryBytes, long perAllocationMemoryBytes) {
            this.modelId = Objects.requireNonNull(modelId);
            this.deploymentId = Objects.requireNonNull(deploymentId);
            this.modelBytes = modelBytes;
            this.threadsPerAllocation = threadsPerAllocation;
            this.numberOfAllocations = numberOfAllocations;
            this.queueCapacity = queueCapacity;
            this.cacheSize = cacheSize;
            this.priority = Objects.requireNonNull(priority);
            this.perDeploymentMemoryBytes = perDeploymentMemoryBytes;
            this.perAllocationMemoryBytes = perAllocationMemoryBytes;
        }

        public TaskParams(StreamInput in) throws IOException {
            this.modelId = in.readString();
            this.modelBytes = in.readLong();
            this.threadsPerAllocation = in.readVInt();
            this.numberOfAllocations = in.readVInt();
            this.queueCapacity = in.readVInt();
            this.cacheSize = in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0) ? in.readOptionalWriteable(ByteSizeValue::readFrom) : null;
            this.priority = in.getTransportVersion().onOrAfter(TransportVersions.V_8_6_0) ? in.readEnum(Priority.class) : Priority.NORMAL;
            this.deploymentId = in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? in.readString() : this.modelId;
            if (in.getTransportVersion().onOrAfter(TrainedModelConfig.VERSION_ALLOCATION_MEMORY_ADDED)) {
                this.perDeploymentMemoryBytes = in.readLong();
                this.perAllocationMemoryBytes = in.readLong();
            } else {
                this.perDeploymentMemoryBytes = 0L;
                this.perAllocationMemoryBytes = 0L;
            }
        }

        public String getModelId() {
            return this.modelId;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public long estimateMemoryUsageBytes() {
            if (this.cacheSize != null && this.cacheSize.getBytes() > this.modelBytes) {
                return StartTrainedModelDeploymentAction.estimateMemoryUsageBytes(this.modelId, this.modelBytes, this.perDeploymentMemoryBytes, this.perAllocationMemoryBytes, this.numberOfAllocations) + (this.cacheSize.getBytes() - this.modelBytes);
            }
            return StartTrainedModelDeploymentAction.estimateMemoryUsageBytes(this.modelId, this.modelBytes, this.perDeploymentMemoryBytes, this.perAllocationMemoryBytes, this.numberOfAllocations);
        }

        public MlConfigVersion getMinimalSupportedVersion() {
            return VERSION_INTRODUCED;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.modelId);
            out.writeLong(this.modelBytes);
            out.writeVInt(this.threadsPerAllocation);
            out.writeVInt(this.numberOfAllocations);
            out.writeVInt(this.queueCapacity);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
                out.writeOptionalWriteable(this.cacheSize);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_6_0)) {
                out.writeEnum(this.priority);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
                out.writeString(this.deploymentId);
            }
            if (out.getTransportVersion().onOrAfter(TrainedModelConfig.VERSION_ALLOCATION_MEMORY_ADDED)) {
                out.writeLong(this.perDeploymentMemoryBytes);
                out.writeLong(this.perAllocationMemoryBytes);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.modelId);
            builder.field(Request.DEPLOYMENT_ID.getPreferredName(), this.deploymentId);
            builder.field(MODEL_BYTES.getPreferredName(), this.modelBytes);
            builder.field(THREADS_PER_ALLOCATION.getPreferredName(), this.threadsPerAllocation);
            builder.field(NUMBER_OF_ALLOCATIONS.getPreferredName(), this.numberOfAllocations);
            builder.field(QUEUE_CAPACITY.getPreferredName(), this.queueCapacity);
            if (this.cacheSize != null) {
                builder.field(CACHE_SIZE.getPreferredName(), this.cacheSize.getStringRep());
            }
            builder.field(PRIORITY.getPreferredName(), this.priority);
            builder.field(PER_DEPLOYMENT_MEMORY_BYTES.getPreferredName(), this.perDeploymentMemoryBytes);
            builder.field(PER_ALLOCATION_MEMORY_BYTES.getPreferredName(), this.perAllocationMemoryBytes);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.modelId, this.deploymentId, this.modelBytes, this.threadsPerAllocation, this.numberOfAllocations, this.queueCapacity, this.cacheSize, this.priority, this.perDeploymentMemoryBytes, this.perAllocationMemoryBytes});
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskParams other = (TaskParams)o;
            return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.deploymentId, other.deploymentId) && this.modelBytes == other.modelBytes && this.threadsPerAllocation == other.threadsPerAllocation && this.numberOfAllocations == other.numberOfAllocations && Objects.equals(this.cacheSize, other.cacheSize) && this.queueCapacity == other.queueCapacity && this.priority == other.priority && this.perDeploymentMemoryBytes == other.perDeploymentMemoryBytes && this.perAllocationMemoryBytes == other.perAllocationMemoryBytes;
        }

        @Override
        public String getMlId() {
            return this.modelId;
        }

        public long getModelBytes() {
            return this.modelBytes;
        }

        public int getThreadsPerAllocation() {
            return this.threadsPerAllocation;
        }

        public int getNumberOfAllocations() {
            return this.numberOfAllocations;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public Optional<ByteSizeValue> getCacheSize() {
            return Optional.ofNullable(this.cacheSize);
        }

        public long getCacheSizeBytes() {
            return Optional.ofNullable(this.cacheSize).map(ByteSizeValue::getBytes).orElse(this.modelBytes);
        }

        public Priority getPriority() {
            return this.priority;
        }

        public long getPerAllocationMemoryBytes() {
            return this.perAllocationMemoryBytes;
        }

        public long getPerDeploymentMemoryBytes() {
            return this.perDeploymentMemoryBytes;
        }

        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), TrainedModelConfig.MODEL_ID);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Request.DEPLOYMENT_ID);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), MODEL_BYTES);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUMBER_OF_ALLOCATIONS);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), THREADS_PER_ALLOCATION);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), QUEUE_CAPACITY);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), CACHE_SIZE.getPreferredName()), CACHE_SIZE, ObjectParser.ValueType.VALUE);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), LEGACY_MODEL_THREADS);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), LEGACY_INFERENCE_THREADS);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PRIORITY);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PER_DEPLOYMENT_MEMORY_BYTES);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PER_ALLOCATION_MEMORY_BYTES);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        private static final AllocationStatus.State[] VALID_WAIT_STATES = new AllocationStatus.State[]{AllocationStatus.State.STARTED, AllocationStatus.State.STARTING, AllocationStatus.State.FULLY_ALLOCATED};
        private static final int MAX_THREADS_PER_ALLOCATION = 32;
        private static final int MAX_QUEUE_CAPACITY = 1000000;
        public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
        public static final ParseField DEPLOYMENT_ID = new ParseField("deployment_id", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField WAIT_FOR = new ParseField("wait_for", new String[0]);
        public static final ParseField THREADS_PER_ALLOCATION = new ParseField("threads_per_allocation", "inference_threads");
        public static final ParseField NUMBER_OF_ALLOCATIONS = new ParseField("number_of_allocations", "model_threads");
        public static final ParseField QUEUE_CAPACITY = TaskParams.QUEUE_CAPACITY;
        public static final ParseField CACHE_SIZE = TaskParams.CACHE_SIZE;
        public static final ParseField PRIORITY = TaskParams.PRIORITY;
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/trained_models/deployment/start", Request::new);
        private String modelId;
        private String deploymentId;
        private TimeValue timeout = DEFAULT_TIMEOUT;
        private AllocationStatus.State waitForState = DEFAULT_WAITFOR_STATE;
        private ByteSizeValue cacheSize;
        private int numberOfAllocations = 1;
        private int threadsPerAllocation = 1;
        private int queueCapacity = 1024;
        private Priority priority = DEFAULT_PRIORITY;

        public static Request parseRequest(String modelId, String deploymentId, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (request.getModelId() == null) {
                request.setModelId(modelId);
            } else if (!Strings.isNullOrEmpty(modelId) && !modelId.equals(request.getModelId())) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", MODEL_ID, request.getModelId(), modelId), new Object[0]);
            }
            if (deploymentId != null) {
                request.setDeploymentId(deploymentId);
            }
            return request;
        }

        private Request() {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
        }

        public Request(String modelId, String deploymentId) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.setModelId(modelId);
            this.setDeploymentId(deploymentId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.timeout = in.readTimeValue();
            this.waitForState = in.readEnum(AllocationStatus.State.class);
            this.numberOfAllocations = in.readVInt();
            this.threadsPerAllocation = in.readVInt();
            this.queueCapacity = in.readVInt();
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
                this.cacheSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
            }
            this.priority = in.getTransportVersion().onOrAfter(TransportVersions.V_8_6_0) ? in.readEnum(Priority.class) : Priority.NORMAL;
            this.deploymentId = in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? in.readString() : this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = ExceptionsHelper.requireNonNull(modelId, MODEL_ID);
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, DEPLOYMENT_ID);
        }

        public String getModelId() {
            return this.modelId;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = ExceptionsHelper.requireNonNull(timeout, TIMEOUT);
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public AllocationStatus.State getWaitForState() {
            return this.waitForState;
        }

        public Request setWaitForState(AllocationStatus.State waitForState) {
            this.waitForState = ExceptionsHelper.requireNonNull(waitForState, WAIT_FOR);
            return this;
        }

        public int getNumberOfAllocations() {
            return this.numberOfAllocations;
        }

        public void setNumberOfAllocations(int numberOfAllocations) {
            this.numberOfAllocations = numberOfAllocations;
        }

        public int getThreadsPerAllocation() {
            return this.threadsPerAllocation;
        }

        public void setThreadsPerAllocation(int threadsPerAllocation) {
            this.threadsPerAllocation = threadsPerAllocation;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public ByteSizeValue getCacheSize() {
            return this.cacheSize;
        }

        public void setCacheSize(ByteSizeValue cacheSize) {
            this.cacheSize = cacheSize;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public void setPriority(String priority) {
            this.priority = Priority.fromString(priority);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            out.writeTimeValue(this.timeout);
            out.writeEnum(this.waitForState);
            out.writeVInt(this.numberOfAllocations);
            out.writeVInt(this.threadsPerAllocation);
            out.writeVInt(this.queueCapacity);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
                out.writeOptionalWriteable(this.cacheSize);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_6_0)) {
                out.writeEnum(this.priority);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
                out.writeString(this.deploymentId);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MODEL_ID.getPreferredName(), this.modelId);
            builder.field(DEPLOYMENT_ID.getPreferredName(), this.deploymentId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.field(WAIT_FOR.getPreferredName(), this.waitForState);
            builder.field(NUMBER_OF_ALLOCATIONS.getPreferredName(), this.numberOfAllocations);
            builder.field(THREADS_PER_ALLOCATION.getPreferredName(), this.threadsPerAllocation);
            builder.field(QUEUE_CAPACITY.getPreferredName(), this.queueCapacity);
            if (this.cacheSize != null) {
                builder.field(CACHE_SIZE.getPreferredName(), this.cacheSize);
            }
            builder.field(PRIORITY.getPreferredName(), this.priority);
            builder.endObject();
            return builder;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            if (!this.waitForState.isAnyOf(VALID_WAIT_STATES)) {
                validationException.addValidationError("invalid [wait_for] state [" + this.waitForState + "]; must be one of [" + Strings.arrayToCommaDelimitedString((Object[])VALID_WAIT_STATES));
            }
            if (this.numberOfAllocations < 1) {
                validationException.addValidationError("[" + NUMBER_OF_ALLOCATIONS + "] must be a positive integer");
            }
            if (this.threadsPerAllocation < 1) {
                validationException.addValidationError("[" + THREADS_PER_ALLOCATION + "] must be a positive integer");
            }
            if (this.threadsPerAllocation > 32 || !Request.isPowerOf2(this.threadsPerAllocation)) {
                validationException.addValidationError("[" + THREADS_PER_ALLOCATION + "] must be a power of 2 less than or equal to 32");
            }
            if (this.queueCapacity < 1) {
                validationException.addValidationError("[" + QUEUE_CAPACITY + "] must be a positive integer");
            }
            if (this.queueCapacity > 1000000) {
                validationException.addValidationError("[" + QUEUE_CAPACITY + "] must be less than 1000000");
            }
            if (this.timeout.nanos() < 1L) {
                validationException.addValidationError("[" + TIMEOUT + "] must be positive");
            }
            if (this.priority == Priority.LOW) {
                if (this.numberOfAllocations > 1) {
                    validationException.addValidationError("[" + NUMBER_OF_ALLOCATIONS + "] must be 1 when [" + PRIORITY + "] is low");
                }
                if (this.threadsPerAllocation > 1) {
                    validationException.addValidationError("[" + THREADS_PER_ALLOCATION + "] must be 1 when [" + PRIORITY + "] is low");
                }
            }
            return validationException.validationErrors().isEmpty() ? null : validationException;
        }

        private static boolean isPowerOf2(int value) {
            return Integer.bitCount(value) == 1;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.modelId, this.deploymentId, this.timeout, this.waitForState, this.numberOfAllocations, this.threadsPerAllocation, this.queueCapacity, this.cacheSize, this.priority});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals(this.timeout, other.timeout) && Objects.equals((Object)this.waitForState, (Object)other.waitForState) && Objects.equals(this.cacheSize, other.cacheSize) && this.numberOfAllocations == other.numberOfAllocations && this.threadsPerAllocation == other.threadsPerAllocation && this.queueCapacity == other.queueCapacity && this.priority == other.priority;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(Request::setModelId, MODEL_ID);
            PARSER.declareString(Request::setDeploymentId, DEPLOYMENT_ID);
            PARSER.declareString((request, val) -> request.setTimeout(TimeValue.parseTimeValue(val, TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareString((request, waitFor) -> request.setWaitForState(AllocationStatus.State.fromString(waitFor)), WAIT_FOR);
            PARSER.declareInt(Request::setThreadsPerAllocation, THREADS_PER_ALLOCATION);
            PARSER.declareInt(Request::setNumberOfAllocations, NUMBER_OF_ALLOCATIONS);
            PARSER.declareInt(Request::setQueueCapacity, QUEUE_CAPACITY);
            PARSER.declareField(Request::setCacheSize, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), CACHE_SIZE.getPreferredName()), CACHE_SIZE, ObjectParser.ValueType.VALUE);
            PARSER.declareString(Request::setPriority, PRIORITY);
        }
    }
}

