/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class ForecastJobAction
extends ActionType<Response> {
    public static final ForecastJobAction INSTANCE = new ForecastJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/forecast";

    private ForecastJobAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean acknowledged;
        private final String forecastId;

        public Response(boolean acknowledged, String forecastId) {
            super(null, null);
            this.acknowledged = acknowledged;
            this.forecastId = forecastId;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.acknowledged = in.readBoolean();
            this.forecastId = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.acknowledged);
            out.writeString(this.forecastId);
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }

        public String getForecastId() {
            return this.forecastId;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("acknowledged", this.acknowledged);
            builder.field(Forecast.FORECAST_ID.getPreferredName(), this.forecastId);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return this.acknowledged == other.acknowledged && Objects.equals(this.forecastId, other.forecastId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.acknowledged, this.forecastId);
        }
    }

    public static class Request
    extends JobTaskRequest<Request>
    implements ToXContentObject {
        public static final ParseField DURATION = new ParseField("duration", new String[0]);
        public static final ParseField EXPIRES_IN = new ParseField("expires_in", new String[0]);
        public static final ParseField MAX_MODEL_MEMORY = new ParseField("max_model_memory", new String[0]);
        public static final ByteSizeValue FORECAST_LOCAL_STORAGE_LIMIT = ByteSizeValue.ofMb(500L);
        private static final TimeValue MAX_DURATION = TimeValue.parseTimeValue("3650d", "");
        private static final long MIN_MODEL_MEMORY = ByteSizeValue.ofMb(1L).getBytes();
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/forecast", Request::new);
        private TimeValue duration;
        private TimeValue expiresIn;
        private Long maxModelMemory;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.duration = in.readOptionalTimeValue();
            this.expiresIn = in.readOptionalTimeValue();
            this.maxModelMemory = in.readOptionalVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalTimeValue(this.duration);
            out.writeOptionalTimeValue(this.expiresIn);
            out.writeOptionalVLong(this.maxModelMemory);
        }

        public Request(String jobId) {
            super(jobId);
        }

        public TimeValue getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.setDuration(TimeValue.parseTimeValue(duration, DURATION.getPreferredName()));
        }

        public void setDuration(TimeValue duration) {
            this.duration = duration;
            if (this.duration.compareTo(TimeValue.ZERO) <= 0) {
                throw new IllegalArgumentException("[" + DURATION.getPreferredName() + "] must be positive: [" + duration.getStringRep() + "]");
            }
            if (this.duration.compareTo(MAX_DURATION) > 0) {
                throw new IllegalArgumentException("[" + DURATION.getPreferredName() + "] must be " + MAX_DURATION.getStringRep() + " or less: [" + duration.getStringRep() + "]");
            }
        }

        public TimeValue getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(String expiration) {
            this.setExpiresIn(TimeValue.parseTimeValue(expiration, EXPIRES_IN.getPreferredName()));
        }

        public void setExpiresIn(TimeValue expiresIn) {
            this.expiresIn = expiresIn;
            if (this.expiresIn.compareTo(TimeValue.ZERO) < 0) {
                throw new IllegalArgumentException("[" + EXPIRES_IN.getPreferredName() + "] must be non-negative: [" + expiresIn.getStringRep() + "]");
            }
        }

        public void setMaxModelMemory(long numBytes) {
            if (numBytes < MIN_MODEL_MEMORY) {
                throw new IllegalArgumentException("[" + MAX_MODEL_MEMORY.getPreferredName() + "] must be at least 1mb.");
            }
            if (numBytes >= FORECAST_LOCAL_STORAGE_LIMIT.getBytes()) {
                throw ExceptionsHelper.badRequestException("[{}] must be less than {}", MAX_MODEL_MEMORY.getPreferredName(), FORECAST_LOCAL_STORAGE_LIMIT.getStringRep());
            }
            this.maxModelMemory = numBytes;
        }

        public Long getMaxModelMemory() {
            return this.maxModelMemory;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.duration, this.expiresIn, this.maxModelMemory);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.duration, other.duration) && Objects.equals(this.expiresIn, other.expiresIn) && Objects.equals(this.maxModelMemory, other.maxModelMemory);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            if (this.duration != null) {
                builder.field(DURATION.getPreferredName(), this.duration.getStringRep());
            }
            if (this.expiresIn != null) {
                builder.field(EXPIRES_IN.getPreferredName(), this.expiresIn.getStringRep());
            }
            if (this.maxModelMemory != null) {
                builder.field(MAX_MODEL_MEMORY.getPreferredName(), ByteSizeValue.ofBytes(this.maxModelMemory).getStringRep());
            }
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareString(Request::setDuration, DURATION);
            PARSER.declareString(Request::setExpiresIn, EXPIRES_IN);
            PARSER.declareField(Request::setMaxModelMemory, (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return ByteSizeValue.parseBytesSizeValue(p.text(), MAX_MODEL_MEMORY.getPreferredName()).getBytes();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.longValue();
                }
                throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
            }, MAX_MODEL_MEMORY, ObjectParser.ValueType.VALUE);
        }
    }
}

