/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ErrorChunkedInferenceResults
implements ChunkedInferenceServiceResults {
    public static final String NAME = "error_chunked";
    private final Exception exception;

    public ErrorChunkedInferenceResults(Exception exception) {
        this.exception = Objects.requireNonNull(exception);
    }

    public ErrorChunkedInferenceResults(StreamInput in) throws IOException {
        this.exception = in.readException();
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeException(this.exception);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ErrorChunkedInferenceResults that = (ErrorChunkedInferenceResults)object;
        return Objects.equals(this.exception.getMessage(), that.exception.getMessage());
    }

    public int hashCode() {
        return Objects.hash(this.exception.getMessage());
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return null;
    }

    @Override
    public List<? extends InferenceResults> transformToLegacyFormat() {
        return null;
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> asMap = new LinkedHashMap<String, Object>();
        asMap.put(NAME, this.exception.getMessage());
        return asMap;
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NAME, this.exception.getMessage());
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Iterator<ChunkedInferenceServiceResults.Chunk> chunksAsMatchedTextAndByteReference(XContent xcontent) {
        return Stream.of(this.exception).map(e -> new ChunkedInferenceServiceResults.Chunk(e.getMessage(), BytesArray.EMPTY)).iterator();
    }
}

