/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class DeleteInferenceEndpointAction
extends ActionType<Response> {
    public static final DeleteInferenceEndpointAction INSTANCE = new DeleteInferenceEndpointAction();
    public static final String NAME = "cluster:admin/xpack/inference/delete";

    public DeleteInferenceEndpointAction() {
        super(NAME);
    }

    public static class Response
    extends AcknowledgedResponse {
        private final String PIPELINE_IDS = "pipelines";
        Set<String> pipelineIds;

        public Response(boolean acknowledged, Set<String> pipelineIds) {
            super(acknowledged);
            this.pipelineIds = pipelineIds;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.pipelineIds = in.getTransportVersion().onOrAfter(TransportVersions.ML_INFERENCE_ENHANCE_DELETE_ENDPOINT) ? in.readCollectionAsSet(StreamInput::readString) : Set.of();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.ML_INFERENCE_ENHANCE_DELETE_ENDPOINT)) {
                out.writeCollection(this.pipelineIds, StreamOutput::writeString);
            }
        }

        @Override
        protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.addCustomFields(builder, params);
            builder.field("pipelines", (Collection<String>)this.pipelineIds);
        }

        public String toString() {
            StringBuilder returnable = new StringBuilder();
            returnable.append("acknowledged: ").append(this.acknowledged);
            returnable.append(", pipelineIdsByEndpoint: ");
            for (String entry : this.pipelineIds) {
                returnable.append(entry).append(", ");
            }
            return returnable.toString();
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String inferenceEndpointId;
        private final TaskType taskType;
        private final boolean forceDelete;
        private final boolean dryRun;

        public Request(String inferenceEndpointId, TaskType taskType, boolean forceDelete, boolean dryRun) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.inferenceEndpointId = inferenceEndpointId;
            this.taskType = taskType;
            this.forceDelete = forceDelete;
            this.dryRun = dryRun;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEndpointId = in.readString();
            this.taskType = TaskType.fromStream(in);
            if (in.getTransportVersion().onOrAfter(TransportVersions.ML_INFERENCE_ENHANCE_DELETE_ENDPOINT)) {
                this.forceDelete = Boolean.TRUE.equals(in.readOptionalBoolean());
                this.dryRun = Boolean.TRUE.equals(in.readOptionalBoolean());
            } else {
                this.forceDelete = false;
                this.dryRun = false;
            }
        }

        public String getInferenceEndpointId() {
            return this.inferenceEndpointId;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public boolean isForceDelete() {
            return this.forceDelete;
        }

        public boolean isDryRun() {
            return this.dryRun;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEndpointId);
            this.taskType.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.ML_INFERENCE_ENHANCE_DELETE_ENDPOINT)) {
                out.writeOptionalBoolean(this.forceDelete);
                out.writeOptionalBoolean(this.dryRun);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.inferenceEndpointId, request.inferenceEndpointId) && this.taskType == request.taskType && this.forceDelete == request.forceDelete && this.dryRun == request.dryRun;
        }

        public int hashCode() {
            return Objects.hash(this.inferenceEndpointId, this.taskType, this.forceDelete, this.dryRun);
        }
    }
}

