/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;

public class RolloverStep
extends AsyncActionStep {
    private static final Logger logger = LogManager.getLogger(RolloverStep.class);
    public static final String NAME = "attempt-rollover";

    public RolloverStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentClusterState, ClusterStateObserver observer, ActionListener<Void> listener) {
        String rolloverTarget;
        boolean targetFailureStore;
        String indexName = indexMetadata.getIndex().getName();
        boolean indexingComplete = LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(indexMetadata.getSettings());
        if (indexingComplete) {
            logger.trace(indexMetadata.getIndex() + " has lifecycle complete set, skipping attempt-rollover");
            listener.onResponse(null);
            return;
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentClusterState.metadata().getIndicesLookup().get(indexName);
        assert (indexAbstraction != null) : "expected the index " + indexName + " to exist in the lookup but it didn't";
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream != null) {
            boolean isFailureStoreWriteIndex = indexMetadata.getIndex().equals(dataStream.getFailureStoreWriteIndex());
            targetFailureStore = dataStream.isFailureStoreIndex(indexMetadata.getIndex().getName());
            if (!isFailureStoreWriteIndex && !dataStream.getWriteIndex().equals(indexMetadata.getIndex())) {
                logger.warn("index [{}] is not the {}write index for data stream [{}]. skipping rollover for policy [{}]", (Object)indexName, (Object)(targetFailureStore ? "failure store " : ""), (Object)dataStream.getName(), (Object)indexMetadata.getLifecyclePolicyName());
                listener.onResponse(null);
                return;
            }
            rolloverTarget = dataStream.getName();
        } else {
            String rolloverAlias = RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(indexMetadata.getSettings());
            if (Strings.isNullOrEmpty(rolloverAlias)) {
                listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "setting [%s] for index [%s] is empty or not defined, it must be set to the name of the alias pointing to the group of indices being rolled over", "index.lifecycle.rollover_alias", indexName)));
                return;
            }
            if (indexMetadata.getRolloverInfos().get(rolloverAlias) != null) {
                logger.info("index [{}] was already rolled over for alias [{}], not attempting to roll over again", (Object)indexName, (Object)rolloverAlias);
                listener.onResponse(null);
                return;
            }
            if (!indexMetadata.getAliases().containsKey(rolloverAlias)) {
                listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "%s [%s] does not point to index [%s]", "index.lifecycle.rollover_alias", rolloverAlias, indexName)));
                return;
            }
            rolloverTarget = rolloverAlias;
            targetFailureStore = false;
        }
        RolloverRequest rolloverRequest = (RolloverRequest)new RolloverRequest(rolloverTarget, null).masterNodeTimeout(TimeValue.MAX_VALUE);
        if (targetFailureStore) {
            rolloverRequest.setIndicesOptions(IndicesOptions.builder(rolloverRequest.indicesOptions()).failureStoreOptions(opts -> opts.includeFailureIndices(true).includeRegularIndices(false)).build());
        }
        rolloverRequest.setWaitForActiveShards(ActiveShardCount.NONE);
        this.getClient().admin().indices().rolloverIndex(rolloverRequest, listener.delegateFailureAndWrap((l, response) -> {
            assert (response.isRolledOver()) : "the only way this rollover call should fail is with an exception";
            if (response.isRolledOver()) {
                l.onResponse(null);
            } else {
                l.onFailure(new IllegalStateException("unexepected exception on unconditional rollover"));
            }
        }));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RolloverStep other = (RolloverStep)obj;
        return super.equals(obj);
    }
}

