/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.scheduler.CronSchedule;

public class LifecycleSettings {
    public static final String LIFECYCLE_POLL_INTERVAL = "indices.lifecycle.poll_interval";
    public static final String LIFECYCLE_NAME = "index.lifecycle.name";
    public static final String LIFECYCLE_INDEXING_COMPLETE = "index.lifecycle.indexing_complete";
    public static final String LIFECYCLE_HISTORY_INDEX_ENABLED = "indices.lifecycle.history_index_enabled";
    public static final String LIFECYCLE_STEP_MASTER_TIMEOUT = "indices.lifecycle.step.master_timeout";
    public static final String LIFECYCLE_STEP_WAIT_TIME_THRESHOLD = "index.lifecycle.step.wait_time_threshold";
    public static final String LIFECYCLE_ROLLOVER_ONLY_IF_HAS_DOCUMENTS = "indices.lifecycle.rollover.only_if_has_documents";
    public static final String SLM_HISTORY_INDEX_ENABLED = "slm.history_index_enabled";
    public static final String SLM_RETENTION_SCHEDULE = "slm.retention_schedule";
    public static final String SLM_RETENTION_DURATION = "slm.retention_duration";
    public static final String SLM_MINIMUM_INTERVAL = "slm.minimum_interval";
    public static final String SLM_HEALTH_FAILED_SNAPSHOT_WARN_THRESHOLD = "slm.health.failed_snapshot_warn_threshold";
    public static final String SNAPSHOT_INDEX_NAME = "index.store.snapshot.index_name";
    public static final Setting<TimeValue> LIFECYCLE_POLL_INTERVAL_SETTING = Setting.timeSetting("indices.lifecycle.poll_interval", TimeValue.timeValueMinutes(10L), TimeValue.timeValueSeconds(1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<String> LIFECYCLE_NAME_SETTING = Setting.simpleString("index.lifecycle.name", Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> LIFECYCLE_INDEXING_COMPLETE_SETTING = Setting.boolSetting("index.lifecycle.indexing_complete", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING = Setting.boolSetting("indices.lifecycle.history_index_enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> LIFECYCLE_STEP_MASTER_TIMEOUT_SETTING = Setting.positiveTimeSetting("indices.lifecycle.step.master_timeout", TimeValue.timeValueSeconds(30L), Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning);
    public static final Setting<TimeValue> LIFECYCLE_STEP_WAIT_TIME_THRESHOLD_SETTING = Setting.timeSetting("index.lifecycle.step.wait_time_threshold", TimeValue.timeValueHours(12L), TimeValue.timeValueHours(1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> LIFECYCLE_ROLLOVER_ONLY_IF_HAS_DOCUMENTS_SETTING = Setting.boolSetting("indices.lifecycle.rollover.only_if_has_documents", true, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning);
    public static final Setting<Boolean> SLM_HISTORY_INDEX_ENABLED_SETTING = Setting.boolSetting("slm.history_index_enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<String> SLM_RETENTION_SCHEDULE_SETTING = Setting.simpleString("slm.retention_schedule", "0 30 1 * * ?", str -> {
        try {
            if (Strings.hasText(str)) {
                new CronSchedule((String)str);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid cron expression [" + str + "] for SLM retention schedule [slm.retention_schedule]", e);
        }
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> SLM_RETENTION_DURATION_SETTING = Setting.timeSetting("slm.retention_duration", TimeValue.timeValueHours(1L), TimeValue.timeValueMillis(500L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> SLM_MINIMUM_INTERVAL_SETTING = Setting.positiveTimeSetting("slm.minimum_interval", TimeValue.timeValueMinutes(15L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Long> SLM_HEALTH_FAILED_SNAPSHOT_WARN_THRESHOLD_SETTING = Setting.longSetting("slm.health.failed_snapshot_warn_threshold", 5L, 1L, Setting.Property.Dynamic, Setting.Property.NodeScope);
}

