/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.AllocationRoutedStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;

public class AllocateAction
implements LifecycleAction {
    public static final String NAME = "allocate";
    public static final ParseField NUMBER_OF_REPLICAS_FIELD = new ParseField("number_of_replicas", new String[0]);
    public static final ParseField TOTAL_SHARDS_PER_NODE_FIELD = new ParseField("total_shards_per_node", new String[0]);
    public static final ParseField INCLUDE_FIELD = new ParseField("include", new String[0]);
    public static final ParseField EXCLUDE_FIELD = new ParseField("exclude", new String[0]);
    public static final ParseField REQUIRE_FIELD = new ParseField("require", new String[0]);
    private static final ConstructingObjectParser<AllocateAction, Void> PARSER = new ConstructingObjectParser("allocate", a -> new AllocateAction((Integer)a[0], (Integer)a[1], (Map)a[2], (Map)a[3], (Map)a[4]));
    private final Integer numberOfReplicas;
    private final Integer totalShardsPerNode;
    private final Map<String, String> include;
    private final Map<String, String> exclude;
    private final Map<String, String> require;

    public static AllocateAction parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public AllocateAction(Integer numberOfReplicas, Integer totalShardsPerNode, Map<String, String> include, Map<String, String> exclude, Map<String, String> require) {
        this.include = include == null ? Collections.emptyMap() : include;
        this.exclude = exclude == null ? Collections.emptyMap() : exclude;
        this.require = require == null ? Collections.emptyMap() : require;
        if (this.include.isEmpty() && this.exclude.isEmpty() && this.require.isEmpty() && numberOfReplicas == null && totalShardsPerNode == null) {
            throw new IllegalArgumentException("At least one of " + INCLUDE_FIELD.getPreferredName() + ", " + EXCLUDE_FIELD.getPreferredName() + " or " + REQUIRE_FIELD.getPreferredName() + " must contain attributes for action allocate. Otherwise the " + NUMBER_OF_REPLICAS_FIELD.getPreferredName() + " or the " + TOTAL_SHARDS_PER_NODE_FIELD.getPreferredName() + " options must be configured.");
        }
        if (numberOfReplicas != null && numberOfReplicas < 0) {
            throw new IllegalArgumentException("[" + NUMBER_OF_REPLICAS_FIELD.getPreferredName() + "] must be >= 0");
        }
        this.numberOfReplicas = numberOfReplicas;
        if (totalShardsPerNode != null && totalShardsPerNode < -1) {
            throw new IllegalArgumentException("[" + TOTAL_SHARDS_PER_NODE_FIELD.getPreferredName() + "] must be >= -1");
        }
        this.totalShardsPerNode = totalShardsPerNode;
    }

    public AllocateAction(StreamInput in) throws IOException {
        this(in.readOptionalVInt(), in.readOptionalInt(), (Map)in.readGenericValue(), (Map)in.readGenericValue(), (Map)in.readGenericValue());
    }

    public Integer getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public Integer getTotalShardsPerNode() {
        return this.totalShardsPerNode;
    }

    public Map<String, String> getInclude() {
        return this.include;
    }

    public Map<String, String> getExclude() {
        return this.exclude;
    }

    public Map<String, String> getRequire() {
        return this.require;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.numberOfReplicas);
        out.writeOptionalInt(this.totalShardsPerNode);
        out.writeGenericValue(this.include);
        out.writeGenericValue(this.exclude);
        out.writeGenericValue(this.require);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numberOfReplicas != null) {
            builder.field(NUMBER_OF_REPLICAS_FIELD.getPreferredName(), this.numberOfReplicas);
        }
        if (this.totalShardsPerNode != null) {
            builder.field(TOTAL_SHARDS_PER_NODE_FIELD.getPreferredName(), this.totalShardsPerNode);
        }
        builder.stringStringMap(INCLUDE_FIELD.getPreferredName(), this.include);
        builder.stringStringMap(EXCLUDE_FIELD.getPreferredName(), this.exclude);
        builder.stringStringMap(REQUIRE_FIELD.getPreferredName(), this.require);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey allocateKey = new Step.StepKey(phase, NAME, NAME);
        Step.StepKey allocationRoutedKey = new Step.StepKey(phase, NAME, "check-allocation");
        Settings.Builder newSettings = Settings.builder();
        if (this.numberOfReplicas != null) {
            newSettings.put("index.number_of_replicas", this.numberOfReplicas);
        }
        this.include.forEach((key, value) -> newSettings.put(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + key, (String)value));
        this.exclude.forEach((key, value) -> newSettings.put(IndexMetadata.INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + key, (String)value));
        this.require.forEach((key, value) -> newSettings.put(IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getKey() + key, (String)value));
        if (this.totalShardsPerNode != null) {
            newSettings.put(ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING.getKey(), this.totalShardsPerNode);
        }
        UpdateSettingsStep allocateStep = new UpdateSettingsStep(allocateKey, allocationRoutedKey, client, newSettings.build());
        AllocationRoutedStep routedCheckStep = new AllocationRoutedStep(allocationRoutedKey, nextStepKey);
        return Arrays.asList(allocateStep, routedCheckStep);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfReplicas, this.totalShardsPerNode, this.include, this.exclude, this.require);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AllocateAction other = (AllocateAction)obj;
        return Objects.equals(this.numberOfReplicas, other.numberOfReplicas) && Objects.equals(this.totalShardsPerNode, other.totalShardsPerNode) && Objects.equals(this.include, other.include) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.require, other.require);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUMBER_OF_REPLICAS_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), TOTAL_SHARDS_PER_NODE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), INCLUDE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), EXCLUDE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), REQUIRE_FIELD);
    }
}

