/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public final class EnrichPolicy
implements Writeable,
ToXContentFragment {
    private static final String ELASTICEARCH_VERSION_DEPRECATION_MESSAGE = "the [elasticsearch_version] field of an enrich policy has no effect and will be removed in Elasticsearch 9.0";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(EnrichPolicy.class);
    public static final String ENRICH_INDEX_NAME_BASE = ".enrich-";
    public static final String ENRICH_INDEX_PATTERN = ".enrich-*";
    public static final String MATCH_TYPE = "match";
    public static final String GEO_MATCH_TYPE = "geo_match";
    public static final String RANGE_TYPE = "range";
    public static final String[] SUPPORTED_POLICY_TYPES = new String[]{"match", "geo_match", "range"};
    private static final ParseField QUERY = new ParseField("query", new String[0]);
    private static final ParseField INDICES = new ParseField("indices", new String[0]);
    private static final ParseField MATCH_FIELD = new ParseField("match_field", new String[0]);
    private static final ParseField ENRICH_FIELDS = new ParseField("enrich_fields", new String[0]);
    private static final ParseField ELASTICSEARCH_VERSION = new ParseField("elasticsearch_version", new String[0]);
    private static final ConstructingObjectParser<EnrichPolicy, String> PARSER = new ConstructingObjectParser<EnrichPolicy, String>("policy", false, (args, policyType) -> new EnrichPolicy((String)policyType, (QuerySource)args[0], (List)args[1], (String)args[2], (List)args[3], (String)args[4]));
    private final String type;
    private final QuerySource query;
    private final List<String> indices;
    private final String matchField;
    private final List<String> enrichFields;

    private static <T> void declareCommonConstructorParsingOptions(ConstructingObjectParser<T, ?> parser) {
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            XContentBuilder contentBuilder = XContentBuilder.builder(p.contentType().xContent());
            contentBuilder.generator().copyCurrentStructure(p);
            return new QuerySource(BytesReference.bytes(contentBuilder), contentBuilder.contentType());
        }, QUERY);
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), INDICES);
        parser.declareString(ConstructingObjectParser.constructorArg(), MATCH_FIELD);
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), ENRICH_FIELDS);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), ELASTICSEARCH_VERSION);
    }

    public static EnrichPolicy fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        String policyType = parser.currentName();
        EnrichPolicy policy = PARSER.parse(parser, policyType);
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        return policy;
    }

    public EnrichPolicy(StreamInput in) throws IOException {
        this.type = in.readString();
        this.query = in.readOptionalWriteable(QuerySource::new);
        this.indices = in.readStringCollectionAsList();
        this.matchField = in.readString();
        this.enrichFields = in.readStringCollectionAsList();
        if (in.getTransportVersion().before(TransportVersions.V_8_12_0)) {
            Version.readVersion(in);
        }
    }

    public EnrichPolicy(String type, QuerySource query, List<String> indices, String matchField, List<String> enrichFields) {
        this.type = type;
        this.query = query;
        this.indices = indices;
        this.matchField = matchField;
        this.enrichFields = enrichFields;
    }

    private EnrichPolicy(String type, QuerySource query, List<String> indices, String matchField, List<String> enrichFields, String elasticsearchVersion) {
        this(type, query, indices, matchField, enrichFields);
        if (elasticsearchVersion != null) {
            deprecationLogger.warn(DeprecationCategory.OTHER, "enrich_policy_with_elasticsearch_version", ELASTICEARCH_VERSION_DEPRECATION_MESSAGE, new Object[0]);
        }
    }

    public String getType() {
        return this.type;
    }

    public QuerySource getQuery() {
        return this.query;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public String getMatchField() {
        return this.matchField;
    }

    public List<String> getEnrichFields() {
        return this.enrichFields;
    }

    public static String getBaseName(String policyName) {
        return ENRICH_INDEX_NAME_BASE + policyName;
    }

    public static String getIndexName(String policyName, long nowTimestamp) {
        Objects.nonNull(policyName);
        return EnrichPolicy.getBaseName(policyName) + "-" + nowTimestamp;
    }

    public static boolean isPolicyForIndex(String policyName, String indexName) {
        Objects.nonNull(policyName);
        Objects.nonNull(indexName);
        return indexName.matches(EnrichPolicy.getBaseName(policyName) + "-\\d+");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeOptionalWriteable(this.query);
        out.writeStringCollection(this.indices);
        out.writeString(this.matchField);
        out.writeStringCollection(this.enrichFields);
        if (out.getTransportVersion().before(TransportVersions.V_8_12_0)) {
            Version.writeVersion(Version.CURRENT, out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.type);
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    private void toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.query != null) {
            builder.field(QUERY.getPreferredName(), this.query.getQueryAsMap());
        }
        builder.array(INDICES.getPreferredName(), this.indices.toArray(new String[0]));
        builder.field(MATCH_FIELD.getPreferredName(), this.matchField);
        builder.array(ENRICH_FIELDS.getPreferredName(), this.enrichFields.toArray(new String[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichPolicy policy = (EnrichPolicy)o;
        return this.type.equals(policy.type) && Objects.equals(this.query, policy.query) && this.indices.equals(policy.indices) && this.matchField.equals(policy.matchField) && this.enrichFields.equals(policy.enrichFields);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.query, this.indices, this.matchField, this.enrichFields);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        EnrichPolicy.declareCommonConstructorParsingOptions(PARSER);
    }

    public static class QuerySource
    implements Writeable {
        private final BytesReference query;
        private final XContentType contentType;

        QuerySource(StreamInput in) throws IOException {
            this(in.readBytesReference(), in.readEnum(XContentType.class));
        }

        public QuerySource(BytesReference query, XContentType contentType) {
            this.query = query;
            this.contentType = contentType;
        }

        public BytesReference getQuery() {
            return this.query;
        }

        public Map<String, Object> getQueryAsMap() {
            return XContentHelper.convertToMap(this.query, true, this.contentType).v2();
        }

        public XContentType getContentType() {
            return this.contentType;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.query);
            XContentHelper.writeTo(out, this.contentType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuerySource that = (QuerySource)o;
            return this.query.equals(that.query) && this.contentType == that.contentType;
        }

        public int hashCode() {
            return Objects.hash(this.query, this.contentType);
        }
    }

    public static class NamedPolicy
    implements Writeable,
    ToXContentFragment {
        static final ParseField NAME = new ParseField("name", new String[0]);
        static final ConstructingObjectParser<NamedPolicy, String> PARSER = new ConstructingObjectParser<NamedPolicy, String>("named_policy", false, (args, policyType) -> new NamedPolicy((String)args[0], new EnrichPolicy((String)policyType, (QuerySource)args[1], (List)args[2], (String)args[3], (List)args[4], (String)args[5])));
        private final String name;
        private final EnrichPolicy policy;

        public NamedPolicy(String name, EnrichPolicy policy) {
            this.name = name;
            this.policy = policy;
        }

        public NamedPolicy(StreamInput in) throws IOException {
            this.name = in.readString();
            this.policy = new EnrichPolicy(in);
        }

        public String getName() {
            return this.name;
        }

        public EnrichPolicy getPolicy() {
            return this.policy;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            this.policy.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.policy.type);
            builder.field(NAME.getPreferredName(), this.name);
            this.policy.toInnerXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public static NamedPolicy fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                token = parser.nextToken();
            }
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
            }
            String policyType = parser.currentName();
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
            }
            NamedPolicy policy = PARSER.parse(parser, policyType);
            token = parser.nextToken();
            if (token != XContentParser.Token.END_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
            }
            return policy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedPolicy that = (NamedPolicy)o;
            return this.name.equals(that.name) && this.policy.equals(that.policy);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.policy);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
            EnrichPolicy.declareCommonConstructorParsingOptions(PARSER);
        }
    }
}

