/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.upgrades;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.upgrades.SystemIndexMigrationTaskState;

class SystemIndexMigrationInfo
implements Comparable<SystemIndexMigrationInfo> {
    private static final Logger logger = LogManager.getLogger(SystemIndexMigrationInfo.class);
    private final IndexMetadata currentIndex;
    private final String featureName;
    private final Settings settings;
    private final String mapping;
    private final String origin;
    private final SystemIndices.Feature owningFeature;
    private final boolean allowsTemplates;
    private static final Comparator<SystemIndexMigrationInfo> SAME_CLASS_COMPARATOR = Comparator.comparing(SystemIndexMigrationInfo::getFeatureName).thenComparing(SystemIndexMigrationInfo::getCurrentIndexName);

    private SystemIndexMigrationInfo(IndexMetadata currentIndex, String featureName, Settings settings, String mapping, String origin, SystemIndices.Feature owningFeature, boolean allowsTemplates) {
        this.currentIndex = currentIndex;
        this.featureName = featureName;
        this.settings = settings;
        this.mapping = mapping;
        this.origin = origin;
        this.owningFeature = owningFeature;
        this.allowsTemplates = allowsTemplates;
    }

    String getCurrentIndexName() {
        return this.currentIndex.getIndex().getName();
    }

    boolean isCurrentIndexClosed() {
        return IndexMetadata.State.CLOSE.equals(this.currentIndex.getState());
    }

    String getNextIndexName() {
        return this.currentIndex.getIndex().getName() + "-reindexed-for-8";
    }

    String getFeatureName() {
        return this.featureName;
    }

    String getMappings() {
        return this.mapping;
    }

    Settings getSettings() {
        return this.settings;
    }

    String getOrigin() {
        return this.origin;
    }

    boolean allowsTemplates() {
        return this.allowsTemplates;
    }

    void prepareForIndicesMigration(ClusterService clusterService, Client client, ActionListener<Map<String, Object>> listener) {
        this.owningFeature.getPreMigrationFunction().prepareForIndicesMigration(clusterService, client, listener);
    }

    void indicesMigrationComplete(Map<String, Object> metadata, ClusterService clusterService, Client client, ActionListener<Boolean> listener) {
        this.owningFeature.getPostMigrationFunction().indicesMigrationComplete(metadata, clusterService, client, listener);
    }

    Client createClient(Client baseClient) {
        return new OriginSettingClient(baseClient, this.getOrigin());
    }

    @Override
    public int compareTo(SystemIndexMigrationInfo o) {
        return SAME_CLASS_COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "IndexUpgradeInfo[currentIndex='" + this.currentIndex.getIndex().getName() + "', featureName='" + this.featureName + "', settings=" + this.settings + ", mapping='" + this.mapping + "', origin='" + this.origin + "'";
    }

    static SystemIndexMigrationInfo build(IndexMetadata currentIndex, SystemIndexDescriptor descriptor, SystemIndices.Feature feature, IndexScopedSettings indexScopedSettings) {
        String mapping;
        Settings settings;
        if (descriptor.isAutomaticallyManaged()) {
            Settings.Builder settingsBuilder = Settings.builder();
            settingsBuilder.put(descriptor.getSettings());
            settingsBuilder.remove("index.version.created");
            settings = settingsBuilder.build();
            mapping = descriptor.getMappings();
        } else {
            settings = SystemIndexMigrationInfo.copySettingsForNewIndex(currentIndex.getSettings(), indexScopedSettings);
            mapping = currentIndex.mapping().source().string();
        }
        return new SystemIndexMigrationInfo(currentIndex, feature.getName(), settings, mapping, descriptor.getOrigin(), feature, descriptor.allowsTemplates());
    }

    private static Settings copySettingsForNewIndex(Settings currentIndexSettings, IndexScopedSettings indexScopedSettings) {
        Settings.Builder newIndexSettings = Settings.builder();
        currentIndexSettings.keySet().stream().filter(settingKey -> !indexScopedSettings.isPrivateSetting((String)settingKey)).map(indexScopedSettings::get).filter(Objects::nonNull).filter(setting -> !setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)).filter(setting -> !setting.getProperties().contains((Object)Setting.Property.PrivateIndex)).forEach(setting -> newIndexSettings.put(setting.getKey(), currentIndexSettings.get(setting.getKey())));
        return newIndexSettings.build();
    }

    static Stream<SystemIndexMigrationInfo> fromFeature(SystemIndices.Feature feature, Metadata metadata, IndexScopedSettings indexScopedSettings) {
        return feature.getIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(metadata).stream().map(metadata::index).filter(imd -> {
            assert (imd != null) : "got null IndexMetadata for index in system index descriptor [" + descriptor.getIndexPattern() + "]";
            return Objects.nonNull(imd);
        }).map(imd -> SystemIndexMigrationInfo.build(imd, descriptor, feature, indexScopedSettings)));
    }

    static SystemIndexMigrationInfo fromTaskState(SystemIndexMigrationTaskState taskState, SystemIndices systemIndices, Metadata metadata, IndexScopedSettings indexScopedSettings) {
        SystemIndexDescriptor descriptor = systemIndices.findMatchingDescriptor(taskState.getCurrentIndex());
        SystemIndices.Feature feature = systemIndices.getFeature(taskState.getCurrentFeature());
        IndexMetadata imd = metadata.index(taskState.getCurrentIndex());
        if (descriptor == null) {
            String errorMsg = Strings.format("couldn't find system index descriptor for index [%s] from feature [%s], which likely means this node is missing a plugin", taskState.getCurrentIndex(), taskState.getCurrentFeature());
            logger.warn(errorMsg);
            assert (false) : errorMsg;
            throw new IllegalStateException(errorMsg);
        }
        if (imd == null) {
            String errorMsg = Strings.format("couldn't find index [%s] from feature [%s] with descriptor pattern [%s]", taskState.getCurrentIndex(), taskState.getCurrentFeature(), descriptor.getIndexPattern());
            logger.warn(errorMsg);
            assert (false) : errorMsg;
            throw new IllegalStateException(errorMsg);
        }
        return SystemIndexMigrationInfo.build(imd, descriptor, feature, indexScopedSettings);
    }
}

