/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.RemoteClusterCredentialsManager;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class RemoteConnectionManager
implements ConnectionManager {
    private final String clusterAlias;
    private final RemoteClusterCredentialsManager credentialsManager;
    private final ConnectionManager delegate;
    private final AtomicLong counter = new AtomicLong();
    private volatile List<DiscoveryNode> connectedNodes = Collections.emptyList();

    RemoteConnectionManager(String clusterAlias, RemoteClusterCredentialsManager credentialsManager, ConnectionManager delegate) {
        this.clusterAlias = clusterAlias;
        this.credentialsManager = credentialsManager;
        this.delegate = delegate;
        this.delegate.addListener(new TransportConnectionListener(){

            @Override
            public void onNodeConnected(DiscoveryNode node, Transport.Connection connection) {
                RemoteConnectionManager.this.addConnectedNode(node);
            }

            @Override
            public void onNodeDisconnected(DiscoveryNode node, Transport.Connection connection) {
                RemoteConnectionManager.this.removeConnectedNode(node);
            }
        });
    }

    public RemoteClusterCredentialsManager getCredentialsManager() {
        return this.credentialsManager;
    }

    @Override
    public final void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ConnectionManager.ConnectionValidator connectionValidator, ActionListener<Releasable> listener) throws ConnectTransportException {
        assert (false) : "use connectToRemoteClusterNode instead";
        listener.onFailure(new UnsupportedOperationException("use connectToRemoteClusterNode instead"));
    }

    public void connectToRemoteClusterNode(DiscoveryNode node, ConnectionManager.ConnectionValidator connectionValidator, ActionListener<Void> listener) throws ConnectTransportException {
        this.delegate.connectToNode(node, null, connectionValidator, listener.map(connectionReleasable -> null));
    }

    @Override
    public void addListener(TransportConnectionListener listener) {
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(TransportConnectionListener listener) {
        this.delegate.removeListener(listener);
    }

    @Override
    public void openConnection(DiscoveryNode node, @Nullable ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        assert (profile == null || profile.getTransportProfile().equals(this.getConnectionProfile().getTransportProfile())) : "A single remote connection manager can only ever handle a single transport profile";
        this.delegate.openConnection(node, profile, listener.delegateFailureAndWrap((l, connection) -> l.onResponse(RemoteConnectionManager.wrapConnectionWithRemoteClusterInfo(connection, this.clusterAlias, this.credentialsManager))));
    }

    @Override
    public Transport.Connection getConnection(DiscoveryNode node) {
        try {
            return this.getConnectionInternal(node);
        }
        catch (NodeNotConnectedException e) {
            return new ProxyConnection(this.getAnyRemoteConnection(), node);
        }
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.delegate.nodeConnected(node);
    }

    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        this.delegate.disconnectFromNode(node);
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.delegate.getConnectionProfile();
    }

    public Transport.Connection getAnyRemoteConnection() {
        long curr;
        List<DiscoveryNode> localConnectedNodes = this.connectedNodes;
        while ((curr = this.counter.incrementAndGet()) == Long.MIN_VALUE) {
        }
        if (!localConnectedNodes.isEmpty()) {
            DiscoveryNode nextNode = localConnectedNodes.get(Math.floorMod(curr, localConnectedNodes.size()));
            try {
                return this.getConnectionInternal(nextNode);
            }
            catch (NodeNotConnectedException nodeNotConnectedException) {
                // empty catch block
            }
        }
        Set<DiscoveryNode> allConnectionNodes = this.getAllConnectedNodes();
        for (DiscoveryNode connectedNode : allConnectionNodes) {
            try {
                return this.getConnectionInternal(connectedNode);
            }
            catch (NodeNotConnectedException nodeNotConnectedException) {
            }
        }
        throw new ConnectTransportException(null, "Unable to connect to [" + this.clusterAlias + "]");
    }

    @Override
    public Set<DiscoveryNode> getAllConnectedNodes() {
        return this.delegate.getAllConnectedNodes();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void close() {
        this.delegate.closeNoBlock();
    }

    @Override
    public void closeNoBlock() {
        this.delegate.closeNoBlock();
    }

    public static Optional<String> resolveRemoteClusterAlias(Transport.Connection connection) {
        return RemoteConnectionManager.resolveRemoteClusterAliasWithCredentials(connection).map(RemoteClusterAliasWithCredentials::clusterAlias);
    }

    public static Optional<RemoteClusterAliasWithCredentials> resolveRemoteClusterAliasWithCredentials(Transport.Connection connection) {
        Transport.Connection unwrapped = TransportService.unwrapConnection(connection);
        if (unwrapped instanceof InternalRemoteConnection) {
            InternalRemoteConnection remoteConnection = (InternalRemoteConnection)unwrapped;
            return Optional.of(new RemoteClusterAliasWithCredentials(remoteConnection.getClusterAlias(), remoteConnection.getClusterCredentials()));
        }
        return Optional.empty();
    }

    private Transport.Connection getConnectionInternal(DiscoveryNode node) throws NodeNotConnectedException {
        Transport.Connection connection = this.delegate.getConnection(node);
        return RemoteConnectionManager.wrapConnectionWithRemoteClusterInfo(connection, this.clusterAlias, this.credentialsManager);
    }

    private synchronized void addConnectedNode(DiscoveryNode addedNode) {
        this.connectedNodes = CollectionUtils.appendToCopy(this.connectedNodes, addedNode);
    }

    private synchronized void removeConnectedNode(DiscoveryNode removedNode) {
        int newSize = this.connectedNodes.size() - 1;
        ArrayList<DiscoveryNode> newConnectedNodes = new ArrayList<DiscoveryNode>(newSize);
        for (DiscoveryNode connectedNode : this.connectedNodes) {
            if (connectedNode.equals(removedNode)) continue;
            newConnectedNodes.add(connectedNode);
        }
        assert (newConnectedNodes.size() == newSize) : "Expected connection node count: " + newSize + ", Found: " + newConnectedNodes.size();
        this.connectedNodes = Collections.unmodifiableList(newConnectedNodes);
    }

    static InternalRemoteConnection wrapConnectionWithRemoteClusterInfo(Transport.Connection connection, String clusterAlias, RemoteClusterCredentialsManager credentialsManager) {
        return new InternalRemoteConnection(connection, clusterAlias, credentialsManager.resolveCredentials(clusterAlias));
    }

    static final class ProxyConnection
    implements Transport.Connection {
        private final Transport.Connection connection;
        private final DiscoveryNode targetNode;

        private ProxyConnection(Transport.Connection connection, DiscoveryNode targetNode) {
            this.connection = connection;
            this.targetNode = targetNode;
        }

        @Override
        public DiscoveryNode getNode() {
            return this.targetNode;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            this.connection.sendRequest(requestId, TransportActionProxy.getProxyAction(action), TransportActionProxy.wrapRequest(this.targetNode, request), options);
        }

        @Override
        public void close() {
            assert (false) : "proxy connections must not be closed";
        }

        @Override
        public void addCloseListener(ActionListener<Void> listener) {
            this.connection.addCloseListener(listener);
        }

        @Override
        public void addRemovedListener(ActionListener<Void> listener) {
            this.connection.addRemovedListener(listener);
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }

        @Override
        public TransportVersion getTransportVersion() {
            return this.connection.getTransportVersion();
        }

        @Override
        public Object getCacheKey() {
            return this.connection.getCacheKey();
        }

        Transport.Connection getConnection() {
            return this.connection;
        }

        @Override
        public void incRef() {
        }

        @Override
        public boolean tryIncRef() {
            return true;
        }

        @Override
        public boolean decRef() {
            assert (false) : "proxy connections must not be released";
            return false;
        }

        @Override
        public boolean hasReferences() {
            return true;
        }

        @Override
        public void onRemoved() {
        }
    }

    private static final class InternalRemoteConnection
    implements Transport.Connection {
        private static final Logger logger = LogManager.getLogger(InternalRemoteConnection.class);
        private final Transport.Connection connection;
        private final String clusterAlias;
        @Nullable
        private final SecureString clusterCredentials;

        private InternalRemoteConnection(Transport.Connection connection, String clusterAlias, @Nullable SecureString clusterCredentials) {
            assert (!(connection instanceof InternalRemoteConnection)) : "should not double wrap";
            assert (!(connection instanceof ProxyConnection)) : "proxy connection should wrap internal remote connection, not the other way around";
            this.connection = Objects.requireNonNull(connection);
            this.clusterAlias = Objects.requireNonNull(clusterAlias);
            this.clusterCredentials = clusterCredentials;
        }

        public String getClusterAlias() {
            return this.clusterAlias;
        }

        @Nullable
        public SecureString getClusterCredentials() {
            return this.clusterCredentials;
        }

        @Override
        public DiscoveryNode getNode() {
            return this.connection.getNode();
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            String effectiveAction;
            if (this.clusterCredentials != null && "internal:transport/handshake".equals(action)) {
                logger.trace("sending remote cluster specific handshake to node [{}] of remote cluster [{}]", (Object)this.getNode(), (Object)this.clusterAlias);
                effectiveAction = "cluster:internal/remote_cluster/handshake";
            } else {
                effectiveAction = action;
            }
            this.connection.sendRequest(requestId, effectiveAction, request, options);
        }

        @Override
        public void addCloseListener(ActionListener<Void> listener) {
            this.connection.addCloseListener(listener);
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }

        @Override
        public TransportVersion getTransportVersion() {
            return this.connection.getTransportVersion();
        }

        @Override
        public Object getCacheKey() {
            return this.connection.getCacheKey();
        }

        @Override
        public void close() {
            this.connection.close();
        }

        @Override
        public void onRemoved() {
            this.connection.onRemoved();
        }

        @Override
        public void addRemovedListener(ActionListener<Void> listener) {
            this.connection.addRemovedListener(listener);
        }

        @Override
        public void incRef() {
            this.connection.incRef();
        }

        @Override
        public boolean tryIncRef() {
            return this.connection.tryIncRef();
        }

        @Override
        public boolean decRef() {
            return this.connection.decRef();
        }

        @Override
        public boolean hasReferences() {
            return this.connection.hasReferences();
        }
    }

    public record RemoteClusterAliasWithCredentials(String clusterAlias, @Nullable SecureString credentials) {
        @Override
        public String toString() {
            return "RemoteClusterAliasWithCredentials{clusterAlias='" + this.clusterAlias + "', credentials='::es_redacted::'}";
        }
    }
}

