/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.search.KnnByteVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.ProfilingQuery;

public class ESKnnByteVectorQuery
extends KnnByteVectorQuery
implements ProfilingQuery {
    private final Integer kParam;
    private long vectorOpsCount;

    public ESKnnByteVectorQuery(String field, byte[] target, Integer k, int numCands, Query filter) {
        super(field, target, numCands, filter);
        this.kParam = k;
    }

    @Override
    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        TopDocs topK = this.kParam == null ? super.mergeLeafResults(perLeafResults) : TopDocs.merge(this.kParam, perLeafResults);
        this.vectorOpsCount = topK.totalHits.value;
        return topK;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        queryProfiler.setVectorOpsCount(this.vectorOpsCount);
    }
}

