/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class StandardRetrieverBuilder
extends RetrieverBuilder
implements ToXContent {
    public static final String NAME = "standard";
    public static final NodeFeature STANDARD_RETRIEVER_SUPPORTED = new NodeFeature("standard_retriever_supported");
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField SEARCH_AFTER_FIELD = new ParseField("search_after", new String[0]);
    public static final ParseField TERMINATE_AFTER_FIELD = new ParseField("terminate_after", new String[0]);
    public static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
    public static final ParseField MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
    public static final ParseField COLLAPSE_FIELD = new ParseField("collapse", new String[0]);
    public static final ObjectParser<StandardRetrieverBuilder, RetrieverParserContext> PARSER = new ObjectParser("standard", StandardRetrieverBuilder::new);
    QueryBuilder queryBuilder;
    SearchAfterBuilder searchAfterBuilder;
    int terminateAfter = 0;
    List<SortBuilder<?>> sortBuilders;
    Float minScore;
    CollapseBuilder collapseBuilder;

    public static StandardRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (!context.clusterSupportsFeature(STANDARD_RETRIEVER_SUPPORTED)) {
            throw new ParsingException(parser.getTokenLocation(), "unknown retriever [standard]", new Object[0]);
        }
        return PARSER.apply(parser, context);
    }

    @Override
    public void extractToSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder, boolean compoundUsed) {
        if (!this.preFilterQueryBuilders.isEmpty()) {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            for (QueryBuilder preFilterQueryBuilder : this.preFilterQueryBuilders) {
                boolQueryBuilder.filter(preFilterQueryBuilder);
            }
            if (this.queryBuilder != null) {
                boolQueryBuilder.must(this.queryBuilder);
            }
            searchSourceBuilder.subSearches().add(new SubSearchSourceBuilder(boolQueryBuilder));
        } else if (this.queryBuilder != null) {
            searchSourceBuilder.subSearches().add(new SubSearchSourceBuilder(this.queryBuilder));
        }
        if (this.searchAfterBuilder != null) {
            if (compoundUsed) {
                throw new IllegalArgumentException("[" + SEARCH_AFTER_FIELD.getPreferredName() + "] cannot be used in children of compound retrievers");
            }
            searchSourceBuilder.searchAfter(this.searchAfterBuilder.getSortValues());
        }
        if (this.terminateAfter != 0) {
            if (compoundUsed) {
                throw new IllegalArgumentException("[" + TERMINATE_AFTER_FIELD.getPreferredName() + "] cannot be used in children of compound retrievers");
            }
            searchSourceBuilder.terminateAfter(this.terminateAfter);
        }
        if (this.sortBuilders != null) {
            if (compoundUsed) {
                throw new IllegalArgumentException("[" + SORT_FIELD.getPreferredName() + "] cannot be used in children of compound retrievers");
            }
            searchSourceBuilder.sort(this.sortBuilders);
        }
        if (this.minScore != null) {
            if (compoundUsed) {
                throw new IllegalArgumentException("[" + MIN_SCORE_FIELD.getPreferredName() + "] cannot be used in children of compound retrievers");
            }
            searchSourceBuilder.minScore(this.minScore.floatValue());
        }
        if (this.collapseBuilder != null) {
            if (compoundUsed) {
                throw new IllegalArgumentException("[" + COLLAPSE_FIELD.getPreferredName() + "] cannot be used in children of compound retrievers");
            }
            searchSourceBuilder.collapse(this.collapseBuilder);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.queryBuilder != null) {
            builder.field(QUERY_FIELD.getPreferredName(), this.queryBuilder);
        }
        if (this.searchAfterBuilder != null) {
            this.searchAfterBuilder.innerToXContent(builder);
        }
        if (this.terminateAfter != 0) {
            builder.field(TERMINATE_AFTER_FIELD.getPreferredName(), this.terminateAfter);
        }
        if (this.sortBuilders != null) {
            builder.field(SORT_FIELD.getPreferredName(), (Iterable<?>)this.sortBuilders);
        }
        if (this.minScore != null) {
            builder.field(MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
        if (this.collapseBuilder != null) {
            builder.field(COLLAPSE_FIELD.getPreferredName(), this.collapseBuilder);
        }
    }

    @Override
    public boolean doEquals(Object o) {
        StandardRetrieverBuilder that = (StandardRetrieverBuilder)o;
        return this.terminateAfter == that.terminateAfter && Objects.equals(this.queryBuilder, that.queryBuilder) && Objects.equals(this.searchAfterBuilder, that.searchAfterBuilder) && Objects.equals(this.sortBuilders, that.sortBuilders) && Objects.equals(this.minScore, that.minScore) && Objects.equals(this.collapseBuilder, that.collapseBuilder);
    }

    @Override
    public int doHashCode() {
        return Objects.hash(this.queryBuilder, this.searchAfterBuilder, this.terminateAfter, this.sortBuilders, this.minScore, this.collapseBuilder);
    }

    static {
        PARSER.declareObject((r, v) -> {
            r.queryBuilder = v;
        }, (p, c) -> {
            QueryBuilder queryBuilder = AbstractQueryBuilder.parseTopLevelQuery(p, c::trackQueryUsage);
            c.trackSectionUsage("standard:" + QUERY_FIELD.getPreferredName());
            return queryBuilder;
        }, QUERY_FIELD);
        PARSER.declareField((r, v) -> {
            r.searchAfterBuilder = v;
        }, (p, c) -> {
            SearchAfterBuilder searchAfterBuilder = SearchAfterBuilder.fromXContent(p);
            c.trackSectionUsage("standard:" + SEARCH_AFTER_FIELD.getPreferredName());
            return searchAfterBuilder;
        }, SEARCH_AFTER_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareField((r, v) -> {
            r.terminateAfter = v;
        }, (p, c) -> {
            int terminateAfter = p.intValue();
            c.trackSectionUsage("standard:" + TERMINATE_AFTER_FIELD.getPreferredName());
            return terminateAfter;
        }, TERMINATE_AFTER_FIELD, ObjectParser.ValueType.INT);
        PARSER.declareField((r, v) -> {
            r.sortBuilders = v;
        }, (p, c) -> {
            List<SortBuilder<?>> sortBuilders = SortBuilder.fromXContent(p);
            c.trackSectionUsage("standard:" + SORT_FIELD.getPreferredName());
            return sortBuilders;
        }, SORT_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareField((r, v) -> {
            r.minScore = v;
        }, (p, c) -> {
            float minScore = p.floatValue();
            c.trackSectionUsage("standard:" + MIN_SCORE_FIELD.getPreferredName());
            return Float.valueOf(minScore);
        }, MIN_SCORE_FIELD, ObjectParser.ValueType.FLOAT);
        PARSER.declareField((r, v) -> {
            r.collapseBuilder = v;
        }, (p, c) -> {
            CollapseBuilder collapseBuilder = CollapseBuilder.fromXContent(p);
            if (collapseBuilder.getField() != null) {
                c.trackSectionUsage(COLLAPSE_FIELD.getPreferredName());
            }
            return collapseBuilder;
        }, COLLAPSE_FIELD, ObjectParser.ValueType.OBJECT);
        RetrieverBuilder.declareBaseParserFields(NAME, PARSER);
    }
}

