/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.search.vectors.KnnSearchBuilder;
import org.elasticsearch.search.vectors.QueryVectorBuilder;
import org.elasticsearch.search.vectors.VectorData;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class KnnRetrieverBuilder
extends RetrieverBuilder {
    public static final String NAME = "knn";
    public static final NodeFeature KNN_RETRIEVER_SUPPORTED = new NodeFeature("knn_retriever_supported");
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField K_FIELD = new ParseField("k", new String[0]);
    public static final ParseField NUM_CANDS_FIELD = new ParseField("num_candidates", new String[0]);
    public static final ParseField QUERY_VECTOR_FIELD = new ParseField("query_vector", new String[0]);
    public static final ParseField QUERY_VECTOR_BUILDER_FIELD = new ParseField("query_vector_builder", new String[0]);
    public static final ParseField VECTOR_SIMILARITY = new ParseField("similarity", new String[0]);
    public static final ConstructingObjectParser<KnnRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("knn", args -> {
        float[] vectorArray;
        List vector = (List)args[1];
        if (vector != null) {
            vectorArray = new float[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                vectorArray[i] = ((Float)vector.get(i)).floatValue();
            }
        } else {
            vectorArray = null;
        }
        return new KnnRetrieverBuilder((String)args[0], vectorArray, (QueryVectorBuilder)args[2], (Integer)args[3], (Integer)args[4], (Float)args[5]);
    });
    private final String field;
    private final float[] queryVector;
    private final QueryVectorBuilder queryVectorBuilder;
    private final int k;
    private final int numCands;
    private final Float similarity;

    public static KnnRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (!context.clusterSupportsFeature(KNN_RETRIEVER_SUPPORTED)) {
            throw new ParsingException(parser.getTokenLocation(), "unknown retriever [knn]", new Object[0]);
        }
        return PARSER.apply(parser, context);
    }

    public KnnRetrieverBuilder(String field, float[] queryVector, QueryVectorBuilder queryVectorBuilder, int k, int numCands, Float similarity) {
        this.field = field;
        this.queryVector = queryVector;
        this.queryVectorBuilder = queryVectorBuilder;
        this.k = k;
        this.numCands = numCands;
        this.similarity = similarity;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void extractToSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder, boolean compoundUsed) {
        KnnSearchBuilder knnSearchBuilder = new KnnSearchBuilder(this.field, VectorData.fromFloats(this.queryVector), this.queryVectorBuilder, this.k, this.numCands, this.similarity);
        if (this.preFilterQueryBuilders != null) {
            knnSearchBuilder.addFilterQueries(this.preFilterQueryBuilders);
        }
        if (this.retrieverName != null) {
            knnSearchBuilder.queryName(this.retrieverName);
        }
        ArrayList<KnnSearchBuilder> knnSearchBuilders = new ArrayList<KnnSearchBuilder>(searchSourceBuilder.knnSearch());
        knnSearchBuilders.add(knnSearchBuilder);
        searchSourceBuilder.knnSearch(knnSearchBuilders);
    }

    @Override
    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(K_FIELD.getPreferredName(), this.k);
        builder.field(NUM_CANDS_FIELD.getPreferredName(), this.numCands);
        if (this.queryVector != null) {
            builder.field(QUERY_VECTOR_FIELD.getPreferredName(), this.queryVector);
        }
        if (this.queryVectorBuilder != null) {
            builder.field(QUERY_VECTOR_BUILDER_FIELD.getPreferredName(), this.queryVectorBuilder);
        }
        if (this.similarity != null) {
            builder.field(VECTOR_SIMILARITY.getPreferredName(), this.similarity);
        }
    }

    @Override
    public boolean doEquals(Object o) {
        KnnRetrieverBuilder that = (KnnRetrieverBuilder)o;
        return this.k == that.k && this.numCands == that.numCands && Objects.equals(this.field, that.field) && Arrays.equals(this.queryVector, that.queryVector) && Objects.equals(this.queryVectorBuilder, that.queryVectorBuilder) && Objects.equals(this.similarity, that.similarity);
    }

    @Override
    public int doHashCode() {
        int result = Objects.hash(this.field, this.queryVectorBuilder, this.k, this.numCands, this.similarity);
        result = 31 * result + Arrays.hashCode(this.queryVector);
        return result;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareFloatArray(ConstructingObjectParser.optionalConstructorArg(), QUERY_VECTOR_FIELD);
        PARSER.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(QueryVectorBuilder.class, n, c), QUERY_VECTOR_BUILDER_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), K_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUM_CANDS_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), VECTOR_SIMILARITY);
        RetrieverBuilder.declareBaseParserFields(NAME, PARSER);
    }
}

